/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.logistics.tileentity;

import java.util.Collection;
import java.util.EnumMap;
import java.util.Set;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.util.Brightness;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import xyz.xenondevs.commons.provider.Provider;
import xyz.xenondevs.invui.gui.Gui;
import xyz.xenondevs.invui.item.Item;
import xyz.xenondevs.invui.item.ItemProvider;
import xyz.xenondevs.invui.item.builder.ItemBuilder;
import xyz.xenondevs.invui.item.impl.AbstractItem;
import xyz.xenondevs.nova.data.config.Reloadable;
import xyz.xenondevs.nova.data.serialization.DataHolder;
import xyz.xenondevs.nova.data.world.block.state.NovaTileEntityState;
import xyz.xenondevs.nova.logistics.registry.Items;
import xyz.xenondevs.nova.logistics.tileentity.FluidStorageUnit;
import xyz.xenondevs.nova.logistics.tileentity.FluidStorageUnitKt;
import xyz.xenondevs.nova.tileentity.NetworkedTileEntity;
import xyz.xenondevs.nova.tileentity.TileEntity;
import xyz.xenondevs.nova.tileentity.menu.TileEntityMenuClass;
import xyz.xenondevs.nova.tileentity.network.NetworkConnectionType;
import xyz.xenondevs.nova.tileentity.network.NetworkEndPoint;
import xyz.xenondevs.nova.tileentity.network.fluid.FluidType;
import xyz.xenondevs.nova.tileentity.network.fluid.container.FluidContainer;
import xyz.xenondevs.nova.tileentity.network.fluid.holder.FluidHolder;
import xyz.xenondevs.nova.tileentity.network.fluid.holder.NovaFluidHolder;
import xyz.xenondevs.nova.tileentity.network.fluid.holder.NovaFluidHolderKt;
import xyz.xenondevs.nova.ui.FluidBar;
import xyz.xenondevs.nova.ui.config.side.OpenSideConfigItem;
import xyz.xenondevs.nova.ui.config.side.SideConfigMenu;
import xyz.xenondevs.nova.util.BlockSide;
import xyz.xenondevs.nova.util.NMSUtilsKt;
import xyz.xenondevs.nova.world.fakeentity.impl.FakeItemDisplay;
import xyz.xenondevs.nova.world.fakeentity.metadata.impl.ItemDisplayMetadata;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u0013B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lxyz/xenondevs/nova/logistics/tileentity/FluidStorageUnit;", "Lxyz/xenondevs/nova/tileentity/NetworkedTileEntity;", "Lxyz/xenondevs/nova/data/config/Reloadable;", "blockState", "Lxyz/xenondevs/nova/data/world/block/state/NovaTileEntityState;", "(Lxyz/xenondevs/nova/data/world/block/state/NovaTileEntityState;)V", "fluidHolder", "Lxyz/xenondevs/nova/tileentity/network/fluid/holder/NovaFluidHolder;", "getFluidHolder", "()Lxyz/xenondevs/nova/tileentity/network/fluid/holder/NovaFluidHolder;", "fluidLevel", "Lxyz/xenondevs/nova/world/fakeentity/impl/FakeItemDisplay;", "fluidTank", "Lxyz/xenondevs/nova/tileentity/network/fluid/container/FluidContainer;", "handleFluidUpdate", "", "handleRemoved", "unload", "", "FluidStorageUnitMenu", "logistics"})
public final class FluidStorageUnit
extends NetworkedTileEntity
implements Reloadable {
    @NotNull
    private final FluidContainer fluidTank;
    @NotNull
    private final FakeItemDisplay fluidLevel;
    @NotNull
    private final NovaFluidHolder fluidHolder;

    public FluidStorageUnit(@NotNull NovaTileEntityState blockState) {
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        super(blockState);
        Object[] objectArray = new FluidType[]{FluidType.LAVA, FluidType.WATER};
        this.fluidTank = TileEntity.getFluidContainer$default((TileEntity)((TileEntity)this), (String)"fluid", (Set)SetsKt.setOf((Object[])objectArray), (Provider)FluidStorageUnitKt.access$getMAX_CAPACITY$p(), (long)0L, (Function0)((Function0)new Function0<Unit>((Object)this){

            public final void invoke() {
                FluidStorageUnit.access$handleFluidUpdate((FluidStorageUnit)((Object)this.receiver));
            }
        }), (boolean)false, (int)32, null);
        Location location = this.getLocation().add(0.5, 0.5, 0.5);
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"location.add(.5, .5, .5)");
        this.fluidLevel = new FakeItemDisplay(location, false, (Function2)fluidLevel.1.INSTANCE, 2, null);
        this.fluidHolder = NovaFluidHolderKt.NovaFluidHolder$default((DataHolder)((DataHolder)this), (Pair)TuplesKt.to((Object)this.fluidTank, (Object)NetworkConnectionType.BUFFER), (Pair[])new Pair[0], null, (Function0)((Function0)new Function0<EnumMap<BlockFace, NetworkConnectionType>>(this){
            final /* synthetic */ FluidStorageUnit this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final EnumMap<BlockFace, NetworkConnectionType> invoke() {
                return this.this$0.createSideConfig(NetworkConnectionType.BUFFER, new BlockSide[0]);
            }
        }), (int)8, null);
        this.handleFluidUpdate();
    }

    @NotNull
    public NovaFluidHolder getFluidHolder() {
        return this.fluidHolder;
    }

    private final void handleFluidUpdate() {
        ItemStack itemStack;
        if (this.fluidTank.hasFluid()) {
            FluidType fluidType = this.fluidTank.getType();
            itemStack = ((ItemProvider)(switch (fluidType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[fluidType.ordinal()]) {
                case 1 -> Items.INSTANCE.getTANK_LAVA_LEVELS();
                case 2 -> Items.INSTANCE.getTANK_WATER_LEVELS();
                default -> throw new IllegalStateException();
            }).getClientsideProviders().get(10)).get();
        } else {
            itemStack = null;
        }
        ItemStack stack = itemStack;
        this.fluidLevel.updateEntityData(true, (Function1)new Function1<ItemDisplayMetadata, Unit>(this, stack){
            final /* synthetic */ FluidStorageUnit this$0;
            final /* synthetic */ ItemStack $stack;
            {
                this.this$0 = $receiver;
                this.$stack = $stack;
                super(1);
            }

            public final void invoke(@NotNull ItemDisplayMetadata $this$updateEntityData) {
                Intrinsics.checkNotNullParameter((Object)$this$updateEntityData, (String)"$this$updateEntityData");
                $this$updateEntityData.setBrightness((Brightness)(FluidStorageUnit.access$getFluidTank$p(this.this$0).getType() == FluidType.LAVA ? Brightness.c : null));
                $this$updateEntityData.setItemStack(NMSUtilsKt.getNmsCopy((ItemStack)this.$stack));
            }
        });
    }

    public void handleRemoved(boolean unload) {
        super.handleRemoved(unload);
        this.fluidLevel.remove();
    }

    public static final /* synthetic */ void access$handleFluidUpdate(FluidStorageUnit $this) {
        $this.handleFluidUpdate();
    }

    @TileEntityMenuClass
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\u0004\u0018\u00002\u00060\u0001R\u00020\u0002:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\f"}, d2={"Lxyz/xenondevs/nova/logistics/tileentity/FluidStorageUnit$FluidStorageUnitMenu;", "Lxyz/xenondevs/nova/tileentity/TileEntity$GlobalTileEntityMenu;", "Lxyz/xenondevs/nova/tileentity/TileEntity;", "(Lxyz/xenondevs/nova/logistics/tileentity/FluidStorageUnit;)V", "SideConfigMenu", "Lxyz/xenondevs/nova/ui/config/side/SideConfigMenu;", "gui", "Lxyz/xenondevs/invui/gui/Gui;", "Lorg/jetbrains/annotations/NotNull;", "getGui", "()Lxyz/xenondevs/invui/gui/Gui;", "FluidStorageUnitDisplay", "logistics"})
    public final class FluidStorageUnitMenu
    extends TileEntity.GlobalTileEntityMenu {
        @NotNull
        private final SideConfigMenu SideConfigMenu;
        @NotNull
        private final Gui gui;

        public FluidStorageUnitMenu() {
            super((TileEntity)FluidStorageUnit.this, null, 1, null);
            this.SideConfigMenu = new SideConfigMenu((NetworkEndPoint)FluidStorageUnit.this, null, CollectionsKt.listOf((Object)TuplesKt.to((Object)FluidStorageUnit.this.fluidTank, (Object)"container.nova.fluid_tank")), (Function1)new Function1<Player, Unit>((Object)this){

                public final void invoke(@NotNull Player p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    ((FluidStorageUnitMenu)((Object)this.receiver)).openWindow(p0);
                }
            }, 2, null);
            String[] stringArray = new String[]{"1 - - - - - - - 2", "| s # # # # # f |", "| # # # d # # f |", "| # # # # # # f |", "3 - - - - - - - 4"};
            Gui gui = ((Gui.Builder.Normal)((Gui.Builder.Normal)((Gui.Builder.Normal)((Gui.Builder.Normal)Gui.normal().setStructure(stringArray)).addIngredient('s', (Item)new OpenSideConfigItem(this.SideConfigMenu))).addIngredient('d', (Item)new FluidStorageUnitDisplay())).addIngredient('f', (Supplier)new FluidBar(3, (FluidHolder)FluidStorageUnit.this.getFluidHolder(), FluidStorageUnit.this.fluidTank))).build();
            Intrinsics.checkNotNullExpressionValue((Object)gui, (String)"normal()\n            .se\u2026nk))\n            .build()");
            this.gui = gui;
        }

        @NotNull
        public Gui getGui() {
            return this.gui;
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lxyz/xenondevs/nova/logistics/tileentity/FluidStorageUnit$FluidStorageUnitMenu$FluidStorageUnitDisplay;", "Lxyz/xenondevs/invui/item/impl/AbstractItem;", "(Lxyz/xenondevs/nova/logistics/tileentity/FluidStorageUnit$FluidStorageUnitMenu;)V", "getItemProvider", "Lxyz/xenondevs/invui/item/ItemProvider;", "handleClick", "", "clickType", "Lorg/bukkit/event/inventory/ClickType;", "player", "Lorg/bukkit/entity/Player;", "event", "Lorg/bukkit/event/inventory/InventoryClickEvent;", "logistics"})
        private final class FluidStorageUnitDisplay
        extends AbstractItem {
            public FluidStorageUnitDisplay() {
                ((Collection)FluidStorageUnit.this.fluidTank.getUpdateHandlers()).add(new Function0<Unit>(){

                    public final void invoke() {
                        this.notifyWindows();
                    }
                });
            }

            @NotNull
            public ItemProvider getItemProvider() {
                FluidType fluidType = FluidStorageUnit.this.fluidTank.getType();
                if (fluidType == null || (fluidType = fluidType.getBucket()) == null) {
                    Object object = new ItemBuilder(Material.BARRIER).setDisplayName("\u00a7r");
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ItemBuilder(Material.BARRIER).setDisplayName(\"\u00a7r\")");
                    return (ItemProvider)object;
                }
                FluidType type = fluidType;
                long amount = FluidStorageUnit.this.fluidTank.getAmount();
                Object object = ((ItemBuilder)new ItemBuilder((ItemStack)type).setDisplayName("\u00a7a" + amount + " \u00a77mB")).setAmount(1);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ItemBuilder(type).setDis\u2026mount \u00a77mB\").setAmount(1)");
                return (ItemProvider)object;
            }

            public void handleClick(@NotNull ClickType clickType, @NotNull Player player, @NotNull InventoryClickEvent event) {
                Intrinsics.checkNotNullParameter((Object)clickType, (String)"clickType");
                Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FluidType.values().length];
            try {
                nArray[FluidType.LAVA.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FluidType.WATER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

