/*
 * Decompiled with CFR 0.152.
 */
package com.xSavior_of_God.HappyNewYear.utils;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import com.xSavior_of_God.HappyNewYear.HappyNewYear;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.entity.Player;
import org.bukkit.plugin.InvalidDescriptionException;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginManager;
import org.yaml.snakeyaml.error.YAMLException;

public class Reload {
    static final String packageName = Bukkit.getServer().getClass().getPackage().getName();
    static final String nms = packageName.equals("org.bukkit.craftbukkit") ? "." : "." + packageName.split("\\.")[3] + ".";
    static boolean nmsVers = true;

    public static PluginDescriptionFile getPluginDescription(File file) throws InvalidDescriptionException {
        if (file == null) {
            throw new InvalidDescriptionException("File cannot be null");
        }
        JarFile jar = null;
        InputStream stream = null;
        try {
            jar = new JarFile(file);
            JarEntry entry = jar.getJarEntry("plugin.yml");
            if (entry == null) {
                throw new InvalidDescriptionException((Throwable)new FileNotFoundException("Jar does not contain plugin.yml"));
            }
            stream = jar.getInputStream(entry);
            PluginDescriptionFile pluginDescriptionFile = new PluginDescriptionFile(stream);
            return pluginDescriptionFile;
        }
        catch (IOException | YAMLException ex) {
            throw new InvalidDescriptionException(ex);
        }
        finally {
            if (jar != null) {
                try {
                    jar.close();
                }
                catch (IOException iOException) {}
            }
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void load(String name) {
        Plugin target = null;
        boolean paperLoaded = false;
        File pluginDir = new File("plugins");
        if (!pluginDir.isDirectory()) {
            return;
        }
        File pluginFile = new File(pluginDir, name + ".jar");
        if (!pluginFile.isFile()) {
            for (File f : pluginDir.listFiles()) {
                if (!f.getName().endsWith(".jar")) continue;
                try {
                    PluginDescriptionFile desc = Reload.getPluginDescription(f);
                    if (!desc.getName().equalsIgnoreCase(name)) continue;
                    pluginFile = f;
                    break;
                }
                catch (Exception e) {
                    return;
                }
            }
        }
        try {
            Class<?> paper = Class.forName("io.papermc.paper.plugin.manager.PaperPluginManagerImpl");
            Object paperPluginManagerImpl = paper.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
            Field instanceManagerF = paperPluginManagerImpl.getClass().getDeclaredField("instanceManager");
            instanceManagerF.setAccessible(true);
            Object instanceManager = instanceManagerF.get(paperPluginManagerImpl);
            Method loadMethod = instanceManager.getClass().getMethod("loadPlugin", Path.class);
            loadMethod.setAccessible(true);
            target = (Plugin)loadMethod.invoke(instanceManager, pluginFile.toPath());
            Method enableMethod = instanceManager.getClass().getMethod("enablePlugin", Plugin.class);
            enableMethod.setAccessible(true);
            enableMethod.invoke(instanceManager, target);
            paperLoaded = true;
        }
        catch (Exception paper) {
            // empty catch block
        }
        if (!paperLoaded) {
            try {
                target = Bukkit.getPluginManager().loadPlugin(pluginFile);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            target.onLoad();
            Bukkit.getPluginManager().enablePlugin(target);
        }
        Plugin finalTarget = target;
        Bukkit.getScheduler().runTaskLater(Bukkit.getPluginManager().getPlugins()[0], () -> Reload.loadCommands(finalTarget), 10L);
    }

    public static List<Map.Entry<String, Command>> getCommandsFromPlugin(Plugin plugin) {
        Field pluginClassLoaderPlugin;
        Class<?> pluginClassLoader;
        try {
            pluginClassLoader = Class.forName("org.bukkit.plugin.java.PluginClassLoader");
            pluginClassLoaderPlugin = pluginClassLoader.getDeclaredField("plugin");
            pluginClassLoaderPlugin.setAccessible(true);
        }
        catch (ClassNotFoundException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        Map<String, Command> knownCommands = Reload.getKnownCommands();
        return knownCommands.entrySet().stream().filter(s -> {
            if (((String)s.getKey()).contains(":")) {
                return ((String)s.getKey()).split(":")[0].equalsIgnoreCase(plugin.getName());
            }
            ClassLoader cl = ((Command)s.getValue()).getClass().getClassLoader();
            try {
                return cl.getClass() == pluginClassLoader && pluginClassLoaderPlugin.get(cl) == plugin;
            }
            catch (IllegalAccessException e) {
                return false;
            }
        }).collect(Collectors.toList());
    }

    public static void loadCommands(Plugin plugin) {
        PluginManager pluginManager = Bukkit.getPluginManager();
        List<Map.Entry<String, Command>> commands = Reload.getCommandsFromPlugin(plugin);
        for (Map.Entry<String, Command> entry : commands) {
            String alias = entry.getKey();
            Command command = entry.getValue();
            Reload.wrap(command, alias);
        }
        Reload.sync();
    }

    public static void reload() {
        try {
            Class.forName("net.minecraft.server.MinecraftServer");
            nmsVers = false;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        String pluginName = HappyNewYear.instance.getName();
        Reload.unload(pluginName);
        System.out.println("Unloading '" + pluginName + "' plugin");
        Reload.load(pluginName);
    }

    public static void unload(String plName) {
        block40: {
            String alias;
            Map listeners;
            Map commands;
            Map names;
            List plugins;
            SimpleCommandMap commandMap;
            String name;
            Plugin plugin;
            boolean reloadlisteners;
            List pluginList;
            Map lookupNames;
            block39: {
                lookupNames = null;
                pluginList = null;
                reloadlisteners = true;
                plugin = Bukkit.getPluginManager().getPlugin(plName);
                name = plugin.getName();
                PluginManager pluginManager = Bukkit.getPluginManager();
                commandMap = null;
                plugins = null;
                names = null;
                commands = null;
                listeners = null;
                pluginManager.disablePlugin(plugin);
                try {
                    Object instanceManager;
                    Class<?> paper;
                    int n;
                    Class.forName("io.papermc.paper.plugin.manager.PaperPluginManagerImpl");
                    String[] version = Bukkit.getBukkitVersion().split("-")[0].split("\\.");
                    int n2 = Integer.parseInt(version[1]) * 100;
                    if (version.length >= 3) {
                        n = n2 + Integer.parseInt(version[2]);
                    }
                    if (n >= 2005) {
                        paper = Class.forName("io.papermc.paper.plugin.manager.PaperPluginManagerImpl");
                        Object object = paper.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
                        Field instanceManagerField = object.getClass().getDeclaredField("instanceManager");
                        instanceManagerField.setAccessible(true);
                        instanceManager = instanceManagerField.get(object);
                        Field lookupNamesField = instanceManager.getClass().getDeclaredField("lookupNames");
                        lookupNamesField.setAccessible(true);
                        lookupNames = (Map)lookupNamesField.get(instanceManager);
                        Field pluginsField = instanceManager.getClass().getDeclaredField("plugins");
                        pluginsField.setAccessible(true);
                        pluginList = (List)pluginsField.get(instanceManager);
                        pluginsField = Bukkit.getPluginManager().getClass().getDeclaredField("plugins");
                        pluginsField.setAccessible(true);
                        plugins = (List)pluginsField.get(pluginManager);
                        lookupNamesField = Bukkit.getPluginManager().getClass().getDeclaredField("lookupNames");
                        lookupNamesField.setAccessible(true);
                        names = (Map)lookupNamesField.get(pluginManager);
                        try {
                            Field listenersField = Bukkit.getPluginManager().getClass().getDeclaredField("listeners");
                            listenersField.setAccessible(true);
                            listeners = (Map)listenersField.get(pluginManager);
                        }
                        catch (Exception e) {
                            reloadlisteners = false;
                        }
                        Field commandMapField = Bukkit.getPluginManager().getClass().getDeclaredField("commandMap");
                        commandMapField.setAccessible(true);
                        commandMap = (SimpleCommandMap)commandMapField.get(pluginManager);
                        Field knownCommandsField = SimpleCommandMap.class.getDeclaredField("knownCommands");
                        knownCommandsField.setAccessible(true);
                        commands = (Map)knownCommandsField.get(commandMap);
                        break block39;
                    }
                    paper = Class.forName("io.papermc.paper.plugin.manager.PaperPluginManagerImpl");
                    Object object = paper.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
                    Field instanceManagerF = object.getClass().getDeclaredField("instanceManager");
                    instanceManagerF.setAccessible(true);
                    instanceManager = instanceManagerF.get(object);
                    Field lookupNamesF = instanceManager.getClass().getDeclaredField("lookupNames");
                    lookupNamesF.setAccessible(true);
                    lookupNames = (Map)lookupNamesF.get(instanceManager);
                    Method disableMethod = instanceManager.getClass().getMethod("disablePlugin", Plugin.class);
                    disableMethod.setAccessible(true);
                    disableMethod.invoke(instanceManager, plugin);
                    Field pluginListF = instanceManager.getClass().getDeclaredField("plugins");
                    pluginListF.setAccessible(true);
                    pluginList = (List)pluginListF.get(instanceManager);
                }
                catch (Exception ignored) {
                    try {
                        Field field2 = Bukkit.getPluginManager().getClass().getDeclaredField("plugins");
                        field2.setAccessible(true);
                        plugins = (List)field2.get(pluginManager);
                        Field lookupNamesField = Bukkit.getPluginManager().getClass().getDeclaredField("lookupNames");
                        lookupNamesField.setAccessible(true);
                        names = (Map)lookupNamesField.get(pluginManager);
                        try {
                            Field field3 = Bukkit.getPluginManager().getClass().getDeclaredField("listeners");
                            field3.setAccessible(true);
                            listeners = (Map)field3.get(pluginManager);
                        }
                        catch (Exception exception) {
                            reloadlisteners = false;
                        }
                        Field field4 = Bukkit.getPluginManager().getClass().getDeclaredField("commandMap");
                        field4.setAccessible(true);
                        commandMap = (SimpleCommandMap)field4.get(pluginManager);
                        Field knownCommandsField = SimpleCommandMap.class.getDeclaredField("knownCommands");
                        knownCommandsField.setAccessible(true);
                        commands = (Map)knownCommandsField.get(commandMap);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        return;
                    }
                }
            }
            if (listeners != null && reloadlisteners) {
                for (SortedSet sortedSet : listeners.values()) {
                    sortedSet.removeIf(value -> value.getPlugin() == plugin);
                }
            }
            if (commandMap != null) {
                try {
                    Class.forName("io.papermc.paper.plugin.manager.PaperPluginManagerImpl");
                    for (Map.Entry entry : new HashSet(commands.entrySet())) {
                        if (entry.getValue() instanceof PluginCommand) {
                            PluginCommand c = (PluginCommand)entry.getValue();
                            if (!c.getPlugin().equals((Object)plugin)) continue;
                            c.unregister((CommandMap)commandMap);
                            commands.remove(entry.getKey());
                            continue;
                        }
                        try {
                            Field pluginField = Arrays.stream(((Command)entry.getValue()).getClass().getDeclaredFields()).filter(field -> Plugin.class.isAssignableFrom(field.getType())).findFirst().orElse(null);
                            if (pluginField == null) continue;
                            try {
                                pluginField.setAccessible(true);
                                Plugin plugin2 = (Plugin)pluginField.get(entry.getValue());
                                if (!plugin2.getName().equalsIgnoreCase(plugin.getName())) continue;
                                ((Command)entry.getValue()).unregister((CommandMap)commandMap);
                                commands.remove(entry.getKey());
                            }
                            catch (IllegalAccessException e) {
                                e.printStackTrace();
                            }
                        }
                        catch (IllegalStateException e) {
                            if (!e.getMessage().equalsIgnoreCase("zip file closed")) continue;
                            ((Command)entry.getValue()).unregister((CommandMap)commandMap);
                            commands.remove(entry.getKey());
                        }
                    }
                }
                catch (Exception ignored) {
                    HashMap<String, Command> hashMap = new HashMap<String, Command>(commands);
                    for (Map.Entry<Object, Object> entry : new HashMap(commands).entrySet()) {
                        if (entry.getValue() instanceof PluginCommand) {
                            PluginCommand c = (PluginCommand)entry.getValue();
                            if (c.getPlugin() != plugin) continue;
                            c.unregister((CommandMap)commandMap);
                            hashMap.remove(entry.getKey());
                            continue;
                        }
                        try {
                            Field pluginField = Arrays.stream(((Command)entry.getValue()).getClass().getDeclaredFields()).filter(field -> Plugin.class.isAssignableFrom(field.getType())).findFirst().orElse(null);
                            if (pluginField == null) continue;
                            try {
                                pluginField.setAccessible(true);
                                Plugin owningPlugin = (Plugin)pluginField.get(entry.getValue());
                                if (!owningPlugin.getName().equalsIgnoreCase(plugin.getName())) continue;
                                ((Command)entry.getValue()).unregister((CommandMap)commandMap);
                                hashMap.remove(entry.getKey());
                            }
                            catch (IllegalAccessException e) {
                                e.printStackTrace();
                            }
                        }
                        catch (Exception e) {
                            if (!e.getMessage().equalsIgnoreCase("zip file closed")) continue;
                            ((Command)entry.getValue()).unregister((CommandMap)commandMap);
                            hashMap.remove(entry.getKey());
                        }
                    }
                    Reload.setKnownCommands(hashMap);
                }
            }
            try {
                Class.forName("io.papermc.paper.plugin.manager.PaperPluginManagerImpl");
                lookupNames.remove(plugin.getName().toLowerCase());
                pluginList.remove(plugin);
            }
            catch (Exception ignored) {
                // empty catch block
            }
            if (plugins != null && plugins.contains(plugin)) {
                plugins.remove(plugin);
            }
            if (names != null && names.containsKey(name)) {
                names.remove(name);
            }
            Map<String, Command> knownCommands = Reload.getKnownCommands();
            List<Map.Entry<String, Command>> list = Reload.getCommandsFromPlugin(plugin);
            for (Map.Entry<Object, Object> entry : list) {
                alias = (String)entry.getKey();
                Reload.unwrap(alias);
            }
            for (Map.Entry<Object, Object> entry : knownCommands.entrySet().stream().filter(stringCommandEntry -> Plugin.class.isAssignableFrom(((Command)stringCommandEntry.getValue()).getClass())).filter(stringCommandEntry -> {
                Field pluginField = Arrays.stream(((Command)stringCommandEntry.getValue()).getClass().getDeclaredFields()).filter(field -> Plugin.class.isAssignableFrom(field.getType())).findFirst().orElse(null);
                if (pluginField != null) {
                    try {
                        Plugin owningPlugin = (Plugin)pluginField.get(stringCommandEntry.getValue());
                        return owningPlugin.getName().equalsIgnoreCase(plugin.getName());
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
                return false;
            }).collect(Collectors.toList())) {
                alias = (String)entry.getKey();
                Reload.unwrap(alias);
            }
            Reload.sync();
            try {
                Class.forName("io.papermc.paper.plugin.manager.PaperPluginManagerImpl");
                ClassLoader cl = plugin.getClass().getClassLoader();
                if (!(cl instanceof URLClassLoader)) break block40;
                try {
                    Field field5 = cl.getClass().getDeclaredField("plugin");
                    field5.setAccessible(true);
                    field5.set(cl, null);
                    Field pluginInitField = cl.getClass().getDeclaredField("pluginInit");
                    pluginInitField.setAccessible(true);
                    pluginInitField.set(cl, null);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                try {
                    ((URLClassLoader)cl).close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        System.gc();
    }

    public static void setKnownCommands(Map<String, Command> knownCommands) {
        Field knownCommandsField;
        SimpleCommandMap commandMap;
        Field commandMapField;
        PluginManager pluginManager = Bukkit.getPluginManager();
        try {
            commandMapField = Class.forName(Bukkit.getServer().getClass().getPackage().getName() + ".CraftServer").getDeclaredField("commandMap");
            commandMapField.setAccessible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        try {
            commandMap = (SimpleCommandMap)commandMapField.get(Bukkit.getServer());
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        try {
            knownCommandsField = SimpleCommandMap.class.getDeclaredField("knownCommands");
            knownCommandsField.setAccessible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        try {
            knownCommandsField.set(commandMap, knownCommands);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Map<String, Command> getKnownCommands() {
        Map knownCommands;
        Field knownCommandsField;
        SimpleCommandMap commandMap;
        Field commandMapField;
        PluginManager pluginManager = Bukkit.getPluginManager();
        try {
            commandMapField = Class.forName(Bukkit.getServer().getClass().getPackage().getName() + ".CraftServer").getDeclaredField("commandMap");
            commandMapField.setAccessible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        try {
            commandMap = (SimpleCommandMap)commandMapField.get(Bukkit.getServer());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        try {
            knownCommandsField = SimpleCommandMap.class.getDeclaredField("knownCommands");
            knownCommandsField.setAccessible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        try {
            knownCommands = (Map)knownCommandsField.get(commandMap);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
        return knownCommands;
    }

    public static void wrap(Command command, String alias) {
        Method registerMethod;
        Object aInstance;
        Method aMethod;
        Object commandWrapper;
        Constructor<?> bukkitcommandWrapperConstructor;
        Object commandDispatcher;
        Field vanillaCommandDispatcherField;
        Object minecraftServer;
        Method getServerMethod;
        Class<?> minecraftServerClass;
        try {
            Class.forName("com.mojang.brigadier.CommandDispatcher");
        }
        catch (Exception ignored) {
            return;
        }
        try {
            minecraftServerClass = Class.forName("net.minecraft.server" + (nmsVers ? nms : ".") + "MinecraftServer");
            getServerMethod = minecraftServerClass.getMethod("getServer", new Class[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        try {
            minecraftServer = getServerMethod.invoke((Object)("net.minecraft.server" + (nmsVers ? nms : ".") + "MinecraftServer"), new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        try {
            vanillaCommandDispatcherField = minecraftServerClass.getDeclaredField("vanillaCommandDispatcher");
            vanillaCommandDispatcherField.setAccessible(true);
        }
        catch (Exception ignored) {
            return;
        }
        try {
            commandDispatcher = vanillaCommandDispatcherField.get(minecraftServer);
        }
        catch (Exception ignored) {
            return;
        }
        if (commandDispatcher == null) {
            return;
        }
        try {
            bukkitcommandWrapperConstructor = Class.forName(packageName + ".command.BukkitCommandWrapper").getDeclaredConstructor(Class.forName(packageName + ".CraftServer"), Command.class);
            bukkitcommandWrapperConstructor.setAccessible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        try {
            commandWrapper = bukkitcommandWrapperConstructor.newInstance(Bukkit.getServer(), command);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        try {
            aMethod = commandDispatcher.getClass().getDeclaredMethod("a", new Class[0]);
            aMethod.setAccessible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        try {
            aInstance = aMethod.invoke(commandDispatcher, new Object[0]);
        }
        catch (Exception ignored) {
            return;
        }
        if (aInstance == null) {
            return;
        }
        try {
            registerMethod = Class.forName(packageName + ".command.BukkitCommandWrapper").getMethod("register", CommandDispatcher.class, String.class);
            registerMethod.setAccessible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        try {
            registerMethod.invoke(commandWrapper, aInstance, alias);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void unwrap(String command) {
        Method removeCommandMethod;
        CommandDispatcher b;
        Field bField;
        Object commandDispatcher;
        Field vanillaCommandDispatcherField;
        Object server;
        Method getServerMethod;
        Class<?> minecraftServerClass;
        try {
            Class.forName("com.mojang.brigadier.CommandDispatcher");
        }
        catch (Exception ignored) {
            return;
        }
        try {
            minecraftServerClass = Class.forName("net.minecraft.server" + (nmsVers ? nms : ".") + "MinecraftServer");
            getServerMethod = minecraftServerClass.getMethod("getServer", new Class[0]);
        }
        catch (Exception ignored) {
            return;
        }
        try {
            server = getServerMethod.invoke(minecraftServerClass, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        try {
            vanillaCommandDispatcherField = minecraftServerClass.getDeclaredField("vanillaCommandDispatcher");
            vanillaCommandDispatcherField.setAccessible(true);
        }
        catch (NoSuchFieldException ignored) {
            return;
        }
        try {
            commandDispatcher = vanillaCommandDispatcherField.get(server);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return;
        }
        try {
            bField = Class.forName("net.minecraft.server" + (nmsVers ? nms : ".") + "CommandDispatcher").getDeclaredField("b");
            bField.setAccessible(true);
        }
        catch (Exception e) {
            try {
                Class<?> clazz = Class.forName("net.minecraft.commands.CommandDispatcher");
                Field gField = clazz.getDeclaredField("g");
                bField = gField.getType() == CommandDispatcher.class ? gField : clazz.getDeclaredField("h");
                bField.setAccessible(true);
            }
            catch (Exception ex) {
                ex.addSuppressed(e);
                e.printStackTrace();
                return;
            }
        }
        try {
            b = (CommandDispatcher)bField.get(commandDispatcher);
        }
        catch (Exception ignored) {
            return;
        }
        if (b == null) {
            return;
        }
        try {
            try {
                removeCommandMethod = RootCommandNode.class.getDeclaredMethod("removeCommand", String.class);
            }
            catch (Exception ex) {
                removeCommandMethod = CommandNode.class.getDeclaredMethod("removeCommand", String.class);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        try {
            removeCommandMethod.invoke((Object)b.getRoot(), command);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void sync() {
        Method syncCommandsMethod;
        try {
            syncCommandsMethod = Class.forName(packageName + ".CraftServer").getDeclaredMethod("syncCommands", new Class[0]);
            syncCommandsMethod.setAccessible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        try {
            syncCommandsMethod.invoke((Object)Bukkit.getServer(), new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (Bukkit.getOnlinePlayers().isEmpty()) {
            return;
        }
        Bukkit.getOnlinePlayers().forEach(Player::updateCommands);
    }
}

