/*
 * Decompiled with CFR 0.152.
 */
package com.xSavior_of_God.HappyNewYear.utils;

import dev.herox.external.HappyNewYear.org.fusesource.jansi.AnsiConsole;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;

public class ColoredLogger {
    private static final Logger LOGGER = Bukkit.getLogger();
    private final String prefix;
    private final char colorFormatter;
    private static final String ANSI_RESET = "\u001b[0m";
    private static final Map<Character, String> ANSI_COLOR_MAP = new HashMap<Character, String>();

    public ColoredLogger(String prefix) {
        this(prefix, '&');
    }

    public ColoredLogger(String prefix, char colorFormatter) {
        this.prefix = prefix;
        this.colorFormatter = colorFormatter;
    }

    public void log(Level level, String message) {
        LOGGER.log(level, () -> this.prefix + this.convertStringMessage(message));
    }

    public void log(Level level, String message, boolean usePrefix) {
        LOGGER.log(level, () -> (usePrefix ? this.prefix : "") + this.convertStringMessage(message));
    }

    public void log(Level level, String message, Throwable e) {
        LOGGER.log(level, this.prefix + this.convertStringMessage(message), e);
    }

    public void log(Level level, Supplier<String> msgSupplier) {
        LOGGER.log(level, () -> this.prefix + this.convertStringMessage((String)msgSupplier.get()));
    }

    private String convertStringMessage(String message) {
        if (message == null) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        char[] chars = message.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char code;
            String ansi;
            if (chars[i] == this.colorFormatter && i + 1 < chars.length && (ansi = ANSI_COLOR_MAP.get(Character.valueOf(code = Character.toLowerCase(chars[i + 1])))) != null) {
                result.append(ansi);
                ++i;
                continue;
            }
            result.append(chars[i]);
        }
        result.append(ANSI_RESET);
        return result.toString();
    }

    public static void cleanup() {
        AnsiConsole.systemUninstall();
    }

    static {
        AnsiConsole.systemInstall();
        ANSI_COLOR_MAP.put(Character.valueOf('0'), "\u001b[30m");
        ANSI_COLOR_MAP.put(Character.valueOf('1'), "\u001b[34m");
        ANSI_COLOR_MAP.put(Character.valueOf('2'), "\u001b[32m");
        ANSI_COLOR_MAP.put(Character.valueOf('3'), "\u001b[36m");
        ANSI_COLOR_MAP.put(Character.valueOf('4'), "\u001b[31m");
        ANSI_COLOR_MAP.put(Character.valueOf('5'), "\u001b[35m");
        ANSI_COLOR_MAP.put(Character.valueOf('6'), "\u001b[33m");
        ANSI_COLOR_MAP.put(Character.valueOf('7'), "\u001b[37m");
        ANSI_COLOR_MAP.put(Character.valueOf('8'), "\u001b[90m");
        ANSI_COLOR_MAP.put(Character.valueOf('9'), "\u001b[94m");
        ANSI_COLOR_MAP.put(Character.valueOf('a'), "\u001b[92m");
        ANSI_COLOR_MAP.put(Character.valueOf('b'), "\u001b[96m");
        ANSI_COLOR_MAP.put(Character.valueOf('c'), "\u001b[91m");
        ANSI_COLOR_MAP.put(Character.valueOf('d'), "\u001b[95m");
        ANSI_COLOR_MAP.put(Character.valueOf('e'), "\u001b[93m");
        ANSI_COLOR_MAP.put(Character.valueOf('f'), "\u001b[97m");
    }
}

