/*
 * Decompiled with CFR 0.152.
 */
package com.xSavior_of_God.HappyNewYear.tasks;

import com.xSavior_of_God.HappyNewYear.HappyNewYear;
import com.xSavior_of_God.HappyNewYear.api.events.OnFireworkEvent;
import com.xSavior_of_God.HappyNewYear.utils.Utils;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class Task {
    private final BukkitTask fireworkTask;
    private int startHour = 0;
    private int durationTicks = 0;

    public Task(String spawnAnimationType, int hourlyDuration, String hourlyTimezone) {
        if (spawnAnimationType == null || spawnAnimationType.trim().isEmpty()) {
            throw new IllegalArgumentException("spawnAnimationType cannot be null or empty");
        }
        if (hourlyDuration <= 0) {
            throw new IllegalArgumentException("hourlyDuration must be positive");
        }
        try {
            ZoneId.of(hourlyTimezone);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid timezone: " + hourlyTimezone);
        }
        this.fireworkTask = spawnAnimationType.contains("HOURLY") ? Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)HappyNewYear.instance, () -> {
            int currentHour = LocalTime.now(ZoneId.of(hourlyTimezone)).getHour();
            if (this.durationTicks == 0 && this.startHour != currentHour) {
                this.startHour = currentHour;
                this.durationTicks = hourlyDuration;
            }
            if (this.durationTicks != 0) {
                this.durationTicks -= HappyNewYear.timer;
                this.fireworkTask(spawnAnimationType);
            }
        }, 100L, (long)HappyNewYear.timer) : Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)HappyNewYear.instance, () -> this.fireworkTask(spawnAnimationType), 100L, (long)HappyNewYear.timer);
    }

    private void fireworkTask(String spawnAnimationType) {
        HashMap<Chunk, Integer> check = new HashMap<Chunk, Integer>();
        for (Player player : Bukkit.getOnlinePlayers()) {
            Chunk chunk;
            if (HappyNewYear.forceStop) {
                return;
            }
            if (HappyNewYear.wm.getBlacklist() && HappyNewYear.wm.getWorldsName().contains(player.getWorld().getName()) || !HappyNewYear.wm.getBlacklist() && !HappyNewYear.wm.getWorldsName().contains(player.getWorld().getName())) {
                return;
            }
            if (HappyNewYear.wm.getOnNightEnabled()) {
                boolean between = false;
                if (HappyNewYear.wm.getMonth() == -1 || LocalDate.now(ZoneId.of(HappyNewYear.wm.getTimezone())).getMonthValue() == HappyNewYear.wm.getMonth()) {
                    between = HappyNewYear.wm.getInRealLifeEnabled() ? Utils.stringTimeIsBetween(HappyNewYear.wm.getOnNightStarts(), HappyNewYear.wm.getOnNightEnds(), LocalTime.now(ZoneId.of(HappyNewYear.wm.getTimezone())).format(DateTimeFormatter.ofPattern("HH:mm"))) : Utils.stringTimeIsBetween(HappyNewYear.wm.getOnNightStarts(), HappyNewYear.wm.getOnNightEnds(), Utils.format(player.getWorld().getTime()));
                }
                if (!between) {
                    return;
                }
            }
            if (check.containsKey(chunk = player.getLocation().getChunk())) {
                if ((Integer)check.get(chunk) > HappyNewYear.limit) continue;
                check.replace(chunk, (Integer)check.get(chunk) + 1);
            } else {
                check.put(chunk, 1);
            }
            if (spawnAnimationType.contains("REALISTIC")) {
                Bukkit.getScheduler().runTask((Plugin)HappyNewYear.instance, () -> {
                    OnFireworkEvent event = new OnFireworkEvent(player);
                    Bukkit.getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        return;
                    }
                    Random rand = new Random();
                    for (int c = 0; c < HappyNewYear.amountPerPlayer; ++c) {
                        Bukkit.getScheduler().runTaskLater((Plugin)HappyNewYear.instance, () -> this.spawnFireworks(this.randomLocation(player.getLocation())), (long)(rand.nextInt(HappyNewYear.timer) + 1));
                    }
                });
                continue;
            }
            Bukkit.getScheduler().runTask((Plugin)HappyNewYear.instance, () -> {
                OnFireworkEvent event = new OnFireworkEvent(player);
                Bukkit.getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return;
                }
                for (int c = 0; c < HappyNewYear.amountPerPlayer; ++c) {
                    this.spawnFireworks(this.randomLocation(player.getLocation()));
                }
            });
        }
    }

    private void spawnFireworks(Location LOC) {
        String fireworkHook;
        switch (fireworkHook = HappyNewYear.fireworkHooks.get(ThreadLocalRandom.current().nextInt(0, HappyNewYear.fireworkHooks.size()))) {
            case "IMAGEFIREWORKSPRO": {
                if (HappyNewYear.imageFireworksRebornHook == null) break;
                try {
                    HappyNewYear.imageFireworksRebornHook.spawnFirework(LOC);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            default: {
                this.spawnVanillaFireworks(LOC, HappyNewYear.fireworkEffectTypes.get(ThreadLocalRandom.current().nextInt(0, HappyNewYear.fireworkEffectTypes.size())));
            }
        }
    }

    private void spawnVanillaFireworks(Location LOC, String TYPE) {
        Firework firework;
        if (LOC.getWorld() == null) {
            Utils.log(Level.WARNING, "Something went wrong while spawning fireworks. World is null!");
            return;
        }
        try {
            firework = (Firework)LOC.getWorld().spawnEntity(LOC, EntityType.valueOf((String)"FIREWORK_ROCKET"));
        }
        catch (Exception ignored) {
            firework = (Firework)LOC.getWorld().spawnEntity(LOC, EntityType.valueOf((String)"FIREWORK"));
        }
        FireworkMeta meta = firework.getFireworkMeta();
        FireworkEffect.Builder builder = FireworkEffect.builder();
        builder.with(FireworkEffect.Type.valueOf((String)(TYPE.equalsIgnoreCase("RANDOM") ? FireworkEffect.Type.values()[ThreadLocalRandom.current().nextInt(0, FireworkEffect.Type.values().length)].name() : TYPE)));
        this.setColor(builder);
        meta.addEffect(builder.build());
        firework.setFireworkMeta(meta);
        Bukkit.getScheduler().runTaskLater((Plugin)HappyNewYear.instance, () -> ((Firework)firework).detonate(), 1L);
    }

    private void setColor(FireworkEffect.Builder BUILDER) {
        int random = ThreadLocalRandom.current().nextInt(1, 11);
        for (int i = 0; i < random; ++i) {
            Color color = Color.fromBGR((int)ThreadLocalRandom.current().nextInt(1, 256), (int)ThreadLocalRandom.current().nextInt(1, 256), (int)ThreadLocalRandom.current().nextInt(1, 256));
            BUILDER.withColor(color);
        }
    }

    private Location randomLocation(Location LOC) {
        int Horizontal = ThreadLocalRandom.current().nextInt(HappyNewYear.randomSpawnPosition_Horizontal * -1, HappyNewYear.randomSpawnPosition_Horizontal + 1);
        int Horizontal2 = ThreadLocalRandom.current().nextInt(HappyNewYear.randomSpawnPosition_Horizontal * -1, HappyNewYear.randomSpawnPosition_Horizontal + 1);
        int Vertical = ThreadLocalRandom.current().nextInt(HappyNewYear.randomSpawnPosition_Vertical * -1, HappyNewYear.randomSpawnPosition_Vertical + 1);
        LOC.setYaw((float)ThreadLocalRandom.current().nextInt(0, 360));
        LOC.setPitch((float)ThreadLocalRandom.current().nextInt(0, 360));
        return LOC.add((double)Horizontal, (double)(Vertical + HappyNewYear.explosionHeight), (double)Horizontal2);
    }

    public void StopTask() {
        this.fireworkTask.cancel();
    }
}

