/*
 * Decompiled with CFR 0.152.
 */
package com.xSavior_of_God.HappyNewYear.tasks;

import com.xSavior_of_God.HappyNewYear.HappyNewYear;
import com.xSavior_of_God.HappyNewYear.utils.Utils;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.GameRule;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class AlwaysNightTask {
    private BukkitTask realTimeTask;
    private BukkitTask alwaysNightTask;
    List<World> worlds = Bukkit.getServer().getWorlds();

    public AlwaysNightTask() {
        if (HappyNewYear.wm.getBlacklist()) {
            this.worlds.removeIf(w -> HappyNewYear.wm.getWorldsName().contains(w.getName()));
        } else {
            this.worlds.removeIf(w -> !HappyNewYear.wm.getWorldsName().contains(w.getName()));
        }
        this.worlds.removeIf(w -> !w.getEnvironment().equals((Object)World.Environment.NORMAL));
        if (HappyNewYear.wm.getInRealLifeEnabled()) {
            this.realTimeTask = Bukkit.getScheduler().runTaskTimer((Plugin)HappyNewYear.instance, () -> {
                for (World w : this.worlds) {
                    long time = Utils.parse24(LocalTime.now(ZoneId.of(HappyNewYear.wm.getTimezone())).format(DateTimeFormatter.ofPattern("HH:mm"))) + 1L;
                    if (w.getTime() == time) continue;
                    w.setTime(time);
                }
            }, 20L, 1L);
        } else if (HappyNewYear.wm.getAlwaysNightEnabled()) {
            this.alwaysNightTask = Bukkit.getScheduler().runTaskTimer((Plugin)HappyNewYear.instance, () -> {
                for (World w : this.worlds) {
                    if (w.getTime() == 18000L) continue;
                    w.setTime(18000L);
                }
            }, 20L, 1L);
        }
    }

    public void StopTask() {
        if (this.realTimeTask != null) {
            this.realTimeTask.cancel();
        }
        if (this.alwaysNightTask != null) {
            this.alwaysNightTask.cancel();
            for (World w : this.worlds) {
                w.setGameRule(GameRule.DO_DAYLIGHT_CYCLE, (Object)true);
            }
        }
    }
}

