/*
 * Decompiled with CFR 0.152.
 */
package com.jokerhub.paper.plugin.orzmc.infra.templates;

import com.jokerhub.paper.plugin.orzmc.infra.config.TypedConfigs;
import java.util.Collection;
import java.util.Map;

public final class TemplateResolvers {
    private TemplateResolvers() {
    }

    public static String worldAlias(String worldName, String environment, TypedConfigs.TemplateOptions opt) {
        String env;
        String alias;
        Map localized = opt.worldAliasLocalized().getOrDefault(opt.locale() == null ? "" : opt.locale(), null);
        String string = alias = localized != null ? (String)localized.getOrDefault(worldName, null) : null;
        if (alias == null) {
            alias = opt.worldAlias().getOrDefault(worldName, null);
        }
        if (alias != null) {
            return alias;
        }
        String string2 = env = environment == null ? "" : environment.toUpperCase();
        if ("NETHER".equals(env)) {
            return opt.worldAlias().getOrDefault("world_nether", "\u4e0b\u754c");
        }
        if ("THE_END".equals(env)) {
            return opt.worldAlias().getOrDefault("world_the_end", "\u672b\u5730");
        }
        return opt.worldAlias().getOrDefault("world", "\u4e3b\u4e16\u754c");
    }

    public static String roleAlias(boolean isAdmin, TypedConfigs.TemplateOptions opt) {
        String v;
        Map localized = opt.roleAliasLocalized().getOrDefault(opt.locale() == null ? "" : opt.locale(), null);
        if (localized != null && (v = (String)localized.getOrDefault(isAdmin ? "admin" : "member", null)) != null) {
            return v;
        }
        return opt.roleAlias().getOrDefault(isAdmin ? "admin" : "member", isAdmin ? "\u7ba1\u7406\u5458" : "\u73a9\u5bb6");
    }

    public static String roleGroupAliasFromPermissions(Collection<String> permKeys, TypedConfigs.TemplateOptions opt) {
        for (Map.Entry<String, String> e : opt.roleGroupAliases().entrySet()) {
            String key = e.getKey();
            if ("default".equalsIgnoreCase(key) || !permKeys.contains(key)) continue;
            return e.getValue();
        }
        return opt.roleGroupAliases().getOrDefault("default", TemplateResolvers.roleAlias(false, opt));
    }

    public static String stageAlias(String stageName, TypedConfigs.TemplateOptions opt) {
        String v;
        if (stageName == null) {
            return opt.stageCnMap().getOrDefault("Running", "\u8fdb\u884c\u4e2d");
        }
        Map localized = opt.stageAliasLocalized().getOrDefault(opt.locale() == null ? "" : opt.locale(), null);
        if (localized != null && (v = (String)localized.getOrDefault(stageName, null)) != null) {
            return v;
        }
        String cn = opt.stageCnMap().getOrDefault(stageName, null);
        if (cn != null) {
            return cn;
        }
        if ("Region".equalsIgnoreCase(stageName)) {
            return "\u533a\u57df";
        }
        if ("Chunk".equalsIgnoreCase(stageName)) {
            return "\u533a\u5757";
        }
        if ("File".equalsIgnoreCase(stageName)) {
            return "\u6587\u4ef6";
        }
        if ("Done".equalsIgnoreCase(stageName)) {
            return "\u5b8c\u6210";
        }
        return "\u8fdb\u884c\u4e2d";
    }
}

