/*
 * Decompiled with CFR 0.152.
 */
package com.jokerhub.paper.plugin.orzmc.infra.styles;

import com.jokerhub.paper.plugin.orzmc.infra.config.ConfigService;
import com.jokerhub.paper.plugin.orzmc.infra.config.TypedConfigs;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Location;

public final class OrzTextStyles {
    private final ConfigService configService;

    public OrzTextStyles(ConfigService configService) {
        this.configService = configService;
    }

    private TextColor colorOrDefault(String key, String defaultHex) {
        try {
            TypedConfigs.Styles styles = TypedConfigs.Styles.from(this.configService.getConfig("styles"));
            String hex = styles.colors().getOrDefault(key, defaultHex);
            if (hex == null || hex.isEmpty()) {
                return TextColor.fromCSSHexString((String)defaultHex);
            }
            return TextColor.fromCSSHexString((String)hex);
        }
        catch (Exception ignored) {
            return TextColor.fromCSSHexString((String)defaultHex);
        }
    }

    public TextColor colorAlertTnt() {
        return this.colorOrDefault("tnt_alert", "#FF5555");
    }

    public TextColor colorAlertExplosion() {
        return this.colorOrDefault("explosion_alert", "#FFAA00");
    }

    public TextColor colorCoord() {
        return this.colorOrDefault("coord", "#55FF55");
    }

    public TextColor colorSuccess() {
        return this.colorOrDefault("success", "#00FF00");
    }

    public TextColor colorInfo() {
        return this.colorOrDefault("info", "#55AAFF");
    }

    public TextColor colorWarn() {
        return this.colorOrDefault("warn", "#FFAA00");
    }

    public TextColor colorError() {
        return this.colorOrDefault("error", "#FF5555");
    }

    public TextColor colorPlayer() {
        return this.colorOrDefault("player", "#FF5555");
    }

    public TextColor colorUnknown() {
        return this.colorOrDefault("unknown", "#AAAAAA");
    }

    public TextComponent prefix(String text, TextColor color) {
        return (TextComponent)Component.text((String)text).color(color);
    }

    public TextComponent tntPrefix() {
        return this.prefix("[TNT\u8b66\u62a5] ", this.colorAlertTnt());
    }

    public TextComponent explosionPrefix() {
        return this.prefix("[\u7206\u70b8\u8b66\u62a5] ", this.colorAlertExplosion());
    }

    public TextComponent tpbowPrefix() {
        return (TextComponent)Component.text((String)"[\u4f20\u9001\u5f13]").color(this.colorWarn());
    }

    public TextComponent coordComponent(String locString) {
        return (TextComponent)((TextComponent)((TextComponent)Component.text((String)locString).color(this.colorCoord())).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"\u70b9\u51fb\u590d\u5236\u5750\u6807")))).clickEvent(ClickEvent.copyToClipboard((String)locString.trim()));
    }

    public TextComponent success(String content) {
        return (TextComponent)Component.text((String)content).color(this.colorSuccess());
    }

    public TextComponent info(String content) {
        return (TextComponent)Component.text((String)content).color(this.colorInfo());
    }

    public TextComponent warn(String content) {
        return (TextComponent)Component.text((String)content).color(this.colorWarn());
    }

    public TextComponent error(String content) {
        return (TextComponent)Component.text((String)content).color(this.colorError());
    }

    public String coordString(Location location) {
        return String.format(" [%s] %d %d %d ", location.getWorld().getName(), location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    public TextComponent playerName(String name) {
        return (TextComponent)Component.text((String)name).color(this.colorPlayer());
    }

    public TextComponent unknownLabel() {
        return (TextComponent)Component.text((String)"\u672a\u77e5\u73a9\u5bb6").color(this.colorUnknown());
    }
}

