/*
 * Decompiled with CFR 0.152.
 */
package com.jokerhub.paper.plugin.orzmc.infra.portal;

import com.jokerhub.paper.plugin.orzmc.infra.config.ConfigService;
import com.jokerhub.paper.plugin.orzmc.infra.config.PortalsWriter;
import com.jokerhub.paper.plugin.orzmc.infra.config.TypedConfigs;
import com.jokerhub.paper.plugin.orzmc.infra.portal.IPortalService;
import com.jokerhub.paper.plugin.orzmc.infra.portal.PortalInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Axis;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Orientable;
import org.bukkit.block.data.type.WallSign;
import org.bukkit.block.sign.Side;
import org.bukkit.block.sign.SignSide;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class PortalService
implements IPortalService {
    private final ConfigService configService;
    private final Map<String, String> interiorTargets = new HashMap<String, String>();
    private final Map<String, PortalDef> portalCenters = new HashMap<String, PortalDef>();

    public PortalService(ConfigService configService) {
        this.configService = configService;
    }

    private String key(World w, int x, int y, int z) {
        return w.getName() + ":" + x + ":" + y + ":" + z;
    }

    @Override
    public PortalInfo createPortal(Player player, String host, int port) {
        int z;
        int x;
        int i;
        int dx;
        boolean axisX;
        Location loc = player.getLocation();
        Vector dir = loc.getDirection().normalize();
        boolean bl = axisX = Math.abs(dir.getX()) >= Math.abs(dir.getZ());
        int n = axisX ? (dir.getX() >= 0.0 ? 1 : -1) : (dx = 0);
        int dz = axisX ? 0 : (dir.getZ() >= 0.0 ? 1 : -1);
        int baseX = loc.getBlockX() + dx * 2;
        int baseY = Math.max(2, loc.getBlockY());
        int baseZ = loc.getBlockZ() + dz * 2;
        World world = loc.getWorld();
        int fw = 4;
        int fh = 5;
        int maxY = world.getMaxHeight() - fh;
        if (baseY > maxY) {
            baseY = Math.max(2, maxY);
        }
        for (int attempt = 0; attempt < 16; ++attempt) {
            boolean clear = true;
            for (i = 1; i < fw - 1 && clear; ++i) {
                for (int j = 1; j < fh - 1 && clear; ++j) {
                    int z2;
                    int y;
                    int x2 = baseX + (axisX ? 0 : i);
                    Block b = world.getBlockAt(x2, y = baseY + j, z2 = baseZ + (axisX ? i : 0));
                    if (b.getType().isAir()) continue;
                    clear = false;
                }
            }
            if (clear || baseY >= maxY) break;
            ++baseY;
        }
        for (int i2 = 0; i2 < fw; ++i2) {
            for (int j = 0; j < fh; ++j) {
                boolean frame = i2 == 0 || i2 == fw - 1 || j == 0 || j == fh - 1;
                x = baseX + (axisX ? 0 : i2);
                z = baseZ + (axisX ? i2 : 0);
                int y = baseY + j;
                Block b = world.getBlockAt(x, y, z);
                if (frame) {
                    b.setType(Material.OBSIDIAN, false);
                    continue;
                }
                b.setType(Material.NETHER_PORTAL, false);
                BlockData bd = b.getBlockData();
                if (bd instanceof Orientable) {
                    Orientable o = (Orientable)bd;
                    Axis portalAxis = axisX ? Axis.Z : Axis.X;
                    o.setAxis(portalAxis);
                    b.setBlockData((BlockData)o, false);
                }
                this.interiorTargets.put(this.key(world, x, y, z), host + ":" + port);
            }
        }
        int padY = baseY - 1;
        if (axisX) {
            y = padY;
            for (i = -1; i <= fw; ++i) {
                x = baseX;
                z = baseZ + i;
                Block pad = world.getBlockAt(x, y, z);
                pad.setType(Material.GOLD_BLOCK, false);
            }
        } else {
            y = padY;
            for (i = -1; i <= fw; ++i) {
                x = baseX + i;
                z = baseZ;
                Block pad = world.getBlockAt(x, y, z);
                pad.setType(Material.GOLD_BLOCK, false);
            }
        }
        int cx = baseX + (axisX ? 0 : 1);
        int cy = baseY + 2;
        int cz = baseZ + (axisX ? 1 : 0);
        Location center = new Location(world, (double)cx, (double)cy, (double)cz);
        Axis portalAxis = axisX ? Axis.Z : Axis.X;
        PortalDef def = new PortalDef(world.getName(), cx, cy, cz, portalAxis, host + ":" + port);
        this.portalCenters.put(def.centerKey(), def);
        this.rehydrateInterior(def);
        this.spawnLabel(def);
        this.saveToStorage();
        return new PortalInfo(center, axisX ? Axis.X : Axis.Z);
    }

    @Override
    public String findTarget(Location location) {
        String k = this.key(location.getWorld(), location.getBlockX(), location.getBlockY(), location.getBlockZ());
        String v = this.interiorTargets.getOrDefault(k, null);
        if (v != null) {
            return v;
        }
        int bx = location.getBlockX();
        int by = location.getBlockY();
        int bz = location.getBlockZ();
        World w = location.getWorld();
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dy = -1; dy <= 1; ++dy) {
                for (int dz = -1; dz <= 1; ++dz) {
                    String kk = this.key(w, bx + dx, by + dy, bz + dz);
                    String vv = this.interiorTargets.get(kk);
                    if (vv == null) continue;
                    return vv;
                }
            }
        }
        return null;
    }

    private void placeInfoSign(World world, Location center, Axis axis, int dx, int dz, String host, int port) {
        int sx = center.getBlockX() + dx;
        int sz = center.getBlockZ() + dz;
        int sy = center.getBlockY();
        Block signBlock = world.getBlockAt(sx, sy, sz);
        if (signBlock.getType().isAir()) {
            BlockState st;
            signBlock.setType(Material.OAK_WALL_SIGN, false);
            BlockData bd = signBlock.getBlockData();
            if (bd instanceof WallSign) {
                WallSign ws = (WallSign)bd;
                BlockFace face = dx > 0 ? BlockFace.EAST : (dx < 0 ? BlockFace.WEST : (dz > 0 ? BlockFace.SOUTH : BlockFace.NORTH));
                ws.setFacing(face);
                signBlock.setBlockData((BlockData)ws, false);
            }
            if ((st = signBlock.getState()) instanceof Sign) {
                Sign sign = (Sign)st;
                SignSide front = sign.getSide(Side.FRONT);
                front.setLine(0, "\u4f20\u9001\u95e8");
                front.setLine(1, host + ":" + port);
                sign.update(true, false);
            }
        }
    }

    public void loadFromStorage() {
        FileConfiguration cfg = this.configService.getConfig("portals");
        TypedConfigs.Portals typed = TypedConfigs.Portals.from(cfg);
        for (Map.Entry<String, TypedConfigs.Portals.PortalEntry> e : typed.entries().entrySet()) {
            int cz;
            int cy;
            int cx;
            String k = e.getKey();
            String[] parts = k.split(":");
            if (parts.length != 4) continue;
            String world = parts[0];
            try {
                cx = Integer.parseInt(parts[1]);
                cy = Integer.parseInt(parts[2]);
                cz = Integer.parseInt(parts[3]);
            }
            catch (Exception ignored) {
                continue;
            }
            String axisStr = e.getValue().axis();
            String target = e.getValue().target();
            if (target == null || target.isEmpty()) continue;
            Axis axis = "Z".equalsIgnoreCase(axisStr) ? Axis.Z : Axis.X;
            PortalDef def = new PortalDef(world, cx, cy, cz, axis, target);
            this.portalCenters.put(def.centerKey(), def);
            this.rehydrateInterior(def);
            this.spawnLabel(def);
        }
    }

    @Override
    public void setup() {
        this.loadFromStorage();
    }

    @Override
    public void tearDown() {
    }

    public void saveToStorage() {
        FileConfiguration cfg = this.configService.getConfig("portals");
        if (cfg == null) {
            return;
        }
        HashMap<String, TypedConfigs.Portals.PortalEntry> entries = new HashMap<String, TypedConfigs.Portals.PortalEntry>();
        for (PortalDef def : this.portalCenters.values()) {
            entries.put(def.centerKey(), new TypedConfigs.Portals.PortalEntry(def.target, def.axis == Axis.Z ? "Z" : "X"));
        }
        PortalsWriter.write(cfg, entries);
        this.configService.saveConfig("portals");
    }

    @Override
    public int removeByTarget(String target) {
        ArrayList<PortalDef> toRemove = new ArrayList<PortalDef>();
        for (PortalDef def : this.portalCenters.values()) {
            if (!target.equals(def.target())) continue;
            toRemove.add(def);
        }
        for (PortalDef def : toRemove) {
            this.clearPortalBlocks(def);
            this.portalCenters.remove(def.centerKey());
            this.clearInterior(def);
            this.clearLabels(def);
        }
        this.saveToStorage();
        this.configService.reloadConfig("portals");
        return toRemove.size();
    }

    private void clearInterior(PortalDef def) {
        int z = def.cz;
        int x1 = def.cx;
        int x2 = def.cx + 1;
        int y1 = def.cy - 1;
        int y2 = def.cy;
        int y3 = def.cy + 1;
        this.interiorTargets.remove(def.world + ":" + x1 + ":" + y1 + ":" + z);
        this.interiorTargets.remove(def.world + ":" + x1 + ":" + y2 + ":" + z);
        this.interiorTargets.remove(def.world + ":" + x1 + ":" + y3 + ":" + z);
        this.interiorTargets.remove(def.world + ":" + x2 + ":" + y1 + ":" + z);
        this.interiorTargets.remove(def.world + ":" + x2 + ":" + y2 + ":" + z);
        this.interiorTargets.remove(def.world + ":" + x2 + ":" + y3 + ":" + z);
    }

    private void clearPortalBlocks(PortalDef def) {
        World w = Bukkit.getWorld((String)def.world());
        if (w == null) {
            return;
        }
        int baseY = def.cy - 2;
        int fw = 4;
        int fh = 5;
        if (def.axis == Axis.X) {
            int x;
            int z = def.cz;
            int xBase = def.cx - 1;
            for (i = -1; i <= fw; ++i) {
                for (j = -2; j <= fh; ++j) {
                    x = xBase + i;
                    y = baseY + j;
                    this.removeIfPortalBlock(w.getBlockAt(x, y, z));
                }
            }
            for (i = -1; i <= fw; ++i) {
                for (j = -2; j <= fh; ++j) {
                    x = xBase + i;
                    y = baseY + j;
                    this.removeIfPortalBlock(w.getBlockAt(x, y, z + 1));
                    this.removeIfPortalBlock(w.getBlockAt(x, y, z - 1));
                }
            }
        } else {
            int z;
            int x = def.cx;
            int zBase = def.cz - 1;
            for (i = -1; i <= fw; ++i) {
                for (j = -2; j <= fh; ++j) {
                    z = zBase + i;
                    y = baseY + j;
                    this.removeIfPortalBlock(w.getBlockAt(x, y, z));
                }
            }
            for (i = -1; i <= fw; ++i) {
                for (j = -2; j <= fh; ++j) {
                    z = zBase + i;
                    y = baseY + j;
                    this.removeIfPortalBlock(w.getBlockAt(x + 1, y, z));
                    this.removeIfPortalBlock(w.getBlockAt(x - 1, y, z));
                }
            }
        }
        Location c = new Location(w, (double)def.cx + 0.5, (double)def.cy + 2.0, (double)def.cz + 0.5);
        Collection nearby = w.getNearbyEntities(c, 3.0, 3.0, 3.0);
        for (Entity e : nearby) {
            ArmorStand as;
            Component name;
            String plain;
            if (!(e instanceof ArmorStand) || (plain = (name = (as = (ArmorStand)e).customName()) == null ? "" : PlainTextComponentSerializer.plainText().serialize(name)).isEmpty() || !plain.contains(def.target()) && !plain.contains("\u8de8\u670d\u4f20\u9001")) continue;
            e.remove();
        }
    }

    private void removeIfPortalBlock(Block b) {
        Material t = b.getType();
        if (t == Material.OBSIDIAN || t == Material.NETHER_PORTAL || t == Material.GLOWSTONE || t == Material.END_ROD || t == Material.LIGHT_BLUE_STAINED_GLASS || t == Material.STONE_BRICKS) {
            b.setType(Material.AIR, false);
        }
    }

    private void clearLabels(PortalDef def) {
        World w = Bukkit.getWorld((String)def.world());
        if (w == null) {
            return;
        }
        Location base = new Location(w, (double)def.cx + 0.5, (double)def.cy + 1.9, (double)def.cz + 0.5);
        Collection nearby = w.getNearbyEntities(base, 2.5, 2.5, 2.5);
        for (Entity e : nearby) {
            ArmorStand as;
            Component name;
            String plain;
            if (!(e instanceof ArmorStand) || (plain = (name = (as = (ArmorStand)e).customName()) == null ? "" : PlainTextComponentSerializer.plainText().serialize(name)).isEmpty() || !plain.contains(def.target()) && !plain.contains("\u8de8\u670d\u4f20\u9001")) continue;
            e.remove();
        }
    }

    private void rehydrateInterior(PortalDef def) {
        if (def.axis == Axis.X) {
            int z = def.cz;
            int x1 = def.cx;
            int x2 = def.cx + 1;
            int y1 = def.cy - 1;
            int y2 = def.cy;
            int y3 = def.cy + 1;
            this.interiorTargets.put(def.world + ":" + x1 + ":" + y1 + ":" + z, def.target);
            this.interiorTargets.put(def.world + ":" + x1 + ":" + y2 + ":" + z, def.target);
            this.interiorTargets.put(def.world + ":" + x1 + ":" + y3 + ":" + z, def.target);
            this.interiorTargets.put(def.world + ":" + x2 + ":" + y1 + ":" + z, def.target);
            this.interiorTargets.put(def.world + ":" + x2 + ":" + y2 + ":" + z, def.target);
            this.interiorTargets.put(def.world + ":" + x2 + ":" + y3 + ":" + z, def.target);
        } else {
            int x = def.cx;
            int z1 = def.cz;
            int z2 = def.cz + 1;
            int y1 = def.cy - 1;
            int y2 = def.cy;
            int y3 = def.cy + 1;
            this.interiorTargets.put(def.world + ":" + x + ":" + y1 + ":" + z1, def.target);
            this.interiorTargets.put(def.world + ":" + x + ":" + y2 + ":" + z1, def.target);
            this.interiorTargets.put(def.world + ":" + x + ":" + y3 + ":" + z1, def.target);
            this.interiorTargets.put(def.world + ":" + x + ":" + y1 + ":" + z2, def.target);
            this.interiorTargets.put(def.world + ":" + x + ":" + y2 + ":" + z2, def.target);
            this.interiorTargets.put(def.world + ":" + x + ":" + y3 + ":" + z2, def.target);
        }
    }

    private void spawnLabel(PortalDef def) {
        World w = Bukkit.getWorld((String)def.world());
        if (w == null) {
            return;
        }
        Location base = new Location(w, (double)def.cx() + 0.5, (double)def.cy() + 1.9, (double)def.cz() + 0.5);
        Collection nearby = w.getNearbyEntities(base, 2.0, 2.0, 2.0);
        for (Entity e : nearby) {
            ArmorStand as;
            Component name;
            String plain;
            if (!(e instanceof ArmorStand) || (plain = (name = (as = (ArmorStand)e).customName()) == null ? "" : PlainTextComponentSerializer.plainText().serialize(name)).isEmpty() || !plain.contains(def.target())) continue;
            return;
        }
        ArmorStand title = (ArmorStand)w.spawnEntity(base.clone().add(0.0, 0.3, 0.0), EntityType.ARMOR_STAND);
        title.setInvisible(true);
        title.setMarker(true);
        title.setGravity(false);
        title.setCustomNameVisible(true);
        title.customName(Component.text((String)"\u8de8\u670d\u4f20\u9001").color(TextColor.color((int)16766720)));
        ArmorStand addr = (ArmorStand)w.spawnEntity(base, EntityType.ARMOR_STAND);
        addr.setInvisible(true);
        addr.setMarker(true);
        addr.setGravity(false);
        addr.setCustomNameVisible(true);
        addr.customName(Component.text((String)def.target()).color(TextColor.color((int)65535)));
    }

    public record PortalDef(String world, int cx, int cy, int cz, Axis axis, String target) {
        public String centerKey() {
            return this.world + ":" + this.cx + ":" + this.cy + ":" + this.cz;
        }
    }
}

