/*
 * Decompiled with CFR 0.152.
 */
package com.jokerhub.paper.plugin.orzmc.infra.paging;

import com.jokerhub.paper.plugin.orzmc.infra.scheduler.Schedulers;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public final class Paginator {
    private Paginator() {
    }

    public static void paginate(Consumer<String> callback, String header, List<String> lines, int delayTicks, Integer page) {
        ArrayList<String> chunks = Paginator.buildChunks(lines);
        int total = chunks.size();
        if (total == 0) {
            callback.accept(header + "\n(\u6682\u65e0\u767d\u540d\u5355\u73a9\u5bb6)");
            return;
        }
        if (page != null) {
            int idx = Math.max(1, Math.min(page, total)) - 1;
            String pageHeader = header + "\n\u7b2c" + (idx + 1) + "/" + total + "\u9875";
            String body = chunks.get(idx);
            callback.accept(pageHeader + "\n" + body);
        } else {
            for (int i = 0; i < total; ++i) {
                int pageIndex = i;
                Schedulers.runLater(() -> {
                    String pageHeader = header + "\n\u7b2c" + (pageIndex + 1) + "/" + total + "\u9875";
                    String body = (String)chunks.get(pageIndex);
                    callback.accept(pageHeader + "\n" + body);
                }, (long)i * (delayTicks <= 0 ? 5L : (long)delayTicks));
            }
        }
    }

    public static void paginatePages(PageConsumer callback, String header, List<String> lines, int delayTicks, Integer page) {
        ArrayList<String> chunks = Paginator.buildChunks(lines);
        int total = chunks.size();
        if (total == 0) {
            callback.accept(1, 1, header, "(\u6682\u65e0\u767d\u540d\u5355\u73a9\u5bb6)");
            return;
        }
        if (page != null) {
            int idx = Math.max(1, Math.min(page, total)) - 1;
            String body = chunks.get(idx);
            callback.accept(idx + 1, total, header, body);
        } else {
            for (int i = 0; i < total; ++i) {
                int pageIndex = i;
                Schedulers.runLater(() -> {
                    String body = (String)chunks.get(pageIndex);
                    callback.accept(pageIndex + 1, total, header, body);
                }, (long)i * (delayTicks <= 0 ? 5L : (long)delayTicks));
            }
        }
    }

    private static ArrayList<String> buildChunks(List<String> lines) {
        ArrayList<String> chunks = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        int count = 0;
        for (String s : lines) {
            builder.append(s).append('\n');
            if (++count < 20) continue;
            chunks.add(builder.toString().trim());
            builder = new StringBuilder();
            count = 0;
        }
        if (!builder.isEmpty()) {
            chunks.add(builder.toString().trim());
        }
        return chunks;
    }

    @FunctionalInterface
    public static interface PageConsumer {
        public void accept(int var1, int var2, String var3, String var4);
    }
}

