/*
 * Decompiled with CFR 0.152.
 */
package com.jokerhub.paper.plugin.orzmc.infra.notify;

import com.jokerhub.paper.plugin.orzmc.OrzMC;
import com.jokerhub.paper.plugin.orzmc.infra.bot.BotMessageService;
import com.jokerhub.paper.plugin.orzmc.infra.bot.MessageEnvelope;
import com.jokerhub.paper.plugin.orzmc.infra.config.ConfigService;
import com.jokerhub.paper.plugin.orzmc.infra.config.TypedConfigs;
import com.jokerhub.paper.plugin.orzmc.infra.notify.NotifierSink;
import net.kyori.adventure.text.Component;
import org.bukkit.configuration.file.FileConfiguration;

public final class Notifier {
    private final ConfigService configService;
    private final BotMessageService botMessageService;
    private NotifierSink sink;

    public Notifier(ConfigService configService, BotMessageService botMessageService) {
        this.configService = configService;
        this.botMessageService = botMessageService;
        this.sink = new DefaultSink();
    }

    public void server(Component message) {
        this.sink.server(message);
    }

    public void event(String key, MessageEnvelope envelope) {
        this.sink.event(key, envelope);
    }

    public void registerSink(NotifierSink s) {
        this.sink = s == null ? this.sink : s;
    }

    public void routeEvent(String key, MessageEnvelope envelope) {
        String channelKey;
        if (envelope == null) {
            return;
        }
        FileConfiguration cfg = this.configService.getConfig("notifications");
        TypedConfigs.Notifications ns = TypedConfigs.Notifications.from(cfg);
        TypedConfigs.NotifyPolicy p = ns.policies().getOrDefault(key, new TypedConfigs.NotifyPolicy(false, true, true, ""));
        if (p.publicEnabled()) {
            this.botMessageService.send(envelope.withTargetType(MessageEnvelope.TargetType.PUBLIC));
        }
        if (p.privateEnabled()) {
            this.botMessageService.send(envelope.withTargetType(MessageEnvelope.TargetType.PRIVATE));
        }
        if ((channelKey = p.channelKey()) != null && !channelKey.isEmpty()) {
            this.botMessageService.send(envelope.withTargetType(MessageEnvelope.TargetType.CHANNEL).withChannelKey(channelKey));
        }
    }

    private final class DefaultSink
    implements NotifierSink {
        private DefaultSink() {
        }

        @Override
        public void server(Component message) {
            OrzMC.server().sendMessage(message);
        }

        @Override
        public void event(String key, MessageEnvelope envelope) {
            Notifier.this.routeEvent(key, envelope);
        }
    }
}

