/*
 * Decompiled with CFR 0.152.
 */
package com.jokerhub.paper.plugin.orzmc.infra.net;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.jokerhub.paper.plugin.orzmc.infra.net.AsyncHttp;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public final class GeoIpClient {
    public CompletableFuture<GeoIpResult> lookup(String ipAddress) {
        String url = "https://get.geojs.io/v1/ip/geo/" + ipAddress + ".json";
        return ((CompletableFuture)AsyncHttp.get(url, Map.of(), Duration.ofSeconds(3L), Duration.ofSeconds(3L), 2).thenApply(HttpResponse::body)).thenApply(raw -> {
            JsonObject json = JsonParser.parseString((String)raw).getAsJsonObject();
            String cc = json.has("country_code") ? json.get("country_code").getAsString() : "";
            return new GeoIpResult(cc, (String)raw);
        });
    }

    public record GeoIpResult(String countryCode, String rawJson) {
    }
}

