/*
 * Decompiled with CFR 0.152.
 */
package com.jokerhub.paper.plugin.orzmc.infra.logging;

import com.jokerhub.paper.plugin.orzmc.infra.config.ConfigService;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;

public final class ThrottledLogger {
    private final ConfigService configService;
    private final Logger logger;
    private final ConcurrentHashMap<String, Long> last = new ConcurrentHashMap();

    public ThrottledLogger(ConfigService configService, Logger logger) {
        this.configService = configService;
        this.logger = logger;
    }

    public void error(String key, String message) {
        this.error(key, message, this.defaultPeriodMs());
    }

    public void info(String key, String message) {
        this.info(key, message, this.defaultPeriodMs());
    }

    public void warning(String key, String message) {
        this.warning(key, message, this.defaultPeriodMs());
    }

    private long defaultPeriodMs() {
        try {
            long v = this.configService.getConfig("bot").getLong("log_throttle_ms");
            return v <= 0L ? 5000L : v;
        }
        catch (Exception ignored) {
            return 5000L;
        }
    }

    private void error(String key, String message, long periodMs) {
        long now = System.currentTimeMillis();
        Long prev = this.last.get(key);
        if (prev == null || now - prev >= periodMs) {
            this.last.put(key, now);
            this.logger.severe(message);
        }
    }

    private void info(String key, String message, long periodMs) {
        long now = System.currentTimeMillis();
        Long prev = this.last.get(key);
        if (prev == null || now - prev >= periodMs) {
            this.last.put(key, now);
            this.logger.info(message);
        }
    }

    private void warning(String key, String message, long periodMs) {
        long now = System.currentTimeMillis();
        Long prev = this.last.get(key);
        if (prev == null || now - prev >= periodMs) {
            this.last.put(key, now);
            this.logger.warning(message);
        }
    }
}

