/*
 * Decompiled with CFR 0.152.
 */
package com.jokerhub.paper.plugin.orzmc.infra.guidebook;

import com.jokerhub.paper.plugin.orzmc.OrzMC;
import com.jokerhub.paper.plugin.orzmc.infra.config.ConfigService;
import com.jokerhub.paper.plugin.orzmc.infra.guidebook.models.ContentItem;
import com.jokerhub.paper.plugin.orzmc.infra.guidebook.models.GuideBookConfig;
import com.jokerhub.paper.plugin.orzmc.infra.guidebook.models.LinkContent;
import com.jokerhub.paper.plugin.orzmc.infra.guidebook.models.TextContent;
import com.jokerhub.paper.plugin.orzmc.infra.guidebook.models.TextStyle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class GuideBookConfigParser {
    private final OrzMC plugin;
    private final ConfigService configService;

    public GuideBookConfigParser(OrzMC plugin, ConfigService configService) {
        this.plugin = plugin;
        this.configService = configService;
    }

    public GuideBookConfig parseConfig() {
        String guideBookConfigFileName = "guide_book";
        try {
            this.configService.reloadConfig(guideBookConfigFileName);
            FileConfiguration configFile = this.configService.getConfig("guide_book");
            if (configFile instanceof YamlConfiguration) {
                return this.parseGuideBookConfig((YamlConfiguration)configFile);
            }
            return null;
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "\u89e3\u6790" + guideBookConfigFileName + "\u914d\u7f6e\u6587\u4ef6\u65f6\u53d1\u751f\u9519\u8bef", e);
            return null;
        }
    }

    private GuideBookConfig parseGuideBookConfig(YamlConfiguration config) {
        boolean enable = config.getBoolean("enable", true);
        String title = config.getString("title", "\u65b0\u624b\u6307\u5357");
        String author = config.getString("author", "\u670d\u52a1\u5668");
        List<ContentItem> contentItems = this.parseContentList(config.getMapList("content"));
        return new GuideBookConfig(enable, title, author, contentItems);
    }

    private List<ContentItem> parseContentList(List<Map<?, ?>> contentList) {
        ArrayList<ContentItem> contentItems = new ArrayList<ContentItem>();
        if (contentList == null) {
            this.plugin.getLogger().warning("\u914d\u7f6e\u4e2d\u7684 content \u5217\u8868\u4e3a\u7a7a\u6216\u4e0d\u5b58\u5728");
            return contentItems;
        }
        for (int i = 0; i < contentList.size(); ++i) {
            Map<?, ?> itemMap = contentList.get(i);
            ContentItem contentItem = this.parseContentItem(itemMap, i);
            contentItems.add(contentItem);
        }
        return contentItems;
    }

    private ContentItem parseContentItem(Map<?, ?> itemMap, int index) {
        ContentItem contentItem = new ContentItem();
        try {
            if (itemMap.containsKey("text")) {
                Object textObj = itemMap.get("text");
                if (textObj instanceof Map) {
                    Map textMap = (Map)textObj;
                    contentItem.setText(this.parseTextContent(textMap));
                }
            } else if (itemMap.containsKey("link")) {
                Object linkObj = itemMap.get("link");
                if (linkObj instanceof Map) {
                    Map linkMap = (Map)linkObj;
                    contentItem.setLink(this.parseLinkContent(linkMap));
                }
            } else {
                this.plugin.getLogger().warning("\u7b2c " + (index + 1) + " \u4e2a\u5185\u5bb9\u9879\u7c7b\u578b\u672a\u77e5\uff0c\u5df2\u8df3\u8fc7");
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("\u89e3\u6790\u7b2c " + (index + 1) + " \u4e2a\u5185\u5bb9\u9879\u65f6\u53d1\u751f\u9519\u8bef: " + e.getMessage());
        }
        return contentItem;
    }

    private TextContent parseTextContent(Map<String, Object> textMap) {
        String content = (String)textMap.get("content");
        TextStyle style = this.parseTextStyle(this.getStyleMap(textMap));
        int newlineCount = this.getNewlineCount(textMap);
        boolean pageBreak = this.getPageBreak(textMap);
        return new TextContent(content, style, newlineCount, pageBreak);
    }

    private LinkContent parseLinkContent(Map<String, Object> linkMap) {
        String content = (String)linkMap.get("content");
        String url = (String)linkMap.get("url");
        String hoverText = (String)linkMap.get("hover_text");
        TextStyle style = this.parseTextStyle(this.getStyleMap(linkMap));
        int newlineCount = this.getNewlineCount(linkMap);
        boolean pageBreak = this.getPageBreak(linkMap);
        return new LinkContent(content, url, hoverText, style, newlineCount, pageBreak);
    }

    private TextStyle parseTextStyle(Map<String, Object> styleMap) {
        TextStyle textStyle = new TextStyle();
        if (styleMap == null || styleMap.isEmpty()) {
            return textStyle;
        }
        if (styleMap.containsKey("bold")) {
            textStyle.setBold((Boolean)styleMap.get("bold"));
        }
        if (styleMap.containsKey("underlined")) {
            textStyle.setUnderlined((Boolean)styleMap.get("underlined"));
        }
        if (styleMap.containsKey("color")) {
            textStyle.setColor((String)styleMap.get("color"));
        }
        return textStyle;
    }

    private Map<String, Object> getStyleMap(Map<String, Object> contentMap) {
        Object styleObj = contentMap.get("style");
        if (styleObj instanceof Map) {
            return (Map)styleObj;
        }
        return null;
    }

    private int getNewlineCount(Map<String, Object> contentMap) {
        Object newlineObj = contentMap.get("newline_count");
        if (newlineObj instanceof Integer) {
            return (Integer)newlineObj;
        }
        return 1;
    }

    private boolean getPageBreak(Map<String, Object> contentMap) {
        Object pageBreakObj = contentMap.get("page_break");
        if (pageBreakObj instanceof Boolean) {
            return (Boolean)pageBreakObj;
        }
        return false;
    }
}

