/*
 * Decompiled with CFR 0.152.
 */
package com.jokerhub.paper.plugin.orzmc.infra.config;

import com.jokerhub.paper.plugin.orzmc.infra.config.SafeKeys;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;

public final class TypedConfigs {
    private TypedConfigs() {
    }

    public record TemplateOptions(Map<String, String> stageCnMap, String rateUnit, String etaUnit, Map<String, String> worldAlias, Map<String, Map<String, String>> worldAliasLocalized, double coordScale, int coordPrecision, String coordUnitLabel, Map<String, String> roleAlias, String locale, Map<String, Map<String, String>> roleAliasLocalized, Map<String, String> roleGroupAliases, Map<String, Map<String, String>> stageAliasLocalized) {
        public TemplateOptions(Map<String, String> stageCnMap, String rateUnit, String etaUnit, Map<String, String> worldAlias, Map<String, Map<String, String>> worldAliasLocalized, double coordScale, String coordUnitLabel, Map<String, String> roleAlias, String locale, Map<String, Map<String, String>> roleAliasLocalized, Map<String, String> roleGroupAliases, Map<String, Map<String, String>> stageAliasLocalized) {
            this(stageCnMap, rateUnit, etaUnit, worldAlias, worldAliasLocalized, coordScale, 2, coordUnitLabel, roleAlias, locale, roleAliasLocalized, roleGroupAliases, stageAliasLocalized);
        }

        public static TemplateOptions from(FileConfiguration cfg) {
            Object v;
            HashMap<String, String> m = new HashMap<String, String>();
            Object raw = cfg.get("templates.stage_cn");
            if (raw instanceof ConfigurationSection) {
                ConfigurationSection sec = (ConfigurationSection)raw;
                for (String k : sec.getKeys(false)) {
                    String v2 = sec.getString(k);
                    if (v2 == null) continue;
                    m.put(k, v2);
                }
            }
            String rate = cfg.getString("templates.progress_units.rate", "per_sec");
            String eta = cfg.getString("templates.progress_units.eta", "ms");
            HashMap<String, String> worldAlias = new HashMap<String, String>();
            Object wa = cfg.get("templates.world_alias");
            if (wa instanceof ConfigurationSection) {
                ConfigurationSection sec2 = (ConfigurationSection)wa;
                for (String k : sec2.getKeys(false)) {
                    String v3 = sec2.getString(k);
                    if (v3 == null) continue;
                    worldAlias.put(k, v3);
                }
            }
            HashMap<String, Map<String, String>> worldAliasLocalized = new HashMap<String, Map<String, String>>();
            Object wal = cfg.get("templates.i18n.world_alias");
            if (wal instanceof ConfigurationSection) {
                ConfigurationSection secw = (ConfigurationSection)wal;
                for (String lang : secw.getKeys(false)) {
                    ConfigurationSection langSec = secw.getConfigurationSection(lang);
                    if (langSec == null) continue;
                    HashMap<String, String> map = new HashMap<String, String>();
                    for (Object k : langSec.getKeys(false)) {
                        String v4 = langSec.getString((String)k);
                        if (v4 == null) continue;
                        map.put((String)k, v4);
                    }
                    worldAliasLocalized.put(lang, map);
                }
            }
            worldAlias.putIfAbsent("world", "\u4e3b\u4e16\u754c");
            worldAlias.putIfAbsent("world_nether", "\u4e0b\u754c");
            worldAlias.putIfAbsent("world_the_end", "\u672b\u5730");
            HashMap<String, String> roleAlias = new HashMap<String, String>();
            Object ra = cfg.get("templates.role_alias");
            if (ra instanceof ConfigurationSection) {
                ConfigurationSection sec3 = (ConfigurationSection)ra;
                for (String k : sec3.getKeys(false)) {
                    String v5 = sec3.getString(k);
                    if (v5 == null) continue;
                    roleAlias.put(k, v5);
                }
            }
            roleAlias.putIfAbsent("admin", "\u7ba1\u7406\u5458");
            roleAlias.putIfAbsent("member", "\u73a9\u5bb6");
            String locale = cfg.getString("templates.locale", "zh-CN");
            HashMap<String, Map<String, String>> roleAliasLocalized = new HashMap<String, Map<String, String>>();
            Object ral = cfg.get("templates.i18n.role_alias");
            if (ral instanceof ConfigurationSection) {
                ConfigurationSection sec4 = (ConfigurationSection)ral;
                for (String lang : sec4.getKeys(false)) {
                    ConfigurationSection langSec = sec4.getConfigurationSection(lang);
                    if (langSec == null) continue;
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    for (String k : langSec.getKeys(false)) {
                        v = langSec.getString(k);
                        if (v == null) continue;
                        map.put(k, v);
                    }
                    roleAliasLocalized.put(lang, map);
                }
            }
            HashMap<String, Map<String, String>> stageAliasLocalized = new HashMap<String, Map<String, String>>();
            Object sal = cfg.get("templates.i18n.stage_alias");
            if (sal instanceof ConfigurationSection) {
                ConfigurationSection secs = (ConfigurationSection)sal;
                for (String lang : secs.getKeys(false)) {
                    ConfigurationSection langSec = secs.getConfigurationSection(lang);
                    if (langSec == null) continue;
                    HashMap<String, String> map = new HashMap<String, String>();
                    for (String k : langSec.getKeys(false)) {
                        String v6 = langSec.getString(k);
                        if (v6 == null) continue;
                        map.put(k, v6);
                    }
                    stageAliasLocalized.put(lang, map);
                }
            }
            HashMap<String, String> roleGroups = new HashMap<String, String>();
            Object rg = cfg.get("templates.role_groups");
            if (rg instanceof ConfigurationSection) {
                ConfigurationSection sec5 = (ConfigurationSection)rg;
                for (String k : sec5.getKeys(false)) {
                    v = sec5.getString(k);
                    if (v == null) continue;
                    roleGroups.put(k, (String)v);
                }
            }
            roleGroups.putIfAbsent("orzmc.admin", "\u7ba1\u7406\u5458");
            roleGroups.putIfAbsent("default", "\u73a9\u5bb6");
            double coordScale = cfg.getDouble("templates.coord.scale", 1.0);
            int coordPrecision = cfg.getInt("templates.coord.precision", 2);
            String coordUnitLabel = cfg.getString("templates.coord.unit_label", "block");
            return new TemplateOptions(m, rate, eta, worldAlias, worldAliasLocalized, coordScale, coordPrecision, coordUnitLabel, roleAlias, locale, roleAliasLocalized, roleGroups, stageAliasLocalized);
        }
    }

    public record Templates(String playerJoin, String playerQuit, String playerKick, String exceptionAlert, String geoipBlock, String tntAlert, String maintenanceBackupStage, String maintenanceBackupDone, String maintenanceBackupError, String maintenanceOptimizeStage, String maintenanceOptimizeDone, String maintenanceOptimizeError, String serverMaintenanceHint, String serverLoad, String serverStop, String whitelistBlock, String whitelistToggleAlert) {
        public static Templates from(FileConfiguration cfg) {
            String base = "templates";
            String join = cfg.getString(base + ".player_join", "{name} \u4e0a\u7ebf\n\u4e16\u754c:{world_alias} \u5750\u6807:{x_unit},{y_unit},{z_unit}({coord_unit})\n\u89d2\u8272:{role_alias}\n------\u5f53\u524d\u5728\u7ebf({online_count}/{max_count})------\n{online_list}");
            String quit = cfg.getString(base + ".player_quit", "{name} \u4e0b\u7ebf\n\u4e16\u754c:{world_alias} \u5750\u6807:{x_unit},{y_unit},{z_unit}({coord_unit})\n\u89d2\u8272:{role_alias}\n------\u5f53\u524d\u5728\u7ebf({online_count}/{max_count})------\n{online_list}");
            String kick = cfg.getString(base + ".player_kick", "{name} \u88ab\u8e22\n\u4e16\u754c:{world_alias} \u5750\u6807:{x_unit},{y_unit},{z_unit}({coord_unit})\n\u89d2\u8272:{role_alias}\n------\u5f53\u524d\u5728\u7ebf({online_count}/{max_count})------\n{online_list}");
            String exceptionAlert = cfg.getString(base + ".exception_alert", "\u5f02\u5e38: {message}\n\u6458\u8981: {stack_summary}");
            String geoipBlock = cfg.getString(base + ".geoip_block", "{name}({ip}) \u5730\u533a:{country_code} \u4e0d\u5728\u5141\u8bb8\u5217\u8868({allow_list})\n{address_info}");
            String tntAlert = cfg.getString(base + ".tnt_alert", "{msg}\n\u4e16\u754c:{world_alias} \u5750\u6807:{x_unit},{y_unit},{z_unit}({coord_unit})\n\u89e6\u53d1:{actor} \u65b9\u5757:{block_type}");
            String mbStage = cfg.getString(base + ".maintenance_backup_stage", "\u5730\u56fe{label} \u9636\u6bb5:{stage}({stage_name}/{stage_i18n}) \u8fdb\u5ea6:{percent}% {current}/{total} \u901f\u7387:{rate_per}{rate_unit} \u9884\u8ba1\u5269\u4f59:{eta_value}{eta_unit}");
            String mbDone = cfg.getString(base + ".maintenance_backup_done", "\u5730\u56fe{label} \u5b8c\u6210 \u7528\u65f6:{duration_ms}ms");
            String mbErr = cfg.getString(base + ".maintenance_backup_error", "\u5730\u56fe{label} \u5931\u8d25 \u7528\u65f6:{duration_ms}ms");
            String moStage = cfg.getString(base + ".maintenance_optimize_stage", "\u5730\u56fe{label} \u9636\u6bb5:{stage}({stage_name}/{stage_i18n}) \u8fdb\u5ea6:{percent}% {current}/{total} \u901f\u7387:{rate_per}{rate_unit} \u9884\u8ba1\u5269\u4f59:{eta_value}{eta_unit}");
            String moDone = cfg.getString(base + ".maintenance_optimize_done", "\u5730\u56fe{label} \u5b8c\u6210 \u7528\u65f6:{duration_ms}ms");
            String moErr = cfg.getString(base + ".maintenance_optimize_error", "\u5730\u56fe{label} \u5931\u8d25 \u7528\u65f6:{duration_ms}ms");
            String maintHint = cfg.getString(base + ".server_maintenance_hint", "\u670d\u52a1\u5668\u5f53\u524d\u65e0\u73a9\u5bb6\uff0c\u53ef\u8fdb\u884c\u670d\u52a1\u5668\u7ef4\u62a4");
            String serverLoad = cfg.getString(base + ".server_load", "{message}");
            String serverStop = cfg.getString(base + ".server_stop", "{message}");
            String whitelistBlock = cfg.getString(base + ".whitelist_block", "{message}");
            String whitelistToggleAlert = cfg.getString(base + ".whitelist_toggle_alert", "{message}");
            return new Templates(join, quit, kick, exceptionAlert, geoipBlock, tntAlert, mbStage, mbDone, mbErr, moStage, moDone, moErr, maintHint, serverLoad, serverStop, whitelistBlock, whitelistToggleAlert);
        }
    }

    public record Notifications(Map<String, NotifyPolicy> policies) {
        public static Notifications from(FileConfiguration cfg) {
            HashMap<String, NotifyPolicy> policies = new HashMap<String, NotifyPolicy>();
            Object raw = cfg.get("notifications");
            if (raw instanceof ConfigurationSection) {
                ConfigurationSection section = (ConfigurationSection)raw;
                for (String key : section.getKeys(false)) {
                    ConfigurationSection s = section.getConfigurationSection(key);
                    if (s == null) continue;
                    boolean privateEnabled = s.getBoolean("private.enabled", false);
                    boolean privateAdminOnly = s.getBoolean("private.admin_only", true);
                    boolean publicEnabled = s.getBoolean("public.enabled", true);
                    String channelKey = s.getString("channel_key", "");
                    policies.put(key, new NotifyPolicy(privateEnabled, privateAdminOnly, publicEnabled, channelKey));
                }
            }
            return new Notifications(policies);
        }
    }

    public record NotifyPolicy(boolean privateEnabled, boolean privateAdminOnly, boolean publicEnabled, String channelKey) {
    }

    public record IpWhitelist(List<String> allowCountryCode) {
        public static IpWhitelist from(FileConfiguration cfg) {
            ArrayList<String> list = new ArrayList<String>();
            Object raw = cfg.get("allow_country_code");
            if (raw instanceof List) {
                List l = (List)raw;
                for (Object o : l) {
                    if (o == null) continue;
                    list.add(String.valueOf(o));
                }
            }
            return new IpWhitelist(list);
        }
    }

    public record Portals(Map<String, PortalEntry> entries) {
        public static Portals from(FileConfiguration cfg) {
            HashMap<String, PortalEntry> entries = new HashMap<String, PortalEntry>();
            Object raw = cfg.get("portals");
            if (raw instanceof ConfigurationSection) {
                ConfigurationSection sec = (ConfigurationSection)raw;
                for (String targetKey : sec.getKeys(false)) {
                    ConfigurationSection centers = sec.getConfigurationSection(targetKey);
                    if (centers == null) continue;
                    String target = SafeKeys.decodeTargetKey(targetKey);
                    for (String center : centers.getKeys(false)) {
                        String axis = centers.getString(center, "X");
                        entries.put(center, new PortalEntry(target, axis));
                    }
                }
            }
            return new Portals(entries);
        }

        public record PortalEntry(String target, String axis) {
        }
    }

    public record Styles(Map<String, String> colors) {
        public static Styles from(FileConfiguration cfg) {
            HashMap<String, String> colors = new HashMap<String, String>();
            String base = "styles.colors";
            Map<String, String> defaults = Map.of("success", "#00FF00", "info", "#55AAFF", "warn", "#FFAA00", "error", "#FF5555", "coord", "#55FF55", "player", "#FF5555", "unknown", "#AAAAAA", "tnt_alert", "#FF5555", "explosion_alert", "#FFAA00");
            defaults.forEach((k, v) -> colors.put((String)k, cfg.getString(base + "." + k, v)));
            return new Styles(colors);
        }
    }

    public record CommandPolicies(Map<String, CommandPolicy> policies) {
        public static CommandPolicies from(FileConfiguration cfg) {
            HashMap<String, CommandPolicy> policies = new HashMap<String, CommandPolicy>();
            Object rawCmds = cfg.get("commands");
            if (rawCmds instanceof ConfigurationSection) {
                ConfigurationSection section = (ConfigurationSection)rawCmds;
                for (String key : section.getKeys(false)) {
                    ConfigurationSection s = section.getConfigurationSection(key);
                    if (s == null) continue;
                    int cooldown = s.getInt("cooldown_secs", 0);
                    boolean adminOnly = s.getBoolean("admin_only", false);
                    policies.put(key, new CommandPolicy(cooldown, adminOnly));
                }
            }
            return new CommandPolicies(policies);
        }
    }

    public record CommandPolicy(int cooldownSeconds, boolean adminOnly) {
    }

    public record TntConfig(boolean enable, boolean enableRespawnAnchor, int placeCooldownSeconds, long notifyThrottleMs, List<Map<String, Object>> whitelistRegions, List<String> exemptEntities) {
        public static TntConfig from(FileConfiguration cfg) {
            boolean enable = cfg.getBoolean("enable", false);
            boolean enableRespawnAnchor = cfg.getBoolean("enable_respawn_anchor", false);
            int placeCooldownSeconds = cfg.getInt("place_cooldown", 5);
            long notifyThrottleMs = cfg.getLong("notify_throttle_ms", 1000L);
            ArrayList<Map<String, Object>> whitelistRegions = new ArrayList<Map<String, Object>>();
            Object rawRegions = cfg.get("whitelist");
            if (rawRegions instanceof List) {
                List list = (List)rawRegions;
                for (Object o : list) {
                    if (!(o instanceof Map)) continue;
                    Map m = (Map)o;
                    whitelistRegions.add(m);
                }
            }
            ArrayList<String> exemptEntities = new ArrayList<String>();
            Object rawExempt = cfg.get("exempt_entities");
            if (rawExempt instanceof List) {
                List list = (List)rawExempt;
                for (Object o : list) {
                    if (o == null) continue;
                    exemptEntities.add(String.valueOf(o));
                }
            }
            return new TntConfig(enable, enableRespawnAnchor, placeCooldownSeconds, notifyThrottleMs, whitelistRegions, exemptEntities);
        }
    }

    public record MainConfig(boolean forceWhitelist, int whitelistCleanupInactiveDays, int whitelistPaginationDelayTicks, String cmdPromptChar, boolean optimizeEnabled, boolean optimizeOnShutdown, long optimizeTickTimeThreshold, int backupRetentionCount, String backupMaintenanceMotd, List<String> allowCountryCode, Map<String, CommandPolicy> commandPolicies) {
        public static MainConfig from(FileConfiguration cfg) {
            boolean forceWhitelist = cfg.getBoolean("force_whitelist", true);
            int whitelistCleanupInactiveDays = cfg.getInt("whitelist_cleanup_inactive_days", 90);
            int whitelistPaginationDelayTicks = cfg.getInt("whitelist_pagination_delay_ticks", 5);
            String cmdPromptChar = cfg.getString("cmd_prompt_char", "$");
            boolean optimizeEnabled = cfg.getBoolean("optimize_enabled", false);
            boolean optimizeOnShutdown = cfg.getBoolean("optimize_on_shutdown", false);
            long optimizeTickTimeThreshold = cfg.getLong("optimize_tick_time_threshold", 300L);
            int backupRetentionCount = cfg.getInt("backup_retention_count", 5);
            String backupMaintenanceMotd = cfg.getString("backup_maintenance_motd", "\u670d\u52a1\u5668\u7ef4\u62a4\u4e2d\uff0c\u7a0d\u540e\u518d\u8bd5");
            ArrayList<String> allowCodes = new ArrayList<String>();
            Object raw = cfg.get("allow_country_code");
            if (raw instanceof List) {
                List list = (List)raw;
                for (Object o : list) {
                    if (o == null) continue;
                    allowCodes.add(String.valueOf(o));
                }
            }
            HashMap<String, CommandPolicy> policies = new HashMap<String, CommandPolicy>();
            Object rawCmds = cfg.get("commands");
            if (rawCmds instanceof ConfigurationSection) {
                ConfigurationSection section = (ConfigurationSection)rawCmds;
                for (String key : section.getKeys(false)) {
                    ConfigurationSection s = section.getConfigurationSection(key);
                    if (s == null) continue;
                    int cooldown = s.getInt("cooldown_secs", 0);
                    boolean adminOnly = s.getBoolean("admin_only", false);
                    policies.put(key, new CommandPolicy(cooldown, adminOnly));
                }
            }
            return new MainConfig(forceWhitelist, whitelistCleanupInactiveDays, whitelistPaginationDelayTicks, cmdPromptChar, optimizeEnabled, optimizeOnShutdown, optimizeTickTimeThreshold, backupRetentionCount, backupMaintenanceMotd, allowCodes, policies);
        }
    }
}

