/*
 * Decompiled with CFR 0.152.
 */
package com.jokerhub.paper.plugin.orzmc.infra.config;

import com.jokerhub.paper.plugin.orzmc.infra.config.SafeKeys;
import com.jokerhub.paper.plugin.orzmc.infra.config.TypedConfigs;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;

public final class PortalsWriter {
    private PortalsWriter() {
    }

    public static void write(FileConfiguration cfg, Map<String, TypedConfigs.Portals.PortalEntry> entries) {
        if (cfg == null || entries == null) {
            return;
        }
        HashMap<String, Map> grouped = new HashMap<String, Map>();
        for (Map.Entry<String, TypedConfigs.Portals.PortalEntry> e : entries.entrySet()) {
            String center = e.getKey();
            TypedConfigs.Portals.PortalEntry pe = e.getValue();
            String safe = SafeKeys.encodeTargetKey(pe.target());
            grouped.computeIfAbsent(safe, k -> new HashMap()).put(center, pe.axis());
        }
        Object raw = cfg.get("portals");
        if (raw instanceof ConfigurationSection) {
            ConfigurationSection sec = (ConfigurationSection)raw;
            for (String k2 : sec.getKeys(false)) {
                cfg.set("portals." + k2, null);
            }
        }
        for (Map.Entry ge : grouped.entrySet()) {
            String target = (String)ge.getKey();
            for (Map.Entry ce : ((Map)ge.getValue()).entrySet()) {
                cfg.set("portals." + target + "." + (String)ce.getKey(), ce.getValue());
            }
        }
    }
}

