/*
 * Decompiled with CFR 0.152.
 */
package com.jokerhub.paper.plugin.orzmc.infra.config;

import com.jokerhub.paper.plugin.orzmc.OrzMC;
import com.jokerhub.paper.plugin.orzmc.infra.config.AdvancedConfigManager;
import com.jokerhub.paper.plugin.orzmc.infra.config.ConfigHealthCheck;
import java.io.File;
import java.util.List;
import org.bukkit.configuration.file.FileConfiguration;

public final class ConfigService {
    private final OrzMC plugin;
    private final AdvancedConfigManager configManager;

    public ConfigService(OrzMC plugin) {
        this.plugin = plugin;
        this.configManager = new AdvancedConfigManager(plugin);
    }

    public void setup() {
        this.configManager.registerConfig("config");
        this.configManager.registerConfig("bot");
        this.configManager.setDefaults("bot", config -> {});
        this.configManager.registerConfig("guide_book");
        this.configManager.setDefaults("guide_book", config -> {});
        this.configManager.registerConfig("tnt");
        this.configManager.setDefaults("tnt", config -> {
            if (!config.contains("notify_throttle_ms")) {
                config.set("notify_throttle_ms", (Object)1000);
            }
        });
        this.configManager.registerConfig("templates");
        this.configManager.registerConfig("notifications");
        this.configManager.registerConfig("commands");
        this.configManager.registerConfig("maintenance");
        this.configManager.registerConfig("whitelist");
        this.configManager.registerConfig("styles");
        this.configManager.registerConfig("ip_whitelist");
        this.configManager.registerConfig("portals");
        this.configManager.setDefaults("whitelist", cfg -> {
            if (!cfg.contains("force_whitelist")) {
                cfg.set("force_whitelist", (Object)true);
            }
            if (!cfg.contains("cleanup_inactive_days")) {
                cfg.set("cleanup_inactive_days", (Object)90);
            }
            if (!cfg.contains("pagination_delay_ticks")) {
                cfg.set("pagination_delay_ticks", (Object)5);
            }
        });
        this.configManager.setDefaults("maintenance", cfg -> {
            if (!cfg.contains("optimize_enabled")) {
                cfg.set("optimize_enabled", (Object)false);
            }
            if (!cfg.contains("optimize_on_shutdown")) {
                cfg.set("optimize_on_shutdown", (Object)false);
            }
            if (!cfg.contains("optimize_tick_time_threshold")) {
                cfg.set("optimize_tick_time_threshold", (Object)300);
            }
            if (!cfg.contains("backup_retention_count")) {
                cfg.set("backup_retention_count", (Object)5);
            }
            if (!cfg.contains("backup_maintenance_motd")) {
                cfg.set("backup_maintenance_motd", (Object)"\u670d\u52a1\u5668\u7ef4\u62a4\u4e2d\uff0c\u7a0d\u540e\u518d\u8bd5");
            }
        });
        this.validateCriticalConfigs();
        List<String> issues = ConfigHealthCheck.validateAll(this.configManager);
        if (!issues.isEmpty()) {
            this.plugin.getLogger().warning("\u914d\u7f6e\u5065\u5eb7\u68c0\u67e5\u53d1\u73b0\u95ee\u9898:");
            for (String s : issues) {
                this.plugin.getLogger().warning(" - " + s);
            }
        }
    }

    public void tearDown() {
        for (String configName : this.configManager.getConfigNames()) {
            this.configManager.saveConfig(configName);
        }
    }

    public FileConfiguration getConfig(String name) {
        return this.configManager.getConfig(name);
    }

    public AdvancedConfigManager manager() {
        return this.configManager;
    }

    public boolean reloadConfig(String name) {
        return this.configManager.reloadConfig(name);
    }

    public boolean saveConfig(String name) {
        return this.configManager.saveConfig(name);
    }

    private void warnMissingKey(String configName, String path) {
        try {
            FileConfiguration cfg = this.configManager.getConfig(configName);
            if (cfg == null || !cfg.contains(path)) {
                String filePath = new File(this.plugin.getDataFolder(), configName + ".yml").getAbsolutePath();
                this.plugin.getLogger().warning("\u7f3a\u5931\u5173\u952e\u914d\u7f6e: " + configName + "." + path);
                this.plugin.getLogger().warning("\u6587\u4ef6: " + filePath);
                this.plugin.getLogger().warning("\u8bf7\u53c2\u8003 README \u7684\u201c\u914d\u7f6e\u62c6\u5206\u6307\u5357/\u5b9e\u64cd\u793a\u4f8b\u201d\u4fee\u590d\u8be5\u952e");
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("\u8bfb\u53d6\u914d\u7f6e\u5931\u8d25: " + configName + "." + path + " - " + e.getMessage());
        }
    }

    private void validateCriticalConfigs() {
        this.warnMissingKey("templates", "templates.player_join");
        this.warnMissingKey("templates", "templates.world_alias.world");
        this.warnMissingKey("templates", "templates.coord.unit_label");
        this.warnMissingKey("notifications", "notifications.tnt_alert.public.enabled");
        this.warnMissingKey("commands", "commands.tpbow.cooldown_secs");
        this.warnMissingKey("whitelist", "force_whitelist");
        this.warnMissingKey("whitelist", "cleanup_inactive_days");
        this.warnMissingKey("whitelist", "pagination_delay_ticks");
        this.warnMissingKey("maintenance", "optimize_enabled");
        this.warnMissingKey("maintenance", "optimize_tick_time_threshold");
        this.warnMissingKey("maintenance", "backup_retention_count");
    }
}

