/*
 * Decompiled with CFR 0.152.
 */
package com.jokerhub.paper.plugin.orzmc.infra.config;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class ConfigManager {
    private final JavaPlugin plugin;
    private final Map<String, FileConfiguration> configs;
    private final Map<String, File> configFiles;

    public ConfigManager(JavaPlugin plugin) {
        this.plugin = plugin;
        this.configs = new HashMap<String, FileConfiguration>();
        this.configFiles = new HashMap<String, File>();
        if (!plugin.getDataFolder().exists()) {
            boolean ret = plugin.getDataFolder().mkdirs();
            plugin.getLogger().info("\u521b\u5efa\u63d2\u4ef6\u6570\u636e\u6587\u4ef6\u5939" + (ret ? "\u6210\u529f" : "\u5931\u8d25"));
        }
    }

    public boolean registerConfig(String name) {
        return this.registerConfig(name, name + ".yml");
    }

    public boolean registerConfig(String name, String fileName) {
        try {
            File configFile = new File(this.plugin.getDataFolder(), fileName);
            if (!configFile.exists()) {
                this.plugin.saveResource(fileName, false);
                this.plugin.getLogger().info("\u521b\u5efa\u9ed8\u8ba4\u914d\u7f6e\u6587\u4ef6: " + fileName);
            }
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
            this.configs.put(name, (FileConfiguration)config);
            this.configFiles.put(name, configFile);
            this.plugin.getLogger().info("\u6210\u529f\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6: " + fileName);
            return true;
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6\u5931\u8d25: " + fileName + " - " + e.getMessage());
            return false;
        }
    }

    public FileConfiguration getConfig(String name) {
        return this.configs.get(name);
    }

    public boolean saveConfig(String name) {
        if (!this.configs.containsKey(name) || !this.configFiles.containsKey(name)) {
            return false;
        }
        try {
            this.configs.get(name).save(this.configFiles.get(name));
            return true;
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("\u4fdd\u5b58\u914d\u7f6e\u6587\u4ef6\u5931\u8d25: " + name + " - " + e.getMessage());
            return false;
        }
    }

    public boolean reloadConfig(String name) {
        if (!this.configFiles.containsKey(name)) {
            return false;
        }
        try {
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)this.configFiles.get(name));
            this.configs.put(name, (FileConfiguration)config);
            return true;
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("\u91cd\u8f7d\u914d\u7f6e\u6587\u4ef6\u5931\u8d25: " + name + " - " + e.getMessage());
            return false;
        }
    }

    public boolean configExists(String name) {
        return this.configs.containsKey(name);
    }

    public Set<String> getConfigNames() {
        return this.configs.keySet();
    }
}

