/*
 * Decompiled with CFR 0.152.
 */
package com.jokerhub.paper.plugin.orzmc.infra.config;

import com.jokerhub.paper.plugin.orzmc.infra.config.AdvancedConfigManager;
import com.jokerhub.paper.plugin.orzmc.infra.config.SafeKeys;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;

public final class ConfigHealthCheck {
    private ConfigHealthCheck() {
    }

    public static List<String> validateAll(AdvancedConfigManager mgr) {
        ArrayList<String> issues = new ArrayList<String>();
        ConfigHealthCheck.validateStyles(mgr.getConfig("styles"), issues);
        ConfigHealthCheck.validateIpWhitelist(mgr.getConfig("ip_whitelist"), issues);
        ConfigHealthCheck.validatePortals(mgr.getConfig("portals"), issues);
        ConfigHealthCheck.validateTemplates(mgr.getConfig("templates"), issues);
        ConfigHealthCheck.validateNotifications(mgr.getConfig("notifications"), mgr.getConfig("bot"), mgr.getConfig("templates"), issues);
        ConfigHealthCheck.validateCommands(mgr.getConfig("commands"), issues);
        ConfigHealthCheck.validateWhitelist(mgr.getConfig("whitelist"), issues);
        ConfigHealthCheck.validateMaintenance(mgr.getConfig("maintenance"), issues);
        return issues;
    }

    private static void validateStyles(FileConfiguration cfg, List<String> issues) {
        String[] keys;
        if (cfg == null) {
            issues.add("styles.yml \u672a\u52a0\u8f7d");
            return;
        }
        String base = "styles.colors.";
        for (String k : keys = new String[]{"success", "info", "warn", "error", "coord", "player", "unknown", "tnt_alert", "explosion_alert"}) {
            Object v = cfg.get(base + k);
            if (v == null) {
                issues.add("\u7f3a\u5931: styles.colors." + k);
                continue;
            }
            String s = String.valueOf(v);
            if (s.matches("^#[0-9A-Fa-f]{6}$")) continue;
            issues.add("\u975e\u6cd5: styles.colors." + k + " \u5fc5\u987b\u4e3a #RRGGBB");
        }
    }

    private static void validatePortals(FileConfiguration cfg, List<String> issues) {
        if (cfg == null) {
            issues.add("portals.yml \u672a\u52a0\u8f7d");
            return;
        }
        Object raw = cfg.get("portals");
        if (raw instanceof ConfigurationSection) {
            ConfigurationSection sec = (ConfigurationSection)raw;
            for (String k : sec.getKeys(false)) {
                String[] hp;
                ConfigurationSection s = sec.getConfigurationSection(k);
                if (s == null) {
                    issues.add("\u975e\u6cd5: portals." + k + " \u8282\u70b9\u4e3a\u7a7a");
                    continue;
                }
                String target = SafeKeys.decodeTargetKey(k);
                for (String center : s.getKeys(false)) {
                    String axis;
                    String[] parts = center.split(":");
                    if (parts.length != 4) {
                        issues.add("\u975e\u6cd5: portals." + target + " \u4e0b\u952e\u9700\u4e3a world:cx:cy:cz");
                        continue;
                    }
                    try {
                        Integer.parseInt(parts[1]);
                        Integer.parseInt(parts[2]);
                        Integer.parseInt(parts[3]);
                    }
                    catch (Exception e) {
                        issues.add("\u975e\u6cd5: portals \u5750\u6807\u9700\u4e3a\u6574\u6570");
                    }
                    if ((axis = s.getString(center, "X")).equalsIgnoreCase("X") || axis.equalsIgnoreCase("Z")) continue;
                    issues.add("\u975e\u6cd5: portals \u8f74\u5411\u53d6\u503c X/Z");
                }
                if (!target.contains(":") || (hp = target.split(":")).length != 2) continue;
                try {
                    int port = Integer.parseInt(hp[1]);
                    if (port > 0 && port <= 65535) continue;
                    issues.add("\u975e\u6cd5: portals \u7aef\u53e3\u8303\u56f4 1-65535");
                }
                catch (Exception e) {
                    issues.add("\u7c7b\u578b\u9519\u8bef: portals \u7aef\u53e3\u9700\u4e3a\u6570\u5b57");
                }
            }
        }
    }

    private static void validateIpWhitelist(FileConfiguration cfg, List<String> issues) {
        if (cfg == null) {
            issues.add("ip_whitelist.yml \u672a\u52a0\u8f7d");
            return;
        }
        Object raw = cfg.get("allow_country_code");
        if (raw == null) {
            issues.add("\u5efa\u8bae: ip_whitelist.allow_country_code \u672a\u914d\u7f6e\uff0c\u9ed8\u8ba4\u5141\u8bb8\u6240\u6709\u5730\u533a");
        } else if (raw instanceof List) {
            List list = (List)raw;
            for (Object o : list) {
                if (o == null) {
                    issues.add("\u975e\u6cd5: ip_whitelist.allow_country_code \u4e0d\u5141\u8bb8\u7a7a\u9879");
                    continue;
                }
                String code = String.valueOf(o);
                if (code.matches("^[A-Z]{2}$")) continue;
                issues.add("\u975e\u6cd5: ip_whitelist.allow_country_code '" + code + "' \u5fc5\u987b\u4e3a\u5927\u5199\u4e24\u4f4d\u56fd\u5bb6\u7801");
            }
        } else {
            issues.add("\u7c7b\u578b\u9519\u8bef: ip_whitelist.allow_country_code \u9700\u4e3a\u5217\u8868");
        }
    }

    private static void validateTemplates(FileConfiguration cfg, List<String> issues) {
        Object rawFmt;
        String[] requiredTemplates;
        Object cal;
        Object sal;
        Object ral;
        Object wal;
        String locale;
        String eta;
        String rate;
        String unit;
        int precision;
        double scale;
        if (cfg == null) {
            issues.add("templates.yml \u672a\u52a0\u8f7d");
            return;
        }
        String base = "templates";
        if (!cfg.contains(base + ".player_join")) {
            issues.add("\u7f3a\u5931: templates.player_join");
        }
        if ((scale = cfg.getDouble(base + ".coord.scale", 1.0)) <= 0.0) {
            issues.add("\u975e\u6cd5: templates.coord.scale \u5fc5\u987b\u4e3a\u6b63\u6570");
        }
        if ((precision = cfg.getInt(base + ".coord.precision", 2)) < 0) {
            issues.add("\u975e\u6cd5: templates.coord.precision \u4e0d\u5f97\u4e3a\u8d1f\u6570");
        }
        if ((unit = cfg.getString(base + ".coord.unit_label", "block")).isEmpty()) {
            issues.add("\u7f3a\u5931: templates.coord.unit_label");
        }
        if (!(rate = cfg.getString(base + ".progress_units.rate", "per_sec")).equalsIgnoreCase("per_sec") && !rate.equalsIgnoreCase("per_min")) {
            issues.add("\u975e\u6cd5: templates.progress_units.rate \u53d6\u503c per_sec/per_min");
        }
        if (!((eta = cfg.getString(base + ".progress_units.eta", "ms")).equalsIgnoreCase("ms") || eta.equalsIgnoreCase("sec") || eta.equalsIgnoreCase("min"))) {
            issues.add("\u975e\u6cd5: templates.progress_units.eta \u53d6\u503c ms/sec/min");
        }
        if ((locale = cfg.getString(base + ".locale", "zh-CN")).isEmpty()) {
            issues.add("\u7f3a\u5931: templates.locale");
        }
        if ((wal = cfg.get("templates.i18n.world_alias")) != null && !(wal instanceof ConfigurationSection)) {
            issues.add("\u7c7b\u578b\u9519\u8bef: templates.i18n.world_alias \u9700\u4e3a\u5bf9\u8c61\u6620\u5c04");
        }
        if ((ral = cfg.get("templates.i18n.role_alias")) != null && !(ral instanceof ConfigurationSection)) {
            issues.add("\u7c7b\u578b\u9519\u8bef: templates.i18n.role_alias \u9700\u4e3a\u5bf9\u8c61\u6620\u5c04");
        }
        if ((sal = cfg.get("templates.i18n.stage_alias")) != null && !(sal instanceof ConfigurationSection)) {
            issues.add("\u7c7b\u578b\u9519\u8bef: templates.i18n.stage_alias \u9700\u4e3a\u5bf9\u8c61\u6620\u5c04");
        }
        if ((cal = cfg.get("templates.i18n.command")) != null && !(cal instanceof ConfigurationSection)) {
            issues.add("\u7c7b\u578b\u9519\u8bef: templates.i18n.command \u9700\u4e3a\u5bf9\u8c61\u6620\u5c04");
        }
        if (!cfg.contains("templates.world_alias.world")) {
            issues.add("\u5efa\u8bae: templates.world_alias.world \u7f3a\u5931");
        }
        if (!cfg.contains("templates.world_alias.world_nether")) {
            issues.add("\u5efa\u8bae: templates.world_alias.world_nether \u7f3a\u5931");
        }
        if (!cfg.contains("templates.world_alias.world_the_end")) {
            issues.add("\u5efa\u8bae: templates.world_alias.world_the_end \u7f3a\u5931");
        }
        if (!cfg.contains("templates.role_alias.admin")) {
            issues.add("\u5efa\u8bae: templates.role_alias.admin \u7f3a\u5931");
        }
        if (!cfg.contains("templates.role_alias.member")) {
            issues.add("\u5efa\u8bae: templates.role_alias.member \u7f3a\u5931");
        }
        String[] commandKeys = new String[]{"command_output", "command_help", "command_players", "command_whitelist_header", "command_whitelist_page", "command_whitelist_cleanup", "command_whitelist_add_result", "command_whitelist_remove_result", "command_admin_required", "command_usage", "command_backup", "command_optimize", "command_optimize_disabled"};
        for (String key : requiredTemplates = new String[]{"command_output", "command_help", "command_players", "command_whitelist_header", "command_whitelist_page", "command_whitelist_cleanup", "command_whitelist_add_result", "command_whitelist_remove_result", "command_admin_required", "command_usage", "command_backup", "command_optimize", "command_optimize_disabled", "server_load", "server_stop", "whitelist_block", "whitelist_toggle_alert", "player_join", "player_quit", "player_kick", "exception_alert", "geoip_block", "tnt_alert", "maintenance_backup_stage", "maintenance_backup_done", "maintenance_backup_error", "maintenance_optimize_stage", "maintenance_optimize_done", "maintenance_optimize_error", "server_maintenance_hint"}) {
            if (cfg.contains("templates." + key)) continue;
            issues.add("\u7f3a\u5931: templates." + key);
        }
        if (cal instanceof ConfigurationSection) {
            ConfigurationSection cmdSec = (ConfigurationSection)cal;
            for (String localeKey : cmdSec.getKeys(false)) {
                ConfigurationSection langSec = cmdSec.getConfigurationSection(localeKey);
                if (langSec == null) continue;
                for (String key : commandKeys) {
                    if (langSec.contains(key)) continue;
                    issues.add("\u5efa\u8bae: templates.i18n.command." + localeKey + "." + key + " \u7f3a\u5931");
                }
            }
        }
        if ((rawFmt = cfg.get("templates.format")) instanceof ConfigurationSection) {
            ConfigurationSection sec = (ConfigurationSection)rawFmt;
            for (String key : sec.getKeys(false)) {
                String raw = sec.getString(key, "DEFAULT");
                if (raw.isEmpty()) {
                    issues.add("\u975e\u6cd5: templates.format." + key + " \u4e0d\u53ef\u4e3a\u7a7a");
                    continue;
                }
                String v = raw.toUpperCase();
                if (!("DEFAULT".equals(v) || "PLAIN".equals(v) || "CODE_BLOCK".equals(v))) {
                    issues.add("\u975e\u6cd5: templates.format." + key + " \u503c\u65e0\u6548: " + raw);
                }
                if (cfg.contains("templates." + key)) continue;
                issues.add("\u5efa\u8bae: templates.format." + key + " \u672a\u627e\u5230\u5bf9\u5e94\u6a21\u677f");
            }
        }
    }

    private static void validateNotifications(FileConfiguration cfg, FileConfiguration botCfg, FileConfiguration templatesCfg, List<String> issues) {
        Object raw;
        String ck;
        Object ch;
        if (cfg == null) {
            issues.add("notifications.yml \u672a\u52a0\u8f7d");
            return;
        }
        String key = "notifications.tnt_alert.public.enabled";
        Object v = cfg.get(key);
        if (!(v instanceof Boolean)) {
            issues.add("\u7c7b\u578b\u9519\u8bef: " + key + " \u9700\u4e3a\u5e03\u5c14\u503c");
        }
        if ((ch = cfg.get(ck = "notifications.tnt_alert.channel_key")) != null && String.valueOf(ch).isEmpty()) {
            issues.add("\u975e\u6cd5: " + ck + " \u4e0d\u53ef\u4e3a\u7a7a\u5b57\u7b26\u4e32");
        }
        if ((raw = cfg.get("notifications")) instanceof ConfigurationSection) {
            ConfigurationSection sec = (ConfigurationSection)raw;
            for (String eventKey : sec.getKeys(false)) {
                String lark;
                String ckey;
                if (templatesCfg != null && !templatesCfg.contains("templates." + eventKey)) {
                    issues.add("\u901a\u77e5\u4e8b\u4ef6\u7f3a\u5c11\u6a21\u677f: notifications." + eventKey);
                }
                if ((ckey = cfg.getString("notifications." + eventKey + ".channel_key", "")).isEmpty()) continue;
                String qq = botCfg == null ? null : botCfg.getString("channels." + ckey + ".qq");
                String discord = botCfg == null ? null : botCfg.getString("channels." + ckey + ".discord");
                String string = lark = botCfg == null ? null : botCfg.getString("channels." + ckey + ".lark");
                if (qq != null && !qq.isEmpty() || discord != null && !discord.isEmpty() || lark != null && !lark.isEmpty()) continue;
                issues.add("\u901a\u77e5\u9891\u9053\u672a\u6620\u5c04: notifications." + eventKey + ".channel_key=" + ckey);
            }
        }
    }

    private static void validateCommands(FileConfiguration cfg, List<String> issues) {
        Object r2;
        if (cfg == null) {
            issues.add("commands.yml \u672a\u52a0\u8f7d");
            return;
        }
        Object r1 = cfg.get("commands.tpbow.cooldown_secs");
        if (r1 != null) {
            try {
                int val = Integer.parseInt(String.valueOf(r1));
                if (val < 0) {
                    issues.add("\u975e\u6cd5: commands.tpbow.cooldown_secs \u4e0d\u5f97\u4e3a\u8d1f\u6570");
                }
            }
            catch (Exception e) {
                issues.add("\u7c7b\u578b\u9519\u8bef: commands.tpbow.cooldown_secs \u9700\u4e3a\u6570\u5b57");
            }
        }
        if ((r2 = cfg.get("commands.tpbow.admin_only")) != null && !(r2 instanceof Boolean)) {
            issues.add("\u7c7b\u578b\u9519\u8bef: commands.tpbow.admin_only \u9700\u4e3a\u5e03\u5c14\u503c");
        }
    }

    private static void validateWhitelist(FileConfiguration cfg, List<String> issues) {
        int ticks;
        int days;
        if (cfg == null) {
            issues.add("whitelist.yml \u672a\u52a0\u8f7d");
            return;
        }
        Object fw = cfg.get("force_whitelist");
        if (!(fw instanceof Boolean)) {
            issues.add("\u7c7b\u578b\u9519\u8bef: whitelist.force_whitelist \u9700\u4e3a\u5e03\u5c14\u503c");
        }
        if ((days = cfg.getInt("cleanup_inactive_days", 90)) <= 0) {
            issues.add("\u975e\u6cd5: whitelist.cleanup_inactive_days \u5fc5\u987b\u4e3a\u6b63\u6570");
        }
        if ((ticks = cfg.getInt("pagination_delay_ticks", 5)) < 0) {
            issues.add("\u975e\u6cd5: whitelist.pagination_delay_ticks \u4e0d\u5f97\u4e3a\u8d1f\u6570");
        }
    }

    private static void validateMaintenance(FileConfiguration cfg, List<String> issues) {
        String motd;
        int retain;
        int thr;
        Object os;
        if (cfg == null) {
            issues.add("maintenance.yml \u672a\u52a0\u8f7d");
            return;
        }
        Object en = cfg.get("optimize_enabled");
        if (!(en instanceof Boolean)) {
            issues.add("\u7c7b\u578b\u9519\u8bef: maintenance.optimize_enabled \u9700\u4e3a\u5e03\u5c14\u503c");
        }
        if (!((os = cfg.get("optimize_on_shutdown")) instanceof Boolean)) {
            issues.add("\u7c7b\u578b\u9519\u8bef: maintenance.optimize_on_shutdown \u9700\u4e3a\u5e03\u5c14\u503c");
        }
        if ((thr = cfg.getInt("optimize_tick_time_threshold", 300)) <= 0) {
            issues.add("\u975e\u6cd5: maintenance.optimize_tick_time_threshold \u5fc5\u987b\u4e3a\u6b63\u6570");
        }
        if ((retain = cfg.getInt("backup_retention_count", 5)) < 0) {
            issues.add("\u975e\u6cd5: maintenance.backup_retention_count \u4e0d\u5f97\u4e3a\u8d1f\u6570");
        }
        if ((motd = cfg.getString("backup_maintenance_motd", "")).isEmpty()) {
            issues.add("\u7f3a\u5931: maintenance.backup_maintenance_motd");
        }
    }
}

