/*
 * Decompiled with CFR 0.152.
 */
package com.jokerhub.paper.plugin.orzmc.infra.bot;

import com.google.gson.Gson;
import com.jokerhub.paper.plugin.orzmc.OrzMC;
import com.jokerhub.paper.plugin.orzmc.infra.bot.MessageEnvelope;
import com.jokerhub.paper.plugin.orzmc.infra.bot.MessageFormatter;
import com.jokerhub.paper.plugin.orzmc.infra.bot.OrzBaseBot;
import com.jokerhub.paper.plugin.orzmc.infra.config.ConfigService;
import com.jokerhub.paper.plugin.orzmc.infra.health.HealthRegistry;
import com.jokerhub.paper.plugin.orzmc.infra.logging.ThrottledLogger;
import com.jokerhub.paper.plugin.orzmc.infra.net.AsyncHttp;
import java.time.Duration;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;

public class OrzLarkBot
extends OrzBaseBot {
    private final MessageFormatter formatter;
    private final ThrottledLogger throttledLogger;

    public OrzLarkBot(OrzMC plugin, ConfigService configService, MessageFormatter formatter, ThrottledLogger throttledLogger) {
        super(plugin, configService);
        this.formatter = formatter;
        this.throttledLogger = throttledLogger;
    }

    @Override
    public boolean isEnable() {
        return this.botConfig.getBoolean("enable_lark_bot");
    }

    @Override
    public void setup() {
    }

    @Override
    public void teardown() {
    }

    @Override
    protected void sendPublic(String msg) {
        if (!this.isEnable()) {
            return;
        }
        HealthRegistry.setEnabled("lark", true);
        try {
            String larkBotWebhookUrl = this.botConfig.getString("lark_bot_webhook");
            for (String part : this.formatter.format(msg, MessageEnvelope.Format.DEFAULT)) {
                this.asyncHttpRequest(larkBotWebhookUrl, part);
            }
        }
        catch (Exception e) {
            HealthRegistry.setLastError("lark", e.toString());
            OrzMC.logger().info(e.toString());
        }
    }

    @Override
    protected void sendPrivate(String message) {
    }

    @Override
    protected void sendChannel(String channelKey, String message) {
        if (!this.isEnable()) {
            return;
        }
        try {
            String url = this.botConfig.getString("channels." + channelKey + ".lark");
            if (url == null || url.isEmpty()) {
                this.sendPublic(message);
                return;
            }
            for (String part : this.formatter.format(message, MessageEnvelope.Format.DEFAULT)) {
                this.asyncHttpRequest(url, part);
            }
        }
        catch (Exception e) {
            HealthRegistry.setLastError("lark", e.toString());
            OrzMC.logger().info(e.toString());
        }
    }

    private void asyncHttpRequest(String url, String msg) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("msg_type", "text");
        HashMap<String, String> content = new HashMap<String, String>();
        content.put("text", msg);
        params.put("content", content);
        String postBodyJsonString = new Gson().toJson(params);
        int retries = this.botConfig.getInt("http_max_retries");
        long connectSec = this.botConfig.getLong("http_connect_timeout_seconds");
        long requestSec = this.botConfig.getLong("http_request_timeout_seconds");
        ((CompletableFuture)AsyncHttp.postJson(url, postBodyJsonString, null, Duration.ofSeconds(connectSec <= 0L ? 3L : connectSec), Duration.ofSeconds(requestSec <= 0L ? 3L : requestSec), retries <= 0 ? 3 : retries).thenAcceptAsync(response -> {
            OrzMC.debugInfo("Response : " + response.toString());
            if (response.statusCode() == 200) {
                HealthRegistry.setHttpOk("lark", true);
                HealthRegistry.setLastError("lark", null);
            }
        })).exceptionally(e -> {
            HealthRegistry.setHttpOk("lark", false);
            HealthRegistry.setLastError("lark", e.toString());
            this.throttledLogger.error("lark-http", "Lark\u673a\u5668\u4eba\u65e0\u6cd5\u8fde\u63a5\uff0c\u5de5\u4f5c\u5f02\u5e38: " + String.valueOf(e));
            return null;
        });
    }
}

