/*
 * Decompiled with CFR 0.152.
 */
package com.jokerhub.paper.plugin.orzmc.infra.bot;

import com.jokerhub.paper.plugin.orzmc.OrzMC;
import com.jokerhub.paper.plugin.orzmc.infra.bot.BotInboundDispatcher;
import com.jokerhub.paper.plugin.orzmc.infra.bot.BotInboundHandler;
import com.jokerhub.paper.plugin.orzmc.infra.bot.MessageEnvelope;
import com.jokerhub.paper.plugin.orzmc.infra.bot.MessageFormatter;
import com.jokerhub.paper.plugin.orzmc.infra.bot.OrzBaseBot;
import com.jokerhub.paper.plugin.orzmc.infra.config.ConfigService;
import com.jokerhub.paper.plugin.orzmc.infra.health.HealthRegistry;
import com.jokerhub.paper.plugin.orzmc.infra.logging.ThrottledLogger;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.JDABuilder;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.entities.Activity;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.channel.concrete.TextChannel;
import net.dv8tion.jda.api.entities.channel.unions.MessageChannelUnion;
import net.dv8tion.jda.api.events.message.MessageReceivedEvent;
import net.dv8tion.jda.api.events.session.ReadyEvent;
import net.dv8tion.jda.api.hooks.ListenerAdapter;
import net.dv8tion.jda.api.requests.GatewayIntent;
import okhttp3.OkHttpClient;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class OrzDiscordBot
extends OrzBaseBot {
    private final ArrayList<String> toBeSendMessageWhenApiReady = new ArrayList();
    private final BotInboundHandler inboundHandler;
    private final MessageFormatter formatter;
    private final ThrottledLogger throttledLogger;
    private JDA api;
    private boolean isApiReady;

    public OrzDiscordBot(OrzMC plugin, ConfigService configService, BotInboundHandler inboundHandler, MessageFormatter formatter, ThrottledLogger throttledLogger) {
        super(plugin, configService);
        this.inboundHandler = inboundHandler;
        this.formatter = formatter;
        this.throttledLogger = throttledLogger;
    }

    @Override
    public void send(MessageEnvelope envelope) {
        if (envelope == null) {
            return;
        }
        MessageEnvelope.Format format = envelope.format() == null ? MessageEnvelope.Format.DEFAULT : envelope.format();
        List<String> parts = this.formatter.format(envelope.message(), format);
        if (envelope.targetType() == MessageEnvelope.TargetType.CHANNEL) {
            String channelKey = envelope.channelKey();
            if (channelKey == null || channelKey.isEmpty()) {
                this.sendToDefaultChannel(parts);
            } else {
                this.sendToChannelParts(channelKey, parts);
            }
            return;
        }
        if (envelope.targetType() == MessageEnvelope.TargetType.PRIVATE) {
            this.sendPrivate(String.join((CharSequence)"\n", parts));
            return;
        }
        this.sendToDefaultChannel(parts);
    }

    @Override
    public boolean isEnable() {
        return this.botConfig.getBoolean("enable_discord_bot");
    }

    @Override
    public void setup() {
        if (!this.isEnable()) {
            OrzMC.debugInfo("Discord Bot Disabled!");
            return;
        }
        HealthRegistry.setEnabled("discord", true);
        String minecraftVersion = OrzMC.server().getMinecraftVersion();
        String serverInfo = "Minecraft(" + minecraftVersion + ")";
        String botTokenBase64Encoded = this.botConfig.getString("discord_bot_token_base64_encoded");
        String botToken = new String(Base64.getDecoder().decode(botTokenBase64Encoded));
        try {
            Thread.setDefaultUncaughtExceptionHandler((t, e) -> {
                HealthRegistry.setLastError("discord", e.toString());
                this.throttledLogger.error("discord-thread", "Discord\u7ebf\u7a0b\u5f02\u5e38: " + String.valueOf(e));
            });
            JDABuilder builder = JDABuilder.createLight(botToken, GatewayIntent.GUILD_MESSAGES, GatewayIntent.MESSAGE_CONTENT, GatewayIntent.GUILD_MEMBERS);
            String proxyType = this.botConfig.getString("discord_proxy_type");
            String proxyHost = this.botConfig.getString("discord_proxy_host");
            int proxyPort = this.botConfig.getInt("discord_proxy_port");
            OkHttpClient.Builder http = new OkHttpClient.Builder().connectTimeout(5L, TimeUnit.SECONDS).readTimeout(10L, TimeUnit.SECONDS).writeTimeout(10L, TimeUnit.SECONDS);
            if (proxyType != null && !"none".equalsIgnoreCase(proxyType) && proxyHost != null && !proxyHost.isEmpty() && proxyPort > 0) {
                Proxy.Type type = "SOCKS".equalsIgnoreCase(proxyType) ? Proxy.Type.SOCKS : Proxy.Type.HTTP;
                http.proxy(new Proxy(type, new InetSocketAddress(proxyHost, proxyPort)));
            }
            try {
                builder.setHttpClient(http.build());
            }
            catch (Throwable type) {
                // empty catch block
            }
            this.api = builder.addEventListeners(new ListenerAdapter(){

                @Override
                public void onReady(@NotNull ReadyEvent event) {
                    try {
                        super.onReady(event);
                        OrzDiscordBot.this.isApiReady = true;
                        HealthRegistry.setApiReady("discord", true);
                        OrzDiscordBot.this.toBeSendMessageWhenApiReady.forEach(message -> OrzDiscordBot.this.sendPublic((String)message));
                        OrzDiscordBot.this.toBeSendMessageWhenApiReady.clear();
                    }
                    catch (Exception e) {
                        HealthRegistry.setLastError("discord", e.toString());
                        OrzDiscordBot.this.throttledLogger.error("discord-onready", "Discord Ready \u4e8b\u4ef6\u5f02\u5e38: " + String.valueOf(e));
                    }
                }

                @Override
                public void onMessageReceived(@NotNull MessageReceivedEvent event) {
                    try {
                        super.onMessageReceived(event);
                        if (event.getAuthor().isBot()) {
                            return;
                        }
                        Member member = event.getMember();
                        if (member == null) {
                            return;
                        }
                        boolean isAdmin = member.hasPermission(Permission.MANAGE_SERVER) || member.hasPermission(Permission.ADMINISTRATOR) || member.hasPermission(Permission.MANAGE_CHANNEL);
                        String content = event.getMessage().getContentRaw();
                        BotInboundDispatcher.dispatch(OrzDiscordBot.this.inboundHandler, content, isAdmin, env -> {
                            MessageChannelUnion channel = event.getChannel();
                            MessageEnvelope.Format format = env.format() == null ? MessageEnvelope.Format.DEFAULT : env.format();
                            OrzDiscordBot.this.formatter.format(env.message(), format).forEach(part -> channel.sendMessage((CharSequence)part).queue());
                        });
                    }
                    catch (Exception e) {
                        HealthRegistry.setLastError("discord", e.toString());
                        OrzDiscordBot.this.throttledLogger.error("discord-onmessage", "Discord \u6d88\u606f\u4e8b\u4ef6\u5f02\u5e38: " + String.valueOf(e));
                    }
                }
            }).setActivity(Activity.playing(serverInfo)).build();
            int graceSeconds = this.botConfig.getInt("discord_connect_grace_seconds");
            boolean autoDisable = this.botConfig.getBoolean("discord_auto_disable_on_connect_error");
            if (autoDisable) {
                int ticks = (graceSeconds <= 0 ? 10 : graceSeconds) * 20;
                this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                    if (!this.isApiReady) {
                        try {
                            this.api.shutdown();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        HealthRegistry.setEnabled("discord", false);
                        this.throttledLogger.warning("discord-disable", "Discord\u4e0d\u53ef\u8fbe\uff0c\u5df2\u81ea\u52a8\u7981\u7528\u673a\u5668\u4eba");
                    }
                }, (long)ticks);
            }
        }
        catch (Exception e2) {
            HealthRegistry.setLastError("discord", e2.toString());
            this.throttledLogger.error("discord-init", "Discord\u521d\u59cb\u5316\u5f02\u5e38: " + String.valueOf(e2));
        }
    }

    @Override
    public void teardown() {
        try {
            this.isApiReady = false;
            if (this.api != null) {
                this.api.shutdown();
                try {
                    this.api.awaitShutdown();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.api = null;
        }
    }

    @Override
    protected void sendPublic(String message) {
        if (!this.isEnable()) {
            return;
        }
        if (!this.isApiReady) {
            this.toBeSendMessageWhenApiReady.add(message);
            return;
        }
        try {
            TextChannel channel;
            String playerTextChannelId = this.botConfig.getString("discord_player_text_channel_id");
            TextChannel textChannel = channel = playerTextChannelId != null ? this.api.getTextChannelById(playerTextChannelId) : null;
            if (channel == null) {
                OrzMC.logger().warning("your discord bot not in this text channel: " + playerTextChannelId);
                return;
            }
            this.formatter.format(message, MessageEnvelope.Format.DEFAULT).forEach(part -> channel.sendMessage((CharSequence)part).queue());
        }
        catch (Exception e) {
            HealthRegistry.setLastError("discord", e.toString());
            this.throttledLogger.error("discord-send", "Discord\u6d88\u606f\u53d1\u9001\u5f02\u5e38: " + String.valueOf(e));
        }
    }

    @Override
    protected void sendPrivate(String message) {
    }

    @Override
    protected void sendChannel(String channelKey, String message) {
        if (!this.isEnable()) {
            return;
        }
        if (!this.isApiReady) {
            this.toBeSendMessageWhenApiReady.add(message);
            return;
        }
        try {
            this.sendToChannelParts(channelKey, this.formatter.format(message, MessageEnvelope.Format.DEFAULT));
        }
        catch (Exception e) {
            HealthRegistry.setLastError("discord", e.toString());
            this.throttledLogger.error("discord-send", "Discord\u6307\u5b9a\u9891\u9053\u53d1\u9001\u5f02\u5e38: " + String.valueOf(e));
        }
    }

    private void sendToDefaultChannel(List<String> parts) {
        TextChannel channel;
        if (!this.isEnable()) {
            return;
        }
        if (!this.isApiReady) {
            this.toBeSendMessageWhenApiReady.add(String.join((CharSequence)"\n", parts));
            return;
        }
        String playerTextChannelId = this.botConfig.getString("discord_player_text_channel_id");
        TextChannel textChannel = channel = playerTextChannelId != null ? this.api.getTextChannelById(playerTextChannelId) : null;
        if (channel == null) {
            OrzMC.logger().warning("your discord bot not in this text channel: " + playerTextChannelId);
            return;
        }
        parts.forEach(part -> channel.sendMessage((CharSequence)part).queue());
    }

    private void sendToChannelParts(String channelKey, List<String> parts) {
        TextChannel channel;
        if (!this.isEnable()) {
            return;
        }
        if (!this.isApiReady) {
            this.toBeSendMessageWhenApiReady.add(String.join((CharSequence)"\n", parts));
            return;
        }
        String id = this.botConfig.getString("channels." + channelKey + ".discord");
        TextChannel textChannel = channel = id != null ? this.api.getTextChannelById(id) : null;
        if (channel == null) {
            this.sendToDefaultChannel(parts);
            return;
        }
        parts.forEach(part -> channel.sendMessage((CharSequence)part).queue());
    }
}

