/*
 * Decompiled with CFR 0.152.
 */
package com.jokerhub.paper.plugin.orzmc.infra.bot;

import com.jokerhub.paper.plugin.orzmc.OrzMC;
import com.jokerhub.paper.plugin.orzmc.infra.bot.BotAdapter;
import com.jokerhub.paper.plugin.orzmc.infra.bot.BotInboundHandler;
import com.jokerhub.paper.plugin.orzmc.infra.bot.BotMessageService;
import com.jokerhub.paper.plugin.orzmc.infra.bot.BotRouter;
import com.jokerhub.paper.plugin.orzmc.infra.bot.DiscordMessageFormatter;
import com.jokerhub.paper.plugin.orzmc.infra.bot.MessageEnvelope;
import com.jokerhub.paper.plugin.orzmc.infra.bot.OrzDiscordBot;
import com.jokerhub.paper.plugin.orzmc.infra.bot.OrzLarkBot;
import com.jokerhub.paper.plugin.orzmc.infra.bot.OrzQQBot;
import com.jokerhub.paper.plugin.orzmc.infra.bot.PlainMessageFormatter;
import com.jokerhub.paper.plugin.orzmc.infra.config.ConfigService;
import com.jokerhub.paper.plugin.orzmc.infra.logging.ThrottledLogger;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bukkit.plugin.Plugin;

class OrzBotManager
implements BotMessageService {
    private final OrzMC plugin;
    private final BotInboundHandler inboundHandler;
    private final ConfigService configService;
    private final ThrottledLogger throttledLogger;
    private List<BotAdapter> adapters;
    private final BotRouter router;
    private final AtomicBoolean setupRequested = new AtomicBoolean(false);
    private final AtomicBoolean started = new AtomicBoolean(false);

    public OrzBotManager(OrzMC plugin, ConfigService configService, ThrottledLogger throttledLogger, BotInboundHandler inboundHandler) {
        this.plugin = plugin;
        this.configService = configService;
        this.throttledLogger = throttledLogger;
        this.inboundHandler = inboundHandler;
        this.adapters = Collections.emptyList();
        this.router = new BotRouter(throttledLogger);
    }

    @Override
    public void setup() {
        this.setupRequested.set(true);
        this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try {
                this.startIfRequested();
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("OrzBotManager \u521d\u59cb\u5316\u5931\u8d25: " + e.getMessage());
            }
        });
    }

    void startIfRequested() {
        if (!this.setupRequested.get()) {
            return;
        }
        if (!this.started.compareAndSet(false, true)) {
            return;
        }
        this.adapters = List.of(new OrzQQBot(this.plugin, this.configService, this.inboundHandler, new PlainMessageFormatter(), this.throttledLogger), new OrzDiscordBot(this.plugin, this.configService, this.inboundHandler, new DiscordMessageFormatter(), this.throttledLogger), new OrzLarkBot(this.plugin, this.configService, new PlainMessageFormatter(), this.throttledLogger));
        this.router.setAdapters(this.adapters);
        this.router.setup();
    }

    @Override
    public void send(MessageEnvelope envelope) {
        if (envelope == null) {
            return;
        }
        OrzMC.debugInfo(envelope.message());
        this.router.route(envelope);
    }

    @Override
    public void tearDown() {
        this.router.teardown();
        this.adapters = Collections.emptyList();
    }
}

