/*
 * Decompiled with CFR 0.152.
 */
package com.jokerhub.paper.plugin.orzmc.infra.bot;

import com.jokerhub.paper.plugin.orzmc.OrzMC;
import com.jokerhub.paper.plugin.orzmc.infra.bot.BotAdapter;
import com.jokerhub.paper.plugin.orzmc.infra.bot.MessageEnvelope;
import com.jokerhub.paper.plugin.orzmc.infra.config.ConfigService;
import org.bukkit.configuration.file.FileConfiguration;

public abstract class OrzBaseBot
implements BotAdapter {
    protected final OrzMC plugin;
    protected final FileConfiguration botConfig;

    @Override
    public abstract boolean isEnable();

    @Override
    public abstract void setup();

    @Override
    public abstract void teardown();

    protected OrzBaseBot(OrzMC plugin, ConfigService configService) {
        this.plugin = plugin;
        this.botConfig = configService.getConfig("bot");
    }

    @Override
    public void send(MessageEnvelope envelope) {
        if (envelope == null) {
            return;
        }
        if (envelope.targetType() == MessageEnvelope.TargetType.CHANNEL) {
            if (envelope.channelKey() != null && !envelope.channelKey().isEmpty()) {
                this.sendChannel(envelope.channelKey(), envelope.message());
            } else {
                this.sendPublic(envelope.message());
            }
            return;
        }
        if (envelope.targetType() == MessageEnvelope.TargetType.PRIVATE) {
            this.sendPrivate(envelope.message());
            return;
        }
        this.sendPublic(envelope.message());
    }

    protected abstract void sendPublic(String var1);

    protected abstract void sendPrivate(String var1);

    protected abstract void sendChannel(String var1, String var2);
}

