/*
 * Decompiled with CFR 0.152.
 */
package com.jokerhub.paper.plugin.orzmc.infra.bot;

import com.jokerhub.paper.plugin.orzmc.infra.bot.BotAdapter;
import com.jokerhub.paper.plugin.orzmc.infra.bot.MessageEnvelope;
import com.jokerhub.paper.plugin.orzmc.infra.logging.ThrottledLogger;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;

public class BotRouter {
    private final ThrottledLogger throttledLogger;
    private List<BotAdapter> adapters = Collections.emptyList();
    private final ConcurrentLinkedQueue<MessageEnvelope> pending = new ConcurrentLinkedQueue();
    private volatile boolean initialized = false;

    public BotRouter(ThrottledLogger throttledLogger) {
        this.throttledLogger = throttledLogger;
    }

    public void setAdapters(List<BotAdapter> adapters) {
        this.adapters = adapters == null ? Collections.emptyList() : adapters;
    }

    public void setup() {
        this.adapters.forEach(BotAdapter::setup);
        this.initialized = true;
        this.flushPending();
    }

    public void teardown() {
        this.initialized = false;
        this.adapters.forEach(BotAdapter::teardown);
        this.adapters = Collections.emptyList();
        this.pending.clear();
    }

    public void route(MessageEnvelope envelope) {
        if (!this.initialized) {
            this.throttledLogger.info("bots-init", "\u673a\u5668\u4eba\u5c1a\u672a\u5c31\u7eea\uff0c\u6d88\u606f\u5df2\u7f13\u5b58");
            this.pending.add(envelope);
            return;
        }
        for (BotAdapter adapter : this.adapters) {
            try {
                adapter.send(envelope);
            }
            catch (Exception e) {
                this.throttledLogger.warning("bot-send", "\u6d88\u606f\u53d1\u9001\u5931\u8d25: " + adapter.getClass().getSimpleName() + " - " + String.valueOf(e));
            }
        }
    }

    private void flushPending() {
        MessageEnvelope env;
        while ((env = this.pending.poll()) != null) {
            this.route(env);
        }
    }
}

