/*
 * Decompiled with CFR 0.152.
 */
package com.jokerhub.paper.plugin.orzmc.features.whitelist;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.OfflinePlayer;
import org.bukkit.Server;
import org.bukkit.entity.Player;

public interface WhitelistService {
    public List<String> buildWhitelistLines(Server var1);

    public Set<String> cleanupInactivePlayers(Server var1, int var2);

    public String addPlayers(Server var1, Set<String> var2);

    public String removePlayers(Server var1, Set<String> var2);

    public static WhitelistService defaultImpl() {
        return new DefaultWhitelistService();
    }

    public static final class DefaultWhitelistService
    implements WhitelistService {
        @Override
        public List<String> buildWhitelistLines(Server server) {
            ArrayList whiteListPlayers = new ArrayList(server.getWhitelistedPlayers());
            whiteListPlayers.sort((o1, o2) -> Long.compare(o2.getLastSeen(), o1.getLastSeen()));
            ArrayList<String> lines = new ArrayList<String>();
            for (OfflinePlayer player : whiteListPlayers) {
                String playerName = player.getName();
                String isOnline = player.isOnline() ? "\u2022" : "\u25e6";
                StringBuilder line = new StringBuilder().append(isOnline).append(" ").append(playerName);
                long lastSeenTimestamp = player.getLastSeen();
                if (lastSeenTimestamp > 0L) {
                    String lastSeen = new SimpleDateFormat("yyyy/MM/dd HH:mm").format(new Date(lastSeenTimestamp));
                    line.append(" ").append(lastSeen);
                }
                lines.add(line.toString());
            }
            return lines;
        }

        @Override
        public Set<String> cleanupInactivePlayers(Server server, int inactiveDays) {
            ArrayList whiteListPlayers = new ArrayList(server.getWhitelistedPlayers());
            long now = System.currentTimeMillis();
            long threshold = now - (long)inactiveDays * 24L * 60L * 60L * 1000L;
            Set toRemove = whiteListPlayers.stream().filter(p -> {
                long lastSeen = p.getLastSeen();
                return lastSeen <= 0L || lastSeen < threshold;
            }).collect(Collectors.toSet());
            for (OfflinePlayer p2 : toRemove) {
                if (!p2.isWhitelisted()) continue;
                p2.setWhitelisted(false);
                Player onlinePlayer = server.getPlayer(p2.getUniqueId());
                if (onlinePlayer == null) continue;
                onlinePlayer.kick();
            }
            server.reloadWhitelist();
            return toRemove.stream().map(p -> p.getName() == null ? "(unknown)" : p.getName()).collect(Collectors.toSet());
        }

        @Override
        public String addPlayers(Server server, Set<String> userNames) {
            for (String userName : userNames) {
                OfflinePlayer player = server.getOfflinePlayer(userName);
                if (player.isWhitelisted()) continue;
                player.setWhitelisted(true);
            }
            server.reloadWhitelist();
            Set allWhiteListName = server.getWhitelistedPlayers().stream().map(OfflinePlayer::getName).collect(Collectors.toSet());
            Object message = "------\u767d\u540d\u5355\u6dfb\u52a0------\n";
            if (allWhiteListName.containsAll(userNames)) {
                message = (String)message + String.join((CharSequence)"\n", userNames.stream().map(name -> "\u2714\ufe0e \ufe0e" + name).collect(Collectors.toSet()));
            }
            HashSet<String> failed = new HashSet<String>(userNames);
            failed.removeAll(allWhiteListName);
            if (!failed.isEmpty()) {
                message = (String)message + String.join((CharSequence)"\n", failed.stream().map(name -> "\u2718 " + name).collect(Collectors.toSet()));
            }
            return message;
        }

        @Override
        public String removePlayers(Server server, Set<String> userNames) {
            for (String userName : userNames) {
                OfflinePlayer player = server.getOfflinePlayer(userName);
                if (!player.isWhitelisted()) continue;
                player.setWhitelisted(false);
                Player onlinePlayer = server.getPlayer(player.getUniqueId());
                if (onlinePlayer == null) continue;
                onlinePlayer.kick();
            }
            server.reloadWhitelist();
            Set allWhiteListName = server.getWhitelistedPlayers().stream().map(OfflinePlayer::getName).collect(Collectors.toSet());
            Object message = "------\u767d\u540d\u5355\u79fb\u9664------\n";
            HashSet<String> removed = new HashSet<String>(userNames);
            removed.removeAll(allWhiteListName);
            if (!removed.isEmpty()) {
                message = (String)message + String.join((CharSequence)"\n", removed.stream().map(name -> "\u2714\ufe0e " + name).collect(Collectors.toSet()));
            }
            HashSet<String> notRemoved = new HashSet<String>(userNames);
            notRemoved.retainAll(allWhiteListName);
            if (!notRemoved.isEmpty()) {
                message = (String)message + String.join((CharSequence)"\n", notRemoved.stream().map(name -> "\u2718 " + name).collect(Collectors.toSet()));
            }
            return message;
        }
    }
}

