/*
 * Decompiled with CFR 0.152.
 */
package com.jokerhub.paper.plugin.orzmc.features.whitelist;

import com.destroystokyo.paper.event.profile.ProfileWhitelistVerifyEvent;
import com.destroystokyo.paper.event.server.WhitelistToggleEvent;
import com.destroystokyo.paper.profile.PlayerProfile;
import com.jokerhub.paper.plugin.orzmc.infra.bot.MessageEnvelope;
import com.jokerhub.paper.plugin.orzmc.infra.config.ConfigService;
import com.jokerhub.paper.plugin.orzmc.infra.config.TypedConfigs;
import com.jokerhub.paper.plugin.orzmc.infra.notify.Notifier;
import com.jokerhub.paper.plugin.orzmc.infra.styles.OrzTextStyles;
import com.jokerhub.paper.plugin.orzmc.infra.templates.TemplateService;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;

public final class WhitelistEventService {
    private final ConfigService configService;
    private final OrzTextStyles styles;
    private final Notifier notifier;

    public WhitelistEventService(ConfigService configService, OrzTextStyles styles, Notifier notifier) {
        this.configService = configService;
        this.styles = styles;
        this.notifier = notifier;
    }

    public void handleVerify(ProfileWhitelistVerifyEvent event) {
        TextComponent whitelistKickMessage;
        String discordServerLink;
        PlayerProfile player = event.getPlayerProfile();
        if (player.getName() == null) {
            return;
        }
        if (event.isWhitelisted()) {
            return;
        }
        TextComponent.Builder kickMsgBuilder = Component.text();
        FileConfiguration botConfig = this.configService.getConfig("bot");
        String qqPlayerGroupId = botConfig.getString("qq_player_group_id", botConfig.getString("qq_group_id"));
        if (qqPlayerGroupId != null && !qqPlayerGroupId.isEmpty()) {
            if (!((TextComponent)kickMsgBuilder.build()).equals(Component.empty())) {
                ((TextComponent.Builder)kickMsgBuilder.append((Component)Component.newline())).append((Component)Component.newline());
            }
            ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)kickMsgBuilder.append(this.styles.playerName(player.getName()).decorate(TextDecoration.BOLD))).append((Component)Component.space())).append((Component)this.styles.warn("\u4e0d\u5728\u670d\u52a1\u5668\u767d\u540d\u5355\u4e2d\uff0c\u8bf7\u5148\u52a0\u5165QQ\u7fa4:"))).append((Component)Component.space())).append(this.styles.success(qqPlayerGroupId).decorate(TextDecoration.BOLD))).append((Component)Component.space())).append((Component)this.styles.warn("\uff0c\u8054\u7cfb\u7ba1\u7406\u5458\u6dfb\u52a0\u767d\u540d\u5355"));
        }
        if ((discordServerLink = botConfig.getString("discord_server_link")) != null && !discordServerLink.isEmpty()) {
            if (!((TextComponent)kickMsgBuilder.build()).equals(Component.empty())) {
                ((TextComponent.Builder)kickMsgBuilder.append((Component)Component.newline())).append((Component)Component.newline());
            }
            ((TextComponent.Builder)kickMsgBuilder.append((Component)this.styles.info("you can also join the discord server: "))).append(((TextComponent)((TextComponent)Component.text((String)discordServerLink).color((TextColor)NamedTextColor.BLUE)).decorate(TextDecoration.UNDERLINED)).clickEvent(ClickEvent.openUrl((String)discordServerLink)));
        }
        if (!(whitelistKickMessage = this.buildKickMessage(this.configService.getConfig("whitelist"))).equals(Component.empty())) {
            if (!((TextComponent)kickMsgBuilder.build()).equals(Component.empty())) {
                ((TextComponent.Builder)kickMsgBuilder.append((Component)Component.newline())).append((Component)Component.newline());
            }
            kickMsgBuilder.append((Component)whitelistKickMessage);
        }
        if (!((TextComponent)kickMsgBuilder.build()).equals(Component.empty())) {
            event.kickMessage((Component)kickMsgBuilder.build());
        }
        String playChatGroupMsg = player.getName() + " \u5c1d\u8bd5\u52a0\u5165\u670d\u52a1\u5668\uff0c\u88ab\u767d\u540d\u5355\u62e6\u622a";
        FileConfiguration templatesCfg = this.configService.getConfig("templates");
        TypedConfigs.Templates tpls = TypedConfigs.Templates.from(templatesCfg);
        MessageEnvelope env = TemplateService.renderEvent("whitelist_block", templatesCfg, tpls, Map.of("message", playChatGroupMsg));
        this.notifier.event("whitelist_block", env);
    }

    public void handleToggle(WhitelistToggleEvent event) {
        if (this.isEnableForceWhitelist() && !event.isEnabled()) {
            String msg = "\u203c\ufe0f\u670d\u52a1\u5668\u767d\u540d\u5355\u5f02\u5e38\u5173\u95ed";
            FileConfiguration templatesCfg = this.configService.getConfig("templates");
            TypedConfigs.Templates tpls = TypedConfigs.Templates.from(templatesCfg);
            MessageEnvelope env = TemplateService.renderEvent("whitelist_toggle_alert", templatesCfg, tpls, Map.of("message", msg));
            this.notifier.event("whitelist_toggle_alert", env);
        }
    }

    private boolean isEnableForceWhitelist() {
        try {
            return this.configService.getConfig("whitelist").getBoolean("force_whitelist");
        }
        catch (Exception e) {
            return true;
        }
    }

    private TextComponent buildKickMessage(FileConfiguration whitelistConfig) {
        if (whitelistConfig == null) {
            return Component.empty();
        }
        ConfigurationSection section = whitelistConfig.getConfigurationSection("kick_message");
        if (section == null) {
            return Component.empty();
        }
        String title = section.getString("title", "");
        List ups = section.getMapList("ups");
        TextComponent.Builder builder = Component.text();
        boolean hasContent = false;
        if (!title.isEmpty()) {
            builder.append(Component.text((String)title).decorate(TextDecoration.BOLD));
            hasContent = true;
        }
        if (!ups.isEmpty()) {
            int limit = Math.min(5, ups.size());
            for (Map raw : ups.subList(0, limit)) {
                String platform;
                if (raw == null) continue;
                String name = raw.get("name") == null ? "" : String.valueOf(raw.get("name"));
                String string = platform = raw.get("platform") == null ? "" : String.valueOf(raw.get("platform"));
                if (name.isEmpty() && platform.isEmpty()) continue;
                if (hasContent) {
                    builder.append((Component)Component.newline());
                }
                if (!name.isEmpty()) {
                    TextComponent platformComponent = Component.empty();
                    if (!platform.isEmpty()) {
                        platformComponent = (TextComponent)Component.text((String)platform).append(Component.text((String)":").append((Component)Component.space()));
                    }
                    ((TextComponent.Builder)((TextComponent.Builder)builder.append((Component)Component.newline())).append((Component)platformComponent)).append(((TextComponent)Component.text((String)name).decorate(TextDecoration.BOLD)).color(this.styles.colorPlayer()));
                }
                hasContent = true;
            }
        }
        return hasContent ? (TextComponent)builder.build() : Component.empty();
    }
}

