/*
 * Decompiled with CFR 0.152.
 */
package com.jokerhub.paper.plugin.orzmc.features.tnt;

import com.jokerhub.paper.plugin.orzmc.infra.config.TypedConfigs;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bukkit.Location;

public class TntPolicy {
    private final boolean enableTnt;
    private final boolean enableRespawnAnchor;
    private final int placeCooldownSeconds;
    private final long notifyThrottleMs;
    private final List<Region> whitelistRegions = new ArrayList<Region>();
    private final List<String> exemptEntities;

    public TntPolicy(TypedConfigs.TntConfig cfg) {
        this.enableTnt = cfg.enable();
        this.enableRespawnAnchor = cfg.enableRespawnAnchor();
        this.placeCooldownSeconds = cfg.placeCooldownSeconds();
        this.notifyThrottleMs = cfg.notifyThrottleMs();
        this.exemptEntities = cfg.exemptEntities();
        for (Map<String, Object> m : cfg.whitelistRegions()) {
            int minX = ((Number)m.getOrDefault("minX", 0)).intValue();
            int maxX = ((Number)m.getOrDefault("maxX", 0)).intValue();
            int minY = ((Number)m.getOrDefault("minY", 0)).intValue();
            int maxY = ((Number)m.getOrDefault("maxY", 0)).intValue();
            int minZ = ((Number)m.getOrDefault("minZ", 0)).intValue();
            int maxZ = ((Number)m.getOrDefault("maxZ", 0)).intValue();
            String world = String.valueOf(m.getOrDefault("world", "world"));
            this.whitelistRegions.add(new Region(Math.min(minX, maxX), Math.max(minX, maxX), Math.min(minY, maxY), Math.max(minY, maxY), Math.min(minZ, maxZ), Math.max(minZ, maxZ), world));
        }
    }

    public boolean isEnableTnt() {
        return this.enableTnt;
    }

    public boolean isEnableRespawnAnchor() {
        return this.enableRespawnAnchor;
    }

    public int getPlaceCooldownSeconds() {
        return this.placeCooldownSeconds;
    }

    public long getNotifyThrottleMs() {
        return this.notifyThrottleMs;
    }

    public List<String> getExemptEntities() {
        return this.exemptEntities;
    }

    public boolean isNotInWhiteList(Location loc) {
        for (Region r : this.whitelistRegions) {
            if (!r.contains(loc)) continue;
            return false;
        }
        return true;
    }

    public boolean isNotInWhiteList(String worldName, double x, double y, double z) {
        for (Region r : this.whitelistRegions) {
            if (!r.contains(worldName, x, y, z)) continue;
            return false;
        }
        return true;
    }

    public record Region(int minX, int maxX, int minY, int maxY, int minZ, int maxZ, String world) {
        public boolean contains(Location loc) {
            return loc.getWorld().getName().equals(this.world) && loc.getX() >= (double)this.minX && loc.getX() <= (double)this.maxX && loc.getY() >= (double)this.minY && loc.getY() <= (double)this.maxY && loc.getZ() >= (double)this.minZ && loc.getZ() <= (double)this.maxZ;
        }

        public boolean contains(String worldName, double x, double y, double z) {
            return this.world.equals(worldName) && x >= (double)this.minX && x <= (double)this.maxX && y >= (double)this.minY && y <= (double)this.maxY && z >= (double)this.minZ && z <= (double)this.maxZ;
        }
    }
}

