/*
 * Decompiled with CFR 0.152.
 */
package com.jokerhub.paper.plugin.orzmc.features.tnt;

import com.jokerhub.paper.plugin.orzmc.features.tnt.TntPolicy;
import com.jokerhub.paper.plugin.orzmc.infra.bot.MessageEnvelope;
import com.jokerhub.paper.plugin.orzmc.infra.config.ConfigService;
import com.jokerhub.paper.plugin.orzmc.infra.config.TypedConfigs;
import com.jokerhub.paper.plugin.orzmc.infra.notify.Notifier;
import com.jokerhub.paper.plugin.orzmc.infra.notify.ThrottledNotifier;
import com.jokerhub.paper.plugin.orzmc.infra.player.PlayerDisplayNames;
import com.jokerhub.paper.plugin.orzmc.infra.styles.OrzTextStyles;
import com.jokerhub.paper.plugin.orzmc.infra.templates.TemplateResolvers;
import com.jokerhub.paper.plugin.orzmc.infra.templates.TemplateService;
import io.papermc.paper.event.block.BlockPreDispenseEvent;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.TNTPrimeEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TntEventService {
    private final ConfigService configService;
    private final TntPolicy policy;
    private final Map<UUID, Long> playerCooldowns = new ConcurrentHashMap<UUID, Long>();
    private final EnumSet<EntityType> explosionExemptTypes = EnumSet.noneOf(EntityType.class);
    private final OrzTextStyles styles;
    private final Notifier notifier;
    private final ThrottledNotifier throttledNotifier;

    public TntEventService(ConfigService configService, OrzTextStyles styles, Notifier notifier, ThrottledNotifier throttledNotifier) {
        this.configService = configService;
        this.styles = styles;
        this.notifier = notifier;
        this.throttledNotifier = throttledNotifier;
        FileConfiguration tntConfig = configService.getConfig("tnt");
        TypedConfigs.TntConfig typed = TypedConfigs.TntConfig.from(tntConfig);
        this.policy = new TntPolicy(typed);
        this.initExplosionExemptTypes(tntConfig);
    }

    public void onTNTPrime(@NotNull TNTPrimeEvent event) {
        Block placedBlock = event.getBlock();
        if (!this.policy.isEnableTnt() && this.policy.isNotInWhiteList(placedBlock.getLocation())) {
            event.setCancelled(true);
            this.notifyTNTEvent(placedBlock, "TNT\u88ab\u70b9\u71c3\uff08\u5df2\u7981\u6b62\uff09");
            return;
        }
        this.notifyTNTEvent(placedBlock, "TNT\u88ab\u70b9\u71c3");
    }

    public void onPlaceBlock(@NotNull BlockPlaceEvent event) {
        Block placedBlock = event.getBlockPlaced();
        Material placedBlockType = placedBlock.getType();
        Player player = event.getPlayer();
        if (placedBlockType == Material.TNT) {
            this.handleTNTPlace(event, player, placedBlock);
            return;
        }
        if (placedBlockType == Material.RESPAWN_ANCHOR && !this.policy.isEnableRespawnAnchor()) {
            event.setCancelled(true);
            player.sendMessage(Component.text((String)"\u91cd\u751f\u951a\u653e\u7f6e\u5df2\u88ab\u7ba1\u7406\u5458\u7981\u7528").color(TextColor.color((int)0xFF5555)));
        }
    }

    public void onBlockPreDispense(@NotNull BlockPreDispenseEvent event) {
        ItemStack itemStack = event.getItemStack();
        Material itemType = itemStack.getType();
        if (itemType != Material.TNT && itemType != Material.TNT_MINECART) {
            return;
        }
        Block dispenser = event.getBlock();
        if (!this.policy.isEnableTnt() && this.policy.isNotInWhiteList(dispenser.getLocation())) {
            event.setCancelled(true);
            this.notifyTNTEvent(dispenser, "\u53d1\u5c04" + itemType.name() + "\u88ab\u7981\u6b62");
        }
    }

    public void onBlockExplode(@NotNull BlockExplodeEvent event) {
        Block block = event.getBlock();
        Material material = block.getType();
        if (material.isAir()) {
            return;
        }
        Location loc = block.getLocation();
        String key = this.explosionKey(loc, material.name() + "\u7206\u70b8");
        this.throttledNotifier.runDefault(key, () -> this.notifyExplosionEvent(loc, material.name() + "\u7206\u70b8"));
    }

    public void onEntityExplode(@NotNull EntityExplodeEvent event) {
        EntityType entityType = event.getEntityType();
        if (this.explosionExemptTypes.contains(entityType)) {
            return;
        }
        Location loc = event.getLocation();
        String key = this.explosionKey(loc, entityType.name() + "\u7206\u70b8");
        this.throttledNotifier.runDefault(key, () -> this.notifyExplosionEvent(loc, entityType.name() + "\u7206\u70b8"));
    }

    private void handleTNTPlace(BlockPlaceEvent event, Player player, Block placedBlock) {
        int tntPlaceCooldown = this.policy.getPlaceCooldownSeconds();
        if (tntPlaceCooldown > 0 && this.checkCooldown(player, tntPlaceCooldown)) {
            event.setCancelled(true);
            long remaining = (this.playerCooldowns.get(player.getUniqueId()) + (long)tntPlaceCooldown * 1000L - System.currentTimeMillis()) / 1000L;
            player.sendMessage((Component)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"\u653e\u7f6eTNT\u51b7\u5374\u4e2d\uff0c\u8bf7\u7b49\u5f85 "))).append(Component.text((String)(remaining + "\u79d2")).color(TextColor.color((int)0xFFAA00)))).build());
            return;
        }
        if (!this.policy.isEnableTnt() && this.policy.isNotInWhiteList(placedBlock.getLocation())) {
            event.setCancelled(true);
            player.sendMessage(Component.text((String)"TNT\u653e\u7f6e\u5df2\u88ab\u7ba1\u7406\u5458\u7981\u7528").color(TextColor.color((int)0xFF5555)));
            return;
        }
        if (tntPlaceCooldown > 0) {
            this.playerCooldowns.put(player.getUniqueId(), System.currentTimeMillis());
        }
        this.sendPlacementNotification(player, placedBlock);
    }

    private boolean checkCooldown(@NotNull Player player, int tntPlaceCooldown) {
        if (!this.playerCooldowns.containsKey(player.getUniqueId())) {
            return false;
        }
        long lastPlaceTime = this.playerCooldowns.get(player.getUniqueId());
        return System.currentTimeMillis() - lastPlaceTime < (long)tntPlaceCooldown * 1000L;
    }

    private void notifyTNTEvent(Block block, String message) {
        HashMap<String, String> vars = new HashMap<String, String>();
        Location loc = block.getLocation();
        String world = loc.getWorld() != null ? loc.getWorld().getName() : "unknown";
        TypedConfigs.TemplateOptions opt = TypedConfigs.TemplateOptions.from(this.configService.getConfig("templates"));
        String worldAlias = TemplateResolvers.worldAlias(world, loc.getWorld() != null ? loc.getWorld().getEnvironment().name() : "", opt);
        double scale = opt.coordScale() <= 0.0 ? 1.0 : opt.coordScale();
        int precision = this.configService.getConfig("templates").getInt("templates.coord.precision", 2);
        if (precision < 0) {
            precision = 2;
        }
        String fmt = "%." + precision + "f";
        String xUnit = String.format(fmt, (double)loc.getBlockX() * scale);
        String yUnit = String.format(fmt, (double)loc.getBlockY() * scale);
        String zUnit = String.format(fmt, (double)loc.getBlockZ() * scale);
        vars.put("world", worldAlias);
        vars.put("x", String.valueOf(loc.getBlockX()));
        vars.put("y", String.valueOf(loc.getBlockY()));
        vars.put("z", String.valueOf(loc.getBlockZ()));
        vars.put("x_unit", xUnit);
        vars.put("y_unit", yUnit);
        vars.put("z_unit", zUnit);
        vars.put("coord_unit", opt.coordUnitLabel());
        vars.put("msg", message);
        vars.put("actor", "");
        vars.put("block_type", block.getType().name());
        FileConfiguration templatesCfg = this.configService.getConfig("templates");
        TypedConfigs.Templates tpls = TypedConfigs.Templates.from(templatesCfg);
        MessageEnvelope envelope = TemplateService.renderEvent("tnt_alert", templatesCfg, tpls, vars);
        TextComponent msg = (TextComponent)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)this.styles.tntPrefix())).append((Component)Component.text((String)envelope.message()))).build();
        this.notifier.server((Component)msg);
        this.notifier.event("tnt_alert", envelope);
    }

    private void notifyExplosionEvent(Location location, String message) {
        HashMap<String, String> vars = new HashMap<String, String>();
        String world = location.getWorld() != null ? location.getWorld().getName() : "unknown";
        TypedConfigs.TemplateOptions opt = TypedConfigs.TemplateOptions.from(this.configService.getConfig("templates"));
        String worldAlias = TemplateResolvers.worldAlias(world, location.getWorld() != null ? location.getWorld().getEnvironment().name() : "", opt);
        double scale = opt.coordScale() <= 0.0 ? 1.0 : opt.coordScale();
        int precision = this.configService.getConfig("templates").getInt("templates.coord.precision", 2);
        if (precision < 0) {
            precision = 2;
        }
        String fmt = "%." + precision + "f";
        String xUnit = String.format(fmt, (double)location.getBlockX() * scale);
        String yUnit = String.format(fmt, (double)location.getBlockY() * scale);
        String zUnit = String.format(fmt, (double)location.getBlockZ() * scale);
        vars.put("world", worldAlias);
        vars.put("x", String.valueOf(location.getBlockX()));
        vars.put("y", String.valueOf(location.getBlockY()));
        vars.put("z", String.valueOf(location.getBlockZ()));
        vars.put("x_unit", xUnit);
        vars.put("y_unit", yUnit);
        vars.put("z_unit", zUnit);
        vars.put("coord_unit", opt.coordUnitLabel());
        vars.put("msg", message);
        vars.put("actor", "");
        vars.put("block_type", "EXPLOSION");
        FileConfiguration templatesCfg = this.configService.getConfig("templates");
        TypedConfigs.Templates tpls = TypedConfigs.Templates.from(templatesCfg);
        MessageEnvelope envelope = TemplateService.renderEvent("tnt_alert", templatesCfg, tpls, vars);
        TextComponent msg = (TextComponent)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)this.styles.explosionPrefix())).append((Component)Component.text((String)envelope.message()))).build();
        this.notifier.server((Component)msg);
        this.notifier.event("tnt_alert", envelope);
    }

    private void sendPlacementNotification(Player player, Block block) {
        TextComponent msg = (TextComponent)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)this.playerInfo(player))).append((Component)Component.space())).append((Component)Component.text((String)"\u5728"))).append((Component)this.locationComponent(block))).append((Component)Component.space())).append((Component)Component.text((String)"\u653e\u7f6e\u4e86 TNT"))).build();
        this.notifier.server((Component)msg);
        HashMap<String, String> vars = new HashMap<String, String>();
        Location loc = block.getLocation();
        String world = loc.getWorld() != null ? loc.getWorld().getName() : "unknown";
        TypedConfigs.TemplateOptions opt = TypedConfigs.TemplateOptions.from(this.configService.getConfig("templates"));
        String worldAlias = TemplateResolvers.worldAlias(world, loc.getWorld() != null ? loc.getWorld().getEnvironment().name() : "", opt);
        double scale = opt.coordScale() <= 0.0 ? 1.0 : opt.coordScale();
        int precision = this.configService.getConfig("templates").getInt("templates.coord.precision", 2);
        if (precision < 0) {
            precision = 2;
        }
        String fmt = "%." + precision + "f";
        String xUnit = String.format(fmt, (double)loc.getBlockX() * scale);
        String yUnit = String.format(fmt, (double)loc.getBlockY() * scale);
        String zUnit = String.format(fmt, (double)loc.getBlockZ() * scale);
        vars.put("world", worldAlias);
        vars.put("x", String.valueOf(loc.getBlockX()));
        vars.put("y", String.valueOf(loc.getBlockY()));
        vars.put("z", String.valueOf(loc.getBlockZ()));
        vars.put("x_unit", xUnit);
        vars.put("y_unit", yUnit);
        vars.put("z_unit", zUnit);
        vars.put("coord_unit", opt.coordUnitLabel());
        vars.put("msg", "\u653e\u7f6eTNT");
        vars.put("actor", PlayerDisplayNames.format(player));
        vars.put("block_type", "TNT");
        FileConfiguration templatesCfg = this.configService.getConfig("templates");
        TypedConfigs.Templates tpls = TypedConfigs.Templates.from(templatesCfg);
        MessageEnvelope envelope = TemplateService.renderEvent("tnt_alert", templatesCfg, tpls, vars);
        this.notifier.event("tnt_alert", envelope);
    }

    @NotNull
    private TextComponent playerInfo(@Nullable Player player) {
        if (player != null) {
            return this.styles.playerName(player.getName());
        }
        return this.styles.unknownLabel();
    }

    @NotNull
    private TextComponent locationComponent(@NotNull Block block) {
        return this.locationComponent(block.getLocation());
    }

    @NotNull
    private TextComponent locationComponent(Location location) {
        String locString = this.locationString(location);
        return this.styles.coordComponent(locString);
    }

    @NotNull
    private String locationString(@NotNull Location location) {
        return this.styles.coordString(location);
    }

    @NotNull
    private String explosionKey(@NotNull Location location, @NotNull String message) {
        int cx = location.getBlockX() >> 4;
        int cz = location.getBlockZ() >> 4;
        String world = location.getWorld().getName();
        return world + "|" + cx + "|" + cz + "|" + message;
    }

    private void addExemptTypeIfAvailable(String name) {
        try {
            this.explosionExemptTypes.add(EntityType.valueOf((String)name));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void initExplosionExemptTypes(@NotNull FileConfiguration tntConfig) {
        List<String> names = tntConfig.getStringList("exempt_entities");
        if (names.isEmpty()) {
            names = List.of("CREEPER", "FIREBALL", "WIND_CHARGE", "BREEZE_WIND_CHARGE", "ENDER_DRAGON", "END_CRYSTAL", "WITHER", "WITHER_SKULL");
        }
        names.forEach(this::addExemptTypeIfAvailable);
    }
}

