/*
 * Decompiled with CFR 0.152.
 */
package com.jokerhub.paper.plugin.orzmc.features.teleport;

import com.jokerhub.paper.plugin.orzmc.OrzMC;
import com.jokerhub.paper.plugin.orzmc.features.teleport.TeleportBowTexts;
import com.jokerhub.paper.plugin.orzmc.infra.styles.OrzTextStyles;
import java.util.ArrayList;
import java.util.EnumSet;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public final class TeleportBowService {
    public static final String name = "\u4f20\u9001\u5f13";
    private final OrzTextStyles styles;
    private final TeleportBowTexts texts;
    private static final NamespacedKey KEY_TPBOW = new NamespacedKey((Plugin)OrzMC.plugin(), "tpbow");
    private static final EnumSet<Material> DANGEROUS = EnumSet.of(Material.LAVA, new Material[]{Material.WATER, Material.MAGMA_BLOCK, Material.CACTUS, Material.FIRE, Material.SOUL_FIRE, Material.CAMPFIRE, Material.SOUL_CAMPFIRE, Material.POWDER_SNOW});

    public TeleportBowService(OrzTextStyles styles) {
        this.styles = styles;
        this.texts = new TeleportBowTexts(styles);
    }

    public TextComponent prefix() {
        return Component.text((String)name);
    }

    public void giveAndEquip(Player player) {
        ItemStack teleport_bow = new ItemStack(Material.BOW);
        ItemMeta meta = teleport_bow.getItemMeta();
        meta.addEnchant(Enchantment.ARROW_INFINITE, 1, true);
        meta.displayName((Component)Component.text((String)name));
        ArrayList<TextComponent> loreList = new ArrayList<TextComponent>();
        loreList.add(Component.text((String)"\u53ef\u4ee5\u628a\u4f60\u4f20\u9001\u5230\u7bad\u843d\u5730\u7684\u4f4d\u7f6e"));
        meta.lore(loreList);
        NamespacedKey key = new NamespacedKey((Plugin)OrzMC.plugin(), "tpbow");
        meta.getPersistentDataContainer().set(key, PersistentDataType.BYTE, (Object)1);
        teleport_bow.setItemMeta(meta);
        ItemStack prev = player.getInventory().getItemInMainHand();
        if (prev.getType() != Material.AIR) {
            player.getInventory().addItem(new ItemStack[]{prev});
        }
        player.getInventory().setItemInMainHand(teleport_bow);
        ItemStack arrow = new ItemStack(Material.ARROW);
        player.getInventory().addItem(new ItemStack[]{arrow});
        player.sendMessage((Component)this.styles.success("\u4f60\u83b7\u5f97\u4e86\u4f20\u9001\u5f13"));
    }

    public boolean isTPBowArrow(Projectile proj) {
        if (proj instanceof Arrow) {
            Arrow arrow = (Arrow)proj;
            return arrow.getPersistentDataContainer().has(KEY_TPBOW, PersistentDataType.BYTE);
        }
        return false;
    }

    public void markArrow(EntityShootBowEvent event) {
        Entity entity;
        ItemMeta meta;
        ItemMeta itemMeta = meta = event.getBow() != null ? event.getBow().getItemMeta() : null;
        if (meta != null && meta.getPersistentDataContainer().has(KEY_TPBOW, PersistentDataType.BYTE) && (entity = event.getProjectile()) instanceof Arrow) {
            Arrow arrow = (Arrow)entity;
            arrow.getPersistentDataContainer().set(KEY_TPBOW, PersistentDataType.BYTE, (Object)1);
        }
    }

    private boolean withinWorldBounds(Location loc) {
        if (loc == null) {
            return false;
        }
        World w = loc.getWorld();
        if (w == null) {
            return false;
        }
        int y = loc.getBlockY();
        int min = w.getMinHeight();
        int max = w.getMaxHeight();
        return y >= min + 1 && y <= max - 2;
    }

    private Location toBlockCenter(Location loc, Vector dir) {
        World w = loc.getWorld();
        if (w == null) {
            return null;
        }
        int bx = loc.getBlockX();
        int by = loc.getBlockY();
        int bz = loc.getBlockZ();
        float yaw = this.vectorYaw(dir);
        return new Location(w, (double)bx + 0.5, (double)by, (double)bz + 0.5, yaw, 0.0f);
    }

    private boolean isStandable(Location loc) {
        Block foot = loc.getBlock();
        Block head = foot.getRelative(0, 1, 0);
        Block ground = foot.getRelative(0, -1, 0);
        Material ft = foot.getType();
        Material ht = head.getType();
        Material gt = ground.getType();
        if (!ft.isAir() || !ht.isAir()) {
            return false;
        }
        if (DANGEROUS.contains(ft) || DANGEROUS.contains(ht) || DANGEROUS.contains(gt)) {
            return false;
        }
        return gt.isSolid();
    }

    private Location findStandableAtOrAbove(World world, int bx, int by, int bz, Vector facing) {
        for (int dy = 0; dy <= 1; ++dy) {
            Location loc = new Location(world, (double)bx + 0.5, (double)(by + dy), (double)bz + 0.5, this.vectorYaw(facing), 0.0f);
            if (!this.withinWorldBounds(loc) || !this.isStandable(loc)) continue;
            return loc;
        }
        return null;
    }

    private Location findNearestSafe(Location center, Vector facing) {
        Vector facingNorm;
        int bz;
        int by;
        World w = center.getWorld();
        if (w == null) {
            return null;
        }
        int bx = center.getBlockX();
        Location standable = this.findStandableAtOrAbove(w, bx, by = center.getBlockY(), bz = center.getBlockZ(), facingNorm = facing.clone().normalize());
        if (standable != null) {
            return standable;
        }
        ArrayList<Location> candidates = new ArrayList<Location>();
        boolean radius = true;
        for (int r = 1; r == 1; ++r) {
            for (int dx = -r; dx <= r; ++dx) {
                for (int dz = -r; dz <= r; ++dz) {
                    if (dx == 0 && dz == 0) continue;
                    candidates.add(new Location(w, (double)(bx + dx) + 0.5, (double)by, (double)(bz + dz) + 0.5, this.vectorYaw(facingNorm), 0.0f));
                }
            }
        }
        candidates.sort((a, b) -> {
            Vector va = a.clone().subtract(center).toVector();
            Vector vb = b.clone().subtract(center).toVector();
            double da = va.normalize().dot(facingNorm);
            double db = vb.normalize().dot(facingNorm);
            return Double.compare(db, da);
        });
        for (Location cand : candidates) {
            Location found = this.findStandableAtOrAbove(w, cand.getBlockX(), cand.getBlockY(), cand.getBlockZ(), facingNorm);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    private float vectorYaw(Vector v) {
        double yawRad = Math.atan2(-v.getX(), v.getZ());
        return (float)Math.toDegrees(yawRad);
    }

    public void handleArrowHit(Arrow arrow, Player player) {
        World tw;
        if (arrow.isInWater()) {
            player.sendMessage(this.texts.logText("\u7bad\u5c04\u8fdb\u4e86\u6c34\u91cc!").color(this.styles.colorError()));
            return;
        }
        if (arrow.isInLava()) {
            player.sendMessage(this.texts.logText("\u7bad\u5c04\u8fdb\u4e86\u5ca9\u6d46\u91cc!").color(this.styles.colorError()));
            return;
        }
        Location base = arrow.getLocation();
        World pw = player.getWorld();
        if (!pw.equals(tw = base.getWorld())) {
            player.sendMessage(this.texts.logText("\u65e0\u6cd5\u8de8\u4e16\u754c\u4f20\u9001!").color(this.styles.colorError()));
            return;
        }
        Vector dir = arrow.getVelocity();
        Location center = this.toBlockCenter(base, dir);
        if (!this.withinWorldBounds(center)) {
            player.sendMessage(this.texts.logText("\u76ee\u6807\u9ad8\u5ea6\u4e0d\u5408\u6cd5!").color(this.styles.colorError()));
            return;
        }
        Location safe = this.findNearestSafe(center, dir);
        if (safe == null) {
            player.sendMessage(this.texts.logText("\u76ee\u6807\u4f4d\u7f6e\u4e0d\u53ef\u7ad9\u7acb!").color(this.styles.colorError()));
            return;
        }
        player.teleport(safe);
        player.playSound(player.getLocation(), Sound.ENTITY_CAT_PURR, 1.0f, 1.0f);
        player.sendMessage(this.texts.logText("\u4f20\u9001\u5b8c\u6210!").color(this.styles.colorSuccess()));
    }
}

