/*
 * Decompiled with CFR 0.152.
 */
package com.jokerhub.paper.plugin.orzmc.features.teleport;

import com.jokerhub.paper.plugin.orzmc.features.teleport.TeleportBowService;
import com.jokerhub.paper.plugin.orzmc.infra.styles.OrzTextStyles;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.projectiles.ProjectileSource;

public final class TeleportBowEventService {
    private final TeleportBowService service;

    public TeleportBowEventService(OrzTextStyles styles) {
        this.service = new TeleportBowService(styles);
    }

    public void handleProjectileHit(ProjectileHitEvent event) {
        Arrow arrow;
        ProjectileSource projectileSource;
        Projectile projectile = event.getEntity();
        if (projectile instanceof Arrow && (projectileSource = (arrow = (Arrow)projectile).getShooter()) instanceof Player) {
            Player player = (Player)projectileSource;
            if (!this.service.isTPBowArrow((Projectile)arrow)) {
                return;
            }
            this.service.handleArrowHit(arrow, player);
        }
    }

    public void handleShootBow(EntityShootBowEvent event) {
        if (event.getEntity() instanceof Player) {
            this.service.markArrow(event);
        }
    }
}

