/*
 * Decompiled with CFR 0.152.
 */
package com.jokerhub.paper.plugin.orzmc.features.server;

import com.jokerhub.paper.plugin.orzmc.OrzMC;
import com.jokerhub.paper.plugin.orzmc.features.botcommands.OrzUserCmd;
import com.jokerhub.paper.plugin.orzmc.infra.config.ConfigService;
import com.jokerhub.paper.plugin.orzmc.infra.styles.OrzTextStyles;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.event.server.ServerLoadEvent;

public final class ServerFeedbackService {
    private final ConfigService configService;
    private final OrzTextStyles styles;

    public ServerFeedbackService(ConfigService configService, OrzTextStyles styles) {
        this.configService = configService;
        this.styles = styles;
    }

    public String buildServerLoadMessage(ServerLoadEvent event) {
        String onlineMode = OrzMC.server().getOnlineMode() ? "\u6b63\u7248\u670d" : "\u79bb\u7ebf\u670d";
        String minecraftVersion = OrzMC.server().getMinecraftVersion();
        CharSequence[] parts = new String[]{"Minecraft", minecraftVersion, onlineMode};
        StringBuilder stringBuilder = new StringBuilder(String.join((CharSequence)" ", parts)).append("\n");
        stringBuilder.append("------").append("\n");
        switch (event.getType()) {
            case STARTUP: {
                stringBuilder.append("\u542f\u52a8\u5b8c\u6210");
                break;
            }
            case RELOAD: {
                stringBuilder.append("\u91cd\u542f\u5b8c\u6210");
            }
        }
        stringBuilder.append("\n\n");
        stringBuilder.append("\u53d1\u9001 \"").append(OrzUserCmd.SHOW_HELP.getCmdString()).append("\" \u67e5\u770b\u652f\u6301\u7684\u547d\u4ee4\u6d88\u606f");
        return stringBuilder.toString();
    }

    public Component buildMaintenanceMotd() {
        String msg = this.configService.getConfig("maintenance").getString("backup_maintenance_motd", "\u670d\u52a1\u5668\u7ef4\u62a4\u4e2d\uff0c\u7a0d\u540e\u518d\u8bd5");
        String discordLink = this.configService.getConfig("bot").getString("discord_server_link");
        String qqGroupId = this.configService.getConfig("bot").getString("qq_group_id");
        TextComponent.Builder motdBuilder = Component.text();
        motdBuilder.append(this.styles.warn("\u26a0 \u7ef4\u62a4\u4e2d").decorate(TextDecoration.BOLD));
        motdBuilder.append((Component)Component.newline());
        motdBuilder.append((Component)this.styles.info(msg));
        if (qqGroupId != null && !qqGroupId.isEmpty()) {
            motdBuilder.append((Component)Component.newline());
            ((TextComponent.Builder)motdBuilder.append((Component)this.styles.info("QQ\u7fa4: "))).append((Component)this.styles.warn(qqGroupId));
        }
        if (discordLink != null && !discordLink.isEmpty()) {
            motdBuilder.append((Component)Component.newline());
            ((TextComponent.Builder)motdBuilder.append((Component)this.styles.info("Discord: "))).append(((TextComponent)((TextComponent)Component.text((String)discordLink).decorate(TextDecoration.UNDERLINED)).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"\u70b9\u51fb\u52a0\u5165 Discord")))).clickEvent(ClickEvent.openUrl((String)discordLink)));
        }
        return motdBuilder.build();
    }
}

