/*
 * Decompiled with CFR 0.152.
 */
package com.jokerhub.paper.plugin.orzmc.features.security;

import com.jokerhub.paper.plugin.orzmc.infra.config.ConfigService;
import com.jokerhub.paper.plugin.orzmc.infra.config.TypedConfigs;
import com.jokerhub.paper.plugin.orzmc.infra.net.GeoIpClient;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public final class GeoIpAccessService {
    private final GeoIpClient client;
    private final ConfigService configService;

    public GeoIpAccessService(ConfigService configService) {
        this(new GeoIpClient(), configService);
    }

    GeoIpAccessService(GeoIpClient client, ConfigService configService) {
        this.client = client;
        this.configService = configService;
    }

    public CompletableFuture<Decision> decide(String ipAddress) {
        List<String> allow = TypedConfigs.IpWhitelist.from(this.configService.getConfig("ip_whitelist")).allowCountryCode();
        if (allow.isEmpty()) {
            return CompletableFuture.completedFuture(new Decision(true, "", allow, ""));
        }
        return this.client.lookup(ipAddress).handle((res2, ex) -> {
            if (ex != null || res2 == null) {
                return new Decision(true, "", allow, "");
            }
            String cc = res2.countryCode() == null ? "" : res2.countryCode();
            boolean ok = allow.contains(cc);
            return new Decision(ok, cc, allow, res2.rawJson());
        });
    }

    public record Decision(boolean allowed, String countryCode, List<String> allowList, String rawJson) {
    }
}

