/*
 * Decompiled with CFR 0.152.
 */
package com.jokerhub.paper.plugin.orzmc.features.portal;

import com.jokerhub.paper.plugin.orzmc.features.command.CommandFeedbackService;
import com.jokerhub.paper.plugin.orzmc.features.security.CommandPermissionService;
import com.jokerhub.paper.plugin.orzmc.infra.portal.IPortalService;
import com.jokerhub.paper.plugin.orzmc.infra.portal.PortalInfo;
import com.jokerhub.paper.plugin.orzmc.infra.styles.OrzTextStyles;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.entity.Player;

public final class PortalCommandService {
    private final CommandFeedbackService feedbackService = new CommandFeedbackService();
    private final CommandPermissionService permissionService = new CommandPermissionService();
    private final IPortalService portalService;
    private final OrzTextStyles styles;

    public PortalCommandService(IPortalService portalService, OrzTextStyles styles) {
        this.portalService = portalService;
        this.styles = styles;
    }

    public Result handle(Player player, String[] args) {
        CommandPermissionService.PermissionResult pr = this.permissionService.requireAdmin(player);
        if (!pr.allowed()) {
            return new Result.Failure(pr.message());
        }
        if (args == null || args.length < 1) {
            return new Result.Failure(this.styles.info(this.feedbackService.usageTip("\u7528\u6cd5: /portal <host> [port] \u6216 /portal remove <host> [port]").content()));
        }
        if ("remove".equalsIgnoreCase(args[0]) || "rm".equalsIgnoreCase(args[0])) {
            return this.handleRemove(player, args);
        }
        return this.handleCreate(player, args);
    }

    private Result handleRemove(Player player, String[] args) {
        String target;
        int removed;
        if (args.length < 2) {
            return new Result.Failure(this.styles.info(this.feedbackService.usageTip("\u7528\u6cd5: /portal remove <host> [port]").content()));
        }
        String host = args[1];
        int port = 25565;
        if (args.length >= 3) {
            try {
                port = Integer.parseInt(args[2]);
            }
            catch (Exception e) {
                return new Result.Failure(this.styles.warn(this.feedbackService.portNumberRequiredTip().content()));
            }
        }
        if ((removed = this.portalService.removeByTarget(target = host + ":" + port)) <= 0) {
            return new Result.Success(this.styles.warn("\u6ca1\u6709\u5339\u914d\u7684\u4f20\u9001\u95e8: " + target));
        }
        return new Result.Success(this.styles.success("\u5df2\u79fb\u9664 " + removed + " \u4e2a\u4f20\u9001\u95e8 -> " + target));
    }

    private Result handleCreate(Player player, String[] args) {
        String host = args[0];
        int port = 25565;
        if (args.length >= 2) {
            try {
                port = Integer.parseInt(args[1]);
            }
            catch (Exception e) {
                return new Result.Failure(this.styles.warn(this.feedbackService.portNumberRequiredTip().content()));
            }
        }
        PortalInfo info = this.portalService.createPortal(player, host, port);
        String msg = String.format("\u5df2\u521b\u5efa\u4f20\u9001\u95e8 -> %s:%d @ [%s] %d %d %d \u8f74\u5411:%s \u6846\u67b6:4x5", host, port, info.location().getWorld().getName(), info.location().getBlockX(), info.location().getBlockY(), info.location().getBlockZ(), info.axis().name());
        return new Result.Success(this.styles.success(msg));
    }

    public Component requirePlayerTip() {
        return this.feedbackService.playerRequiredTip();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Result {

        public record Failure(TextComponent message) implements Result
        {
        }

        public record Success(TextComponent message) implements Result
        {
        }
    }
}

