/*
 * Decompiled with CFR 0.152.
 */
package com.jokerhub.paper.plugin.orzmc.features.player;

import com.jokerhub.paper.plugin.orzmc.OrzMC;
import com.jokerhub.paper.plugin.orzmc.features.security.GeoIpAccessService;
import com.jokerhub.paper.plugin.orzmc.infra.bot.MessageEnvelope;
import com.jokerhub.paper.plugin.orzmc.infra.config.ConfigService;
import com.jokerhub.paper.plugin.orzmc.infra.config.TypedConfigs;
import com.jokerhub.paper.plugin.orzmc.infra.notify.Notifier;
import com.jokerhub.paper.plugin.orzmc.infra.notify.ThrottledNotifier;
import com.jokerhub.paper.plugin.orzmc.infra.player.PlayerDisplayNames;
import com.jokerhub.paper.plugin.orzmc.infra.styles.OrzTextStyles;
import com.jokerhub.paper.plugin.orzmc.infra.templates.ExceptionFormatter;
import com.jokerhub.paper.plugin.orzmc.infra.templates.TemplateResolvers;
import com.jokerhub.paper.plugin.orzmc.infra.templates.TemplateService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Location;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.permissions.PermissionAttachmentInfo;

public final class PlayerEventService {
    private final ConfigService configService;
    private final OrzTextStyles styles;
    private final Notifier notifier;
    private final ThrottledNotifier throttledNotifier;

    public PlayerEventService(ConfigService configService, OrzTextStyles styles, Notifier notifier, ThrottledNotifier throttledNotifier) {
        this.configService = configService;
        this.styles = styles;
        this.notifier = notifier;
        this.throttledNotifier = throttledNotifier;
    }

    public void handleGeoIpDecision(AsyncPlayerPreLoginEvent event, String playerName, String ipAddress, GeoIpAccessService.Decision decision) {
        if (decision.allowed()) {
            return;
        }
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("name", playerName);
        vars.put("ip", ipAddress);
        vars.put("country_code", decision.countryCode());
        vars.put("allow_list", String.join((CharSequence)",", decision.allowList()));
        vars.put("address_info", decision.rawJson());
        FileConfiguration templatesCfg = this.configService.getConfig("templates");
        TypedConfigs.Templates tpls = TypedConfigs.Templates.from(templatesCfg);
        MessageEnvelope envelope = TemplateService.renderEvent("geoip_block", templatesCfg, tpls, vars);
        this.notifier.event("geoip_block", envelope);
        event.disallow(AsyncPlayerPreLoginEvent.Result.KICK_OTHER, (Component)this.styles.error(playerName + "(" + ipAddress + ")\n" + decision.countryCode() + "\nIP\u4f4d\u7f6e\u4e0d\u5728\u670d\u52a1\u652f\u6301\u533a\u57df" + String.join((CharSequence)",", decision.allowList())));
    }

    public void handleGeoIpException(Throwable e) {
        String msgText = "IP\u5730\u5740\u89e3\u6790\u670d\u52a1\u5f02\u5e38: " + e.toString();
        OrzMC.logger().warning(msgText);
        FileConfiguration templatesCfg = this.configService.getConfig("templates");
        TypedConfigs.Templates tpls = TypedConfigs.Templates.from(templatesCfg);
        MessageEnvelope envelope = TemplateService.renderEvent("exception_alert", templatesCfg, tpls, Map.of("message", msgText, "stack_summary", ExceptionFormatter.summarize(e)));
        this.notifier.event("exception_alert", envelope);
    }

    public void notifyPlayerState(Player player, PlayerState state) {
        Object[] objects;
        String key = "player_event|" + String.valueOf(player.getUniqueId()) + "|" + state.name();
        if (!this.throttledNotifier.shouldRunDefault(key)) {
            return;
        }
        ArrayList<Player> onlinePlayers = new ArrayList<Player>();
        for (Object obj : objects = OrzMC.server().getOnlinePlayers().toArray()) {
            if (!(obj instanceof Player)) continue;
            Player p = (Player)obj;
            onlinePlayers.add(p);
        }
        int onlinePlayerCount = onlinePlayers.size();
        int maxPlayerCount = OrzMC.server().getMaxPlayers();
        String playerName = PlayerDisplayNames.format(player);
        boolean minusCurrent = state == PlayerState.QUIT || state == PlayerState.KICK;
        int displayOnlineCount = onlinePlayerCount - (minusCurrent ? 1 : 0);
        StringBuilder listBuilder = new StringBuilder();
        for (Player p : onlinePlayers) {
            if (minusCurrent && p.getUniqueId().equals(player.getUniqueId())) continue;
            listBuilder.append(PlayerDisplayNames.format(p)).append("\n");
        }
        Location loc = player.getLocation();
        String world = loc.getWorld() != null ? loc.getWorld().getName() : "unknown";
        TypedConfigs.TemplateOptions opt = TypedConfigs.TemplateOptions.from(this.configService.getConfig("templates"));
        String worldAlias = TemplateResolvers.worldAlias(world, loc.getWorld() != null ? loc.getWorld().getEnvironment().name() : "", opt);
        double scale = opt.coordScale() <= 0.0 ? 1.0 : opt.coordScale();
        int precision = Math.max(0, this.configService.getConfig("templates").getInt("templates.coord.precision", 2));
        String fmt = "%." + precision + "f";
        String xUnit = String.format(fmt, (double)loc.getBlockX() * scale);
        String yUnit = String.format(fmt, (double)loc.getBlockY() * scale);
        String zUnit = String.format(fmt, (double)loc.getBlockZ() * scale);
        boolean isAdmin = player.isOp() || player.hasPermission("orzmc.admin");
        String role = isAdmin ? "admin" : "member";
        HashSet<String> permKeys = new HashSet<String>();
        for (PermissionAttachmentInfo info : player.getEffectivePermissions()) {
            String perm;
            if (info == null || !info.getValue() || (perm = info.getPermission()).isEmpty()) continue;
            permKeys.add(perm);
        }
        String groupAlias = TemplateResolvers.roleGroupAliasFromPermissions(permKeys, opt);
        String roleAlias = groupAlias != null ? groupAlias : TemplateResolvers.roleAlias(isAdmin, opt);
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("name", playerName);
        vars.put("world", world);
        vars.put("world_alias", worldAlias);
        vars.put("x", String.valueOf(loc.getBlockX()));
        vars.put("y", String.valueOf(loc.getBlockY()));
        vars.put("z", String.valueOf(loc.getBlockZ()));
        vars.put("x_unit", xUnit);
        vars.put("y_unit", yUnit);
        vars.put("z_unit", zUnit);
        vars.put("coord_unit", opt.coordUnitLabel());
        vars.put("role", role);
        vars.put("role_alias", roleAlias);
        vars.put("online_count", String.valueOf(displayOnlineCount));
        vars.put("max_count", String.valueOf(maxPlayerCount));
        vars.put("online_list", listBuilder.toString().trim());
        FileConfiguration templatesCfg = this.configService.getConfig("templates");
        TypedConfigs.Templates tpls = TypedConfigs.Templates.from(templatesCfg);
        String eventKey = switch (state) {
            default -> throw new IncompatibleClassChangeError();
            case PlayerState.JOIN -> "player_join";
            case PlayerState.QUIT -> "player_quit";
            case PlayerState.KICK -> "player_kick";
        };
        MessageEnvelope envelope = TemplateService.renderEvent(eventKey, templatesCfg, tpls, vars);
        this.notifier.event(eventKey, envelope);
        OrzMC.logger().info(envelope.message());
        if (displayOnlineCount == 0) {
            Component motd = OrzMC.server().motd();
            String motdText = PlainTextComponentSerializer.plainText().serialize(motd);
            MessageEnvelope hint = TemplateService.renderEvent("server_maintenance_hint", templatesCfg, tpls, Map.of("motd", motdText));
            this.notifier.event("server_maintenance_hint", hint);
        }
    }

    public static enum PlayerState {
        JOIN,
        QUIT,
        KICK;

    }
}

