/*
 * Decompiled with CFR 0.152.
 */
package com.jokerhub.paper.plugin.orzmc.features.maintenance;

import com.jokerhub.orzmc.world.DefaultMcaIOFactory;
import com.jokerhub.orzmc.world.Optimizer;
import com.jokerhub.orzmc.world.OptimizerConfig;
import com.jokerhub.orzmc.world.ProgressEvent;
import com.jokerhub.orzmc.world.ProgressMode;
import com.jokerhub.orzmc.world.ProgressStage;
import com.jokerhub.orzmc.world.RealFileSystem;
import com.jokerhub.paper.plugin.orzmc.OrzMC;
import com.jokerhub.paper.plugin.orzmc.infra.bot.MessageEnvelope;
import com.jokerhub.paper.plugin.orzmc.infra.config.ConfigService;
import com.jokerhub.paper.plugin.orzmc.infra.config.TypedConfigs;
import com.jokerhub.paper.plugin.orzmc.infra.notify.Notifier;
import com.jokerhub.paper.plugin.orzmc.infra.server.OrzUtil;
import com.jokerhub.paper.plugin.orzmc.infra.styles.OrzTextStyles;
import com.jokerhub.paper.plugin.orzmc.infra.templates.TemplateResolvers;
import com.jokerhub.paper.plugin.orzmc.infra.templates.TemplateService;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import net.kyori.adventure.text.Component;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class WorldMaintenanceService {
    private static volatile boolean running = false;
    private volatile long startMs = 0L;
    private final ConfigService configService;
    private final OrzTextStyles styles;
    private final Notifier notifier;

    public WorldMaintenanceService(ConfigService configService, OrzTextStyles styles, Notifier notifier) {
        this.configService = configService;
        this.styles = styles;
        this.notifier = notifier;
    }

    public static boolean isRunningGlobal() {
        return running;
    }

    public static MaintenanceStage mapProgressStage(ProgressStage stage) {
        if (stage == null) {
            return MaintenanceStage.Running;
        }
        if (stage == ProgressStage.Done) {
            return MaintenanceStage.Done;
        }
        return MaintenanceStage.Running;
    }

    private static String stageDisplayCN(ProgressStage s) {
        if (s == null) {
            return "\u8fdb\u884c\u4e2d";
        }
        String n = s.name();
        if ("Region".equalsIgnoreCase(n)) {
            return "\u533a\u57df";
        }
        if ("Chunk".equalsIgnoreCase(n)) {
            return "\u533a\u5757";
        }
        if ("File".equalsIgnoreCase(n)) {
            return "\u6587\u4ef6";
        }
        if ("Done".equalsIgnoreCase(n)) {
            return "\u5b8c\u6210";
        }
        return "\u8fdb\u884c\u4e2d";
    }

    private Function1<ProgressEvent, Unit> progressHandler(String label, Consumer<String> callback) {
        return progressEvent -> {
            Long current = progressEvent.getCurrent();
            Long total = progressEvent.getTotal();
            if (current == null || total == null || current <= 0L || total <= 0L) {
                return Unit.INSTANCE;
            }
            int percent = (int)Math.ceil((double)current.longValue() * 100.0 / (double)total.longValue());
            MaintenanceStage stage = WorldMaintenanceService.mapProgressStage(progressEvent.getStage());
            TypedConfigs.Templates tpls = TypedConfigs.Templates.from(this.configService.getConfig("templates"));
            HashMap<String, String> vars = new HashMap<String, String>();
            vars.put("label", label);
            vars.put("stage", stage.name());
            vars.put("percent", String.valueOf(percent));
            vars.put("stage_name", progressEvent.getStage().name());
            vars.put("stage_cn", WorldMaintenanceService.stageDisplayCN(progressEvent.getStage()));
            long elapsedMs = Math.max(1L, System.currentTimeMillis() - this.startMs);
            double ratePerSec = (double)current.longValue() * 1000.0 / (double)elapsedMs;
            long etaMs = (long)Math.max(0.0, (double)(total - current) / Math.max(1.0E-6, ratePerSec) * 1000.0);
            TypedConfigs.TemplateOptions opt = TypedConfigs.TemplateOptions.from(this.configService.getConfig("templates"));
            double ratePer = ratePerSec;
            String rateUnit = "/s";
            if ("per_min".equalsIgnoreCase(opt.rateUnit())) {
                ratePer = ratePerSec * 60.0;
                rateUnit = "/min";
            }
            long etaValue = etaMs;
            String etaUnit = "ms";
            if ("sec".equalsIgnoreCase(opt.etaUnit())) {
                etaValue = Math.round((double)etaMs / 1000.0);
                etaUnit = "s";
            } else if ("min".equalsIgnoreCase(opt.etaUnit())) {
                etaValue = Math.round((double)etaMs / 1000.0 / 60.0);
                etaUnit = "min";
            }
            String stageName = progressEvent.getStage().name();
            String stageI18n = TemplateResolvers.stageAlias(stageName, opt);
            vars.put("stage_cn", stageI18n);
            vars.put("stage_i18n", stageI18n);
            vars.put("rate_per", String.format("%.2f", ratePer));
            vars.put("rate_unit", rateUnit);
            vars.put("eta_value", String.valueOf(etaValue));
            vars.put("eta_unit", etaUnit);
            vars.put("current", String.valueOf(current));
            vars.put("total", String.valueOf(total));
            String eventKey = "\u5907\u4efd".equals(label) ? "maintenance_backup_stage" : "maintenance_optimize_stage";
            MessageEnvelope env = TemplateService.renderEvent(eventKey, this.configService.getConfig("templates"), tpls, vars);
            OrzMC.logger().info(env.message());
            if (progressEvent.getStage() == ProgressStage.Done) {
                long durationMs = Math.max(0L, System.currentTimeMillis() - this.startMs);
                String doneKey = "\u5907\u4efd".equals(label) ? "maintenance_backup_done" : "maintenance_optimize_done";
                MessageEnvelope done = TemplateService.renderEvent(doneKey, this.configService.getConfig("templates"), tpls, Map.of("label", label, "duration_ms", String.valueOf(durationMs)));
                callback.accept(done.message());
            }
            return Unit.INSTANCE;
        };
    }

    private Function1<Object, Unit> errorHandler(String label, Consumer<String> callback) {
        return obj -> {
            OrzMC.logger().warning(String.valueOf(obj));
            TypedConfigs.Templates tpls = TypedConfigs.Templates.from(this.configService.getConfig("templates"));
            long durationMs = Math.max(0L, System.currentTimeMillis() - this.startMs);
            String errKey = "\u5907\u4efd".equals(label) ? "maintenance_backup_error" : "maintenance_optimize_error";
            MessageEnvelope err = TemplateService.renderEvent(errKey, this.configService.getConfig("templates"), tpls, Map.of("label", label, "duration_ms", String.valueOf(durationMs)));
            callback.accept(err.message());
            this.notifier.event(errKey, err);
            callback.accept("\u5730\u56fe" + label + "\u5931\u8d25");
            return Unit.INSTANCE;
        };
    }

    private void runOptimizerJob(boolean backupMode, Path input, Path outputOrNull, long tickTimeThreshold, Consumer<String> callback) {
        callback.accept("\u6b63\u5728" + (backupMode ? "\u5907\u4efd" : "\u4f18\u5316") + "\u5730\u56fe\uff0c\u8bf7\u7a0d\u7b49......");
        DefaultMcaIOFactory mcaIOFactory = new DefaultMcaIOFactory();
        RealFileSystem fs = RealFileSystem.INSTANCE;
        OptimizerConfig cfg = backupMode ? new OptimizerConfig(input, outputOrNull, tickTimeThreshold, false, ProgressMode.Region, true, false, true, true, 100L, 1000L, this.errorHandler("\u5907\u4efd", callback), this.progressHandler("\u5907\u4efd", callback), 0, true, null, null, fs, null, null, mcaIOFactory) : new OptimizerConfig(input, null, tickTimeThreshold, false, ProgressMode.Region, false, true, true, true, 100L, 1000L, this.errorHandler("\u4f18\u5316", callback), this.progressHandler("\u4f18\u5316", callback), 0, true, null, null, fs, null, null, mcaIOFactory);
        Optimizer.run(cfg);
    }

    public void runExclusive(String kickText, Runnable asyncWork, Runnable finallyWork) {
        if (running) {
            return;
        }
        OrzMC.server().getScheduler().runTask((Plugin)OrzMC.plugin(), () -> {
            running = true;
            this.startMs = System.currentTimeMillis();
            for (Player p : OrzMC.server().getOnlinePlayers()) {
                p.kick((Component)this.styles.warn(kickText));
            }
            OrzUtil.executeConsoleCmd(() -> {}, "save-off", "save-all flush");
            OrzMC.server().getScheduler().runTaskAsynchronously((Plugin)OrzMC.plugin(), () -> {
                try {
                    asyncWork.run();
                }
                catch (Throwable throwable) {
                    OrzUtil.executeConsoleCmd(() -> {}, "save-on");
                    running = false;
                    if (finallyWork != null) {
                        finallyWork.run();
                    }
                    throw throwable;
                }
                OrzUtil.executeConsoleCmd(() -> {}, "save-on");
                running = false;
                if (finallyWork != null) {
                    finallyWork.run();
                }
            });
        });
    }

    public void backup(long tickTimeThreshold, int retainCount, Consumer<String> callback) {
        this.runExclusive("\u670d\u52a1\u5668\u5730\u56fe\u5907\u4efd\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u5c1d\u8bd5\u767b\u5f55\u3002", () -> {
            File worldContainerDir = OrzMC.server().getWorldContainer();
            File worldBackupDir = new File(OrzMC.plugin().getDataFolder(), "backup");
            if (!worldBackupDir.exists() && !worldBackupDir.mkdirs()) {
                OrzMC.logger().warning("\u521b\u5efa\u5730\u56fe\u5907\u4efd\u76ee\u5f55\u5931\u8d25: " + worldBackupDir.getAbsolutePath());
                callback.accept("\u5730\u56fe\u5907\u4efd\u5931\u8d25");
                return;
            }
            Path input = Path.of(worldContainerDir.getAbsolutePath(), new String[0]);
            callback.accept("\u670d\u52a1\u5668\u5730\u56fe\u76ee\u5f55\uff1a" + String.valueOf(input));
            File worldBackupTempDir = new File(worldBackupDir, "tempDir");
            Path output = Path.of(worldBackupTempDir.getAbsolutePath(), new String[0]);
            callback.accept("\u5730\u56fe\u5907\u4efd\u76ee\u5f55\uff1a" + String.valueOf(worldBackupDir));
            this.runOptimizerJob(true, input, output, tickTimeThreshold, callback);
            WorldMaintenanceService.pruneOldZips(worldBackupDir, retainCount);
        }, null);
    }

    public void optimize(long tickTimeThreshold, Consumer<String> callback) {
        this.runExclusive("\u670d\u52a1\u5668\u5730\u56fe\u4f18\u5316\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u5c1d\u8bd5\u767b\u5f55\u3002", () -> {
            File worldContainerDir = OrzMC.server().getWorldContainer();
            Path input = Path.of(worldContainerDir.getAbsolutePath(), new String[0]);
            this.runOptimizerJob(false, input, null, tickTimeThreshold, callback);
        }, null);
    }

    public void optimizeOnShutdown(long tickTimeThreshold) {
        File worldContainerDir = OrzMC.server().getWorldContainer();
        Path input = Path.of(worldContainerDir.getAbsolutePath(), new String[0]);
        this.runOptimizerJob(false, input, null, tickTimeThreshold, s -> {});
    }

    public static void pruneOldZips(File backupDir, int retain) {
        File[] zips;
        if (retain <= 0) {
            retain = 10;
        }
        if ((zips = backupDir.listFiles(f -> f.isFile() && f.getName().endsWith(".zip"))) == null || zips.length <= retain) {
            return;
        }
        Arrays.sort(zips, (a, b) -> {
            try {
                BasicFileAttributes ab = Files.readAttributes(a.toPath(), BasicFileAttributes.class, new LinkOption[0]);
                BasicFileAttributes bb = Files.readAttributes(b.toPath(), BasicFileAttributes.class, new LinkOption[0]);
                return Long.compare(bb.creationTime().toMillis(), ab.creationTime().toMillis());
            }
            catch (Exception e) {
                return Long.compare(b.lastModified(), a.lastModified());
            }
        });
        for (int i = retain; i < zips.length; ++i) {
            try {
                boolean deleted = zips[i].delete();
                if (deleted) continue;
                OrzMC.logger().warning("\u5220\u9664\u65e7\u5907\u4efd\u5931\u8d25: " + zips[i].getName());
                continue;
            }
            catch (Exception e) {
                OrzMC.logger().severe("\u6e05\u7406\u65e7\u5907\u4efd\u5f02\u5e38: " + String.valueOf(e));
            }
        }
    }

    public static enum MaintenanceStage {
        Start,
        Running,
        Done,
        Error;

    }
}

