/*
 * Decompiled with CFR 0.152.
 */
package com.jokerhub.paper.plugin.orzmc.features.guide;

import com.jokerhub.paper.plugin.orzmc.OrzMC;
import com.jokerhub.paper.plugin.orzmc.infra.config.ConfigService;
import com.jokerhub.paper.plugin.orzmc.infra.guidebook.GuideBookConfigParser;
import com.jokerhub.paper.plugin.orzmc.infra.guidebook.models.ContentItem;
import com.jokerhub.paper.plugin.orzmc.infra.guidebook.models.GuideBookConfig;
import com.jokerhub.paper.plugin.orzmc.infra.guidebook.models.LinkContent;
import com.jokerhub.paper.plugin.orzmc.infra.guidebook.models.TextContent;
import com.jokerhub.paper.plugin.orzmc.infra.guidebook.models.TextStyle;
import com.jokerhub.paper.plugin.orzmc.infra.server.OrzUtil;
import com.jokerhub.paper.plugin.orzmc.infra.styles.OrzTextStyles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;

public final class GuideService {
    private final ConfigService configService;
    private final OrzTextStyles styles;

    public GuideService(ConfigService configService, OrzTextStyles styles) {
        this.configService = configService;
        this.styles = styles;
    }

    public ItemStack buildGuideBook() {
        GuideBookConfigParser parser = new GuideBookConfigParser(OrzMC.plugin(), this.configService);
        GuideBookConfig cfg = parser.parseConfig();
        if (cfg == null || !cfg.enable()) {
            return null;
        }
        ItemStack guideBook = new ItemStack(Material.WRITTEN_BOOK);
        BookMeta bookMeta = (BookMeta)guideBook.getItemMeta();
        bookMeta.setTitle(cfg.title());
        bookMeta.setAuthor(cfg.author());
        bookMeta.setGeneration(BookMeta.Generation.COPY_OF_COPY);
        ArrayList<TextComponent> pages = new ArrayList<TextComponent>();
        TextComponent.Builder pageBuilder = Component.text();
        for (ContentItem item : cfg.content()) {
            TextComponent.Builder t = Component.text();
            if (item.isText()) {
                TextContent textItem = item.getText();
                if (!textItem.content().isEmpty()) {
                    t.append((Component)Component.text((String)textItem.content()));
                }
            } else if (item.isLink()) {
                LinkContent linkItem = item.getLink();
                TextComponent.Builder linkTextBuilder = Component.text();
                if (!linkItem.content().isEmpty()) {
                    linkTextBuilder.append((Component)Component.text((String)linkItem.content()));
                }
                if (!linkItem.url().isEmpty()) {
                    Style defaultLinkStyle = Style.style().color(TextColor.fromCSSHexString((String)"#5555FF")).build();
                    linkTextBuilder.style(defaultLinkStyle);
                    linkTextBuilder.clickEvent(ClickEvent.openUrl((String)linkItem.url()));
                    linkTextBuilder.hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)linkItem.hoverText())));
                }
                t.append((Component)linkTextBuilder.build());
            }
            if (item.getStyle() != null) {
                TextStyle style = item.getStyle();
                if (style.getBold().booleanValue()) {
                    t.decorate(TextDecoration.BOLD);
                }
                if (style.getUnderlined().booleanValue()) {
                    t.decorate(TextDecoration.UNDERLINED);
                }
                if (!style.getColor().isEmpty()) {
                    TextColor textColor = TextColor.fromCSSHexString((String)style.getColor());
                    t.color(textColor);
                }
            }
            Collections.nCopies(item.getNewlineCount(), Component.newline()).forEach(arg_0 -> ((TextComponent.Builder)t).append(arg_0));
            TextComponent textComponent = (TextComponent)t.build();
            pageBuilder.append((Component)textComponent);
            if (!item.getPageBreak()) continue;
            pages.add((TextComponent)pageBuilder.build());
            pageBuilder = Component.text();
        }
        TextComponent last = (TextComponent)pageBuilder.build();
        if (!last.children().isEmpty()) {
            pages.add(last);
        }
        bookMeta.addPages((Component[])pages.toArray(new TextComponent[0]));
        guideBook.setItemMeta((ItemMeta)bookMeta);
        return guideBook;
    }

    public void openGuide(Player player) {
        ItemStack guideBook = this.buildGuideBook();
        if (guideBook == null) {
            player.sendMessage((Component)OrzUtil.failureText(this.styles, "\u670d\u4e3b\u672a\u914d\u7f6e\u65b0\u624b\u6307\u5357"));
            return;
        }
        player.openBook(guideBook);
    }

    public void giveIfFirstJoin(Player player) {
        ItemStack guideBook;
        UUID playerUUID = player.getPlayerProfile().getId();
        if (playerUUID == null) {
            return;
        }
        OfflinePlayer offlinePlayer = OrzMC.server().getOfflinePlayer(playerUUID);
        if (!offlinePlayer.hasPlayedBefore() && (guideBook = this.buildGuideBook()) != null) {
            player.getInventory().addItem(new ItemStack[]{guideBook});
            player.sendMessage((Component)OrzUtil.successText(this.styles, "\u83b7\u5f97\u65b0\u624b\u6307\u5357"));
        }
    }
}

