/*
 * Decompiled with CFR 0.152.
 */
package com.jokerhub.paper.plugin.orzmc.features.botcommands;

import com.jokerhub.paper.plugin.orzmc.infra.config.ConfigService;

public enum OrzUserCmd {
    SHOW_PLAYERS("l", "\u67e5\u770b\u5728\u7ebf\u73a9\u5bb6", false),
    SHOW_WHITELIST("w", "\u67e5\u770b\u767d\u540d\u5355\u73a9\u5bb6", false),
    SHOW_HELP("h", "\u67e5\u770b\u5e2e\u52a9\u4fe1\u606f", false),
    ADD_PLAYER_TO_WHITELIST("a", "\u6dfb\u52a0\u73a9\u5bb6\u5230\u767d\u540d\u5355", true),
    REMOVE_PLAYER_FROM_WHITELIST("r", "\u4ece\u767d\u540d\u5355\u79fb\u9664\u73a9\u5bb6", true),
    BACKUP("b", "\u5730\u56fe\u5907\u4efd", true),
    OPTIMIZE_WORLD("o", "\u4f18\u5316\u5730\u56fe\u5927\u5c0f", true);

    private final String cmdName;
    private final String description;
    private final boolean needAdminPermission;
    private static ConfigService configService;

    private OrzUserCmd(String cmdName, String description, boolean needAdminPermission) {
        this.cmdName = cmdName;
        this.description = description;
        this.needAdminPermission = needAdminPermission;
    }

    public static void setConfigService(ConfigService service) {
        configService = service;
    }

    private static String cmdPromptChar() {
        try {
            if (configService == null) {
                return "$";
            }
            return configService.getConfig("bot").getString("cmd_prompt_char", "$");
        }
        catch (Exception e) {
            return "$";
        }
    }

    public static boolean isValidCmd(String message) {
        return message.startsWith(OrzUserCmd.cmdPromptChar());
    }

    public String getCmdString() {
        return OrzUserCmd.cmdPromptChar() + this.cmdName;
    }

    public String toString() {
        return this.getCmdString() + "\t" + this.description;
    }

    public boolean needAdminPermission() {
        return this.needAdminPermission;
    }
}

