/*
 * Decompiled with CFR 0.152.
 */
package com.jokerhub.paper.plugin.orzmc.features.botcommands;

import com.jokerhub.paper.plugin.orzmc.OrzMC;
import com.jokerhub.paper.plugin.orzmc.features.botcommands.BotCommandFeedbackService;
import com.jokerhub.paper.plugin.orzmc.features.botcommands.BotCommandListFeedbackService;
import com.jokerhub.paper.plugin.orzmc.features.botcommands.OrzUserCmd;
import com.jokerhub.paper.plugin.orzmc.features.maintenance.WorldMaintenanceService;
import com.jokerhub.paper.plugin.orzmc.features.whitelist.WhitelistService;
import com.jokerhub.paper.plugin.orzmc.infra.bot.BotInboundHandler;
import com.jokerhub.paper.plugin.orzmc.infra.bot.MessageEnvelope;
import com.jokerhub.paper.plugin.orzmc.infra.config.ConfigService;
import com.jokerhub.paper.plugin.orzmc.infra.notify.Notifier;
import com.jokerhub.paper.plugin.orzmc.infra.paging.Paginator;
import com.jokerhub.paper.plugin.orzmc.infra.styles.OrzTextStyles;
import com.jokerhub.paper.plugin.orzmc.infra.templates.TemplateRenderer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public final class BotCommandService
implements BotInboundHandler {
    private final BotCommandFeedbackService feedbackService = new BotCommandFeedbackService();
    private final BotCommandListFeedbackService listFeedbackService = new BotCommandListFeedbackService();
    private final ConfigService configService;
    private final OrzTextStyles styles;
    private Notifier notifier;

    public BotCommandService(ConfigService configService, OrzTextStyles styles) {
        this.configService = configService;
        this.styles = styles;
    }

    public void setNotifier(Notifier notifier) {
        this.notifier = notifier;
    }

    @Override
    public void handleMessage(String message, boolean isAdmin, Consumer<MessageEnvelope> callback) {
        this.parse(message, isAdmin, callback);
    }

    public void parse(String message, Boolean isAdmin, Consumer<MessageEnvelope> callback) {
        if (!OrzUserCmd.isValidCmd(message)) {
            return;
        }
        FileConfiguration templatesCfg = this.configService.getConfig("templates");
        ArrayList<String> cmd = new ArrayList<String>(Arrays.asList(message.split("[, ]+")));
        String cmdString = cmd.remove(0);
        HashSet<String> userNameSet = new HashSet<String>(cmd);
        if (cmdString.equals(OrzUserCmd.SHOW_PLAYERS.getCmdString())) {
            this.onlinePlayersInfo(callback, templatesCfg);
        } else if (cmdString.equals(OrzUserCmd.SHOW_WHITELIST.getCmdString())) {
            Integer page = null;
            if (!cmd.isEmpty()) {
                String token = cmd.get(0);
                try {
                    page = Integer.parseInt(token);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.whiteListInfo(callback, templatesCfg, page, isAdmin);
        } else if (cmdString.equals(OrzUserCmd.SHOW_HELP.getCmdString())) {
            String help = this.feedbackService.helpInfo();
            this.emit(callback, templatesCfg, "command_help", Map.of("help", help), help);
        } else if (cmdString.equals(OrzUserCmd.ADD_PLAYER_TO_WHITELIST.getCmdString())) {
            this.addWhiteListInfo(isAdmin, userNameSet, callback, templatesCfg);
        } else if (cmdString.equals(OrzUserCmd.REMOVE_PLAYER_FROM_WHITELIST.getCmdString())) {
            this.removeWhiteListInfo(isAdmin, userNameSet, callback, templatesCfg);
        } else if (cmdString.equals(OrzUserCmd.BACKUP.getCmdString())) {
            this.backupWorld(isAdmin, callback, templatesCfg);
        } else if (cmdString.equals(OrzUserCmd.OPTIMIZE_WORLD.getCmdString())) {
            this.optimizeWorld(isAdmin, callback, templatesCfg);
        } else {
            String help = this.feedbackService.helpInfo();
            this.emit(callback, templatesCfg, "command_help", Map.of("help", help), help);
        }
    }

    private void onlinePlayersInfo(Consumer<MessageEnvelope> callback, FileConfiguration templatesCfg) {
        OrzMC.server().getScheduler().runTaskAsynchronously((Plugin)OrzMC.plugin(), () -> {
            ArrayList<Player> onlinePlayers = this.listFeedbackService.currentOnlinePlayers();
            BotCommandListFeedbackService.OnlineList online = this.listFeedbackService.buildOnlineList(templatesCfg, onlinePlayers, OrzMC.server().getMaxPlayers());
            this.emit(callback, templatesCfg, "command_players", this.listFeedbackService.onlineVars(online), online.fallback());
        });
    }

    private void whiteListInfo(Consumer<MessageEnvelope> callback, FileConfiguration templatesCfg, Integer page, boolean isAdmin) {
        OrzMC.server().getScheduler().runTaskAsynchronously((Plugin)OrzMC.plugin(), () -> {
            FileConfiguration wlCfg = this.configService.getConfig("whitelist");
            WhitelistService svc = WhitelistService.defaultImpl();
            int delayTicks = Math.max(0, wlCfg.getInt("pagination_delay_ticks", 5));
            if (isAdmin) {
                this.renderWhitelistWithCleanup(callback, templatesCfg, page, delayTicks, svc, wlCfg);
            } else {
                this.renderWhitelistPages(callback, templatesCfg, page, delayTicks, svc);
            }
        });
    }

    private void renderWhitelistWithCleanup(Consumer<MessageEnvelope> callback, FileConfiguration templatesCfg, Integer page, int delayTicks, WhitelistService svc, FileConfiguration wlCfg) {
        OrzMC.server().getScheduler().runTask((Plugin)OrzMC.plugin(), () -> {
            Set<String> removed = svc.cleanupInactivePlayers(OrzMC.server(), Math.max(1, wlCfg.getInt("cleanup_inactive_days", 90)));
            OrzMC.server().getScheduler().runTaskAsynchronously((Plugin)OrzMC.plugin(), () -> {
                ArrayList<String> updatedLines = new ArrayList<String>(svc.buildWhitelistLines(OrzMC.server()));
                BotCommandListFeedbackService.WhitelistHeader updatedHeaderInfo = this.listFeedbackService.buildWhitelistHeader(templatesCfg, updatedLines.size());
                if (!removed.isEmpty()) {
                    BotCommandListFeedbackService.CleanupNotice cleanupNotice = this.listFeedbackService.buildCleanupNotice(templatesCfg, removed);
                    this.emitWhitelistCleanup(callback, templatesCfg, cleanupNotice);
                }
                this.emitWhitelistPages(callback, templatesCfg, updatedHeaderInfo.header(), updatedLines, delayTicks, page);
            });
        });
    }

    private void renderWhitelistPages(Consumer<MessageEnvelope> callback, FileConfiguration templatesCfg, Integer page, int delayTicks, WhitelistService svc) {
        ArrayList<String> lines = new ArrayList<String>(svc.buildWhitelistLines(OrzMC.server()));
        BotCommandListFeedbackService.WhitelistHeader headerInfo = this.listFeedbackService.buildWhitelistHeader(templatesCfg, lines.size());
        this.emitWhitelistPages(callback, templatesCfg, headerInfo.header(), lines, delayTicks, page);
    }

    private void addWhiteListInfo(boolean isAdmin, Set<String> userNames, Consumer<MessageEnvelope> callback, FileConfiguration templatesCfg) {
        if (!this.guardWhitelistCommand(OrzUserCmd.ADD_PLAYER_TO_WHITELIST, isAdmin, userNames, callback, templatesCfg)) {
            return;
        }
        OrzMC.server().getScheduler().runTask((Plugin)OrzMC.plugin(), () -> {
            WhitelistService svc = WhitelistService.defaultImpl();
            String message = svc.addPlayers(OrzMC.server(), userNames);
            this.emitWhitelistAddResult(callback, templatesCfg, message);
        });
    }

    private void removeWhiteListInfo(boolean isAdmin, Set<String> userNames, Consumer<MessageEnvelope> callback, FileConfiguration templatesCfg) {
        if (!this.guardWhitelistCommand(OrzUserCmd.REMOVE_PLAYER_FROM_WHITELIST, isAdmin, userNames, callback, templatesCfg)) {
            return;
        }
        OrzMC.server().getScheduler().runTask((Plugin)OrzMC.plugin(), () -> {
            WhitelistService svc = WhitelistService.defaultImpl();
            String message = svc.removePlayers(OrzMC.server(), userNames);
            this.emitWhitelistRemoveResult(callback, templatesCfg, message);
        });
    }

    private void backupWorld(boolean isAdmin, Consumer<MessageEnvelope> callback, FileConfiguration templatesCfg) {
        if (!this.guardAdminCommand(OrzUserCmd.BACKUP, isAdmin, callback, templatesCfg)) {
            return;
        }
        long tickTimeThreshold = this.configService.getConfig("maintenance").getLong("optimize_tick_time_threshold", 300L);
        int retain = this.configService.getConfig("maintenance").getInt("backup_retention_count", 10);
        WorldMaintenanceService svc = new WorldMaintenanceService(this.configService, this.styles, this.notifier);
        svc.backup(tickTimeThreshold, retain, msg -> this.emitBackup(callback, templatesCfg, (String)msg));
    }

    private void optimizeWorld(boolean isAdmin, Consumer<MessageEnvelope> callback, FileConfiguration templatesCfg) {
        if (!this.guardAdminCommand(OrzUserCmd.OPTIMIZE_WORLD, isAdmin, callback, templatesCfg)) {
            return;
        }
        if (!this.guardOptimizeEnabled(callback, templatesCfg)) {
            return;
        }
        long tickTimeThreshold = this.configService.getConfig("maintenance").getLong("optimize_tick_time_threshold", 300L);
        WorldMaintenanceService svc = new WorldMaintenanceService(this.configService, this.styles, this.notifier);
        svc.optimize(tickTimeThreshold, msg -> this.emitOptimize(callback, templatesCfg, (String)msg));
    }

    private void emitWhitelistCleanup(Consumer<MessageEnvelope> callback, FileConfiguration templatesCfg, BotCommandListFeedbackService.CleanupNotice notice) {
        this.emit(callback, templatesCfg, "command_whitelist_cleanup", this.listFeedbackService.cleanupVars(notice), notice.fallback());
    }

    private void emitWhitelistPage(Consumer<MessageEnvelope> callback, FileConfiguration templatesCfg, BotCommandListFeedbackService.WhitelistPage pageInfo) {
        this.emit(callback, templatesCfg, "command_whitelist_page", pageInfo.vars(), pageInfo.fallback());
    }

    private void emitWhitelistAddResult(Consumer<MessageEnvelope> callback, FileConfiguration templatesCfg, String message) {
        this.emit(callback, templatesCfg, "command_whitelist_add_result", Map.of("message", message), message);
    }

    private void emitWhitelistRemoveResult(Consumer<MessageEnvelope> callback, FileConfiguration templatesCfg, String message) {
        this.emit(callback, templatesCfg, "command_whitelist_remove_result", Map.of("message", message), message);
    }

    private void emitBackup(Consumer<MessageEnvelope> callback, FileConfiguration templatesCfg, String message) {
        this.emit(callback, templatesCfg, "command_backup", Map.of("message", message), message);
    }

    private void emitOptimize(Consumer<MessageEnvelope> callback, FileConfiguration templatesCfg, String message) {
        this.emit(callback, templatesCfg, "command_optimize", Map.of("message", message), message);
    }

    private void emitOptimizeDisabled(Consumer<MessageEnvelope> callback, FileConfiguration templatesCfg, String message) {
        this.emit(callback, templatesCfg, "command_optimize_disabled", Map.of("message", message), message);
    }

    private boolean guardOptimizeEnabled(Consumer<MessageEnvelope> callback, FileConfiguration templatesCfg) {
        boolean enabled = false;
        try {
            enabled = this.configService.getConfig("maintenance").getBoolean("optimize_enabled");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!enabled) {
            this.emitOptimizeDisabled(callback, templatesCfg, "\u5730\u56fe\u4f18\u5316\u529f\u80fd\u5df2\u7981\u7528");
            return false;
        }
        return true;
    }

    private boolean guardAdminCommand(OrzUserCmd cmd, boolean isAdmin, Consumer<MessageEnvelope> callback, FileConfiguration templatesCfg) {
        if (isAdmin) {
            return true;
        }
        this.emitAdminRequired(callback, templatesCfg, this.feedbackService.adminRequiredTip(cmd));
        return false;
    }

    private boolean guardWhitelistCommand(OrzUserCmd cmd, boolean isAdmin, Set<String> userNames, Consumer<MessageEnvelope> callback, FileConfiguration templatesCfg) {
        if (!isAdmin) {
            this.emitAdminRequired(callback, templatesCfg, this.feedbackService.adminRequiredTip(cmd));
            return false;
        }
        if (userNames.isEmpty()) {
            this.emitUsage(callback, templatesCfg, this.feedbackService.usageTip(cmd));
            return false;
        }
        return true;
    }

    private void emitWhitelistPages(Consumer<MessageEnvelope> callback, FileConfiguration templatesCfg, String header, ArrayList<String> lines, int delayTicks, Integer page) {
        Paginator.paginatePages((pageIndex, total, headerText, body) -> {
            BotCommandListFeedbackService.WhitelistPage pageInfo = this.listFeedbackService.buildWhitelistPage(templatesCfg, headerText, pageIndex, total, body);
            this.emitWhitelistPage(callback, templatesCfg, pageInfo);
        }, header, lines, delayTicks, page);
    }

    private void emitAdminRequired(Consumer<MessageEnvelope> callback, FileConfiguration templatesCfg, String tip) {
        this.emit(callback, templatesCfg, "command_admin_required", Map.of("message", tip), tip);
    }

    private void emitUsage(Consumer<MessageEnvelope> callback, FileConfiguration templatesCfg, String tip) {
        this.emit(callback, templatesCfg, "command_usage", Map.of("message", tip), tip);
    }

    private void emit(Consumer<MessageEnvelope> callback, FileConfiguration templatesCfg, String templateKey, Map<String, String> vars, String fallback) {
        String template = TemplateRenderer.resolveTemplate(templateKey, templatesCfg, fallback);
        MessageEnvelope env = TemplateRenderer.renderEnvelope(templateKey, template, vars, templatesCfg);
        callback.accept(env);
    }
}

