/*
 * Decompiled with CFR 0.152.
 */
package com.jokerhub.paper.plugin.orzmc.features.botcommands;

import com.jokerhub.paper.plugin.orzmc.OrzMC;
import com.jokerhub.paper.plugin.orzmc.infra.player.PlayerDisplayNames;
import com.jokerhub.paper.plugin.orzmc.infra.templates.TemplateRenderer;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public final class BotCommandListFeedbackService {
    public OnlineList buildOnlineList(FileConfiguration templatesCfg, ArrayList<Player> onlinePlayers, int maxPlayers) {
        String header = String.format("------\u5f53\u524d\u5728\u7ebf(%d/%d)------", onlinePlayers.size(), maxPlayers);
        StringBuilder listBuilder = new StringBuilder();
        for (Player p : onlinePlayers) {
            String name = PlayerDisplayNames.format(p);
            listBuilder.append("\n").append(name);
        }
        String list = listBuilder.toString().trim();
        String fallbackDefault = header + (String)(list.isEmpty() ? "" : "\n" + list);
        OnlineList online = new OnlineList(list, fallbackDefault, header, String.valueOf(onlinePlayers.size()), String.valueOf(maxPlayers));
        String template = TemplateRenderer.resolveTemplate("command_players", templatesCfg, fallbackDefault);
        String fallback = TemplateRenderer.render(template, this.onlineVars(online));
        return new OnlineList(list, fallback, header, online.onlineCount(), online.maxCount());
    }

    public Map<String, String> onlineVars(OnlineList online) {
        return Map.of("online_count", online.onlineCount(), "max_count", online.maxCount(), "online_list", online.list());
    }

    public WhitelistHeader buildWhitelistHeader(FileConfiguration templatesCfg, int total) {
        String headerFallback = String.format("------\u5f53\u524d\u767d\u540d\u5355\u73a9\u5bb6(%d)------", total);
        String headerTemplate = TemplateRenderer.resolveTemplate("command_whitelist_header", templatesCfg, headerFallback);
        String header = TemplateRenderer.render(headerTemplate, this.whitelistHeaderVars(total));
        return new WhitelistHeader(header, header);
    }

    public Map<String, String> whitelistHeaderVars(int total) {
        return Map.of("count", String.valueOf(total));
    }

    public CleanupNotice buildCleanupNotice(FileConfiguration templatesCfg, Set<String> removed) {
        String removedList = String.join((CharSequence)"\n", removed.stream().map(name -> "\u2714\ufe0e " + name).collect(Collectors.toSet()));
        String removedFallbackDefault = "------\u767d\u540d\u5355\u6e05\u7406------\n" + removedList;
        CleanupNotice notice = new CleanupNotice(removedList, removedFallbackDefault);
        String template = TemplateRenderer.resolveTemplate("command_whitelist_cleanup", templatesCfg, removedFallbackDefault);
        String fallback = TemplateRenderer.render(template, this.cleanupVars(notice));
        return new CleanupNotice(removedList, fallback);
    }

    public Map<String, String> cleanupVars(CleanupNotice notice) {
        return Map.of("removed_list", notice.removedList());
    }

    public WhitelistPage buildWhitelistPage(FileConfiguration templatesCfg, String headerText, int pageIndex, int total, String body) {
        Map<String, String> vars = Map.of("header", headerText, "page", String.valueOf(pageIndex), "total", String.valueOf(total), "body", body);
        String fallbackDefault = headerText + "\n\u7b2c" + pageIndex + "/" + total + "\u9875\n" + body;
        String template = TemplateRenderer.resolveTemplate("command_whitelist_page", templatesCfg, fallbackDefault);
        String fallback = TemplateRenderer.render(template, vars);
        return new WhitelistPage(fallback, vars);
    }

    public ArrayList<Player> currentOnlinePlayers() {
        Object[] objects;
        ArrayList<Player> onlinePlayers = new ArrayList<Player>();
        for (Object obj : objects = OrzMC.server().getOnlinePlayers().toArray()) {
            if (!(obj instanceof Player)) continue;
            Player p = (Player)obj;
            onlinePlayers.add(p);
        }
        return onlinePlayers;
    }

    public record OnlineList(String list, String fallback, String header, String onlineCount, String maxCount) {
    }

    public record WhitelistHeader(String header, String fallback) {
    }

    public record CleanupNotice(String removedList, String fallback) {
    }

    public record WhitelistPage(String fallback, Map<String, String> vars) {
    }
}

