/*
 * Decompiled with CFR 0.152.
 */
package com.jokerhub.paper.plugin.orzmc.events;

import com.jokerhub.paper.plugin.orzmc.OrzMC;
import com.jokerhub.paper.plugin.orzmc.events.OrzBaseListener;
import com.jokerhub.paper.plugin.orzmc.features.guide.GuideService;
import com.jokerhub.paper.plugin.orzmc.features.maintenance.WorldMaintenanceService;
import com.jokerhub.paper.plugin.orzmc.features.player.PlayerEventService;
import com.jokerhub.paper.plugin.orzmc.features.security.GeoIpAccessService;
import com.jokerhub.paper.plugin.orzmc.infra.config.ConfigService;
import com.jokerhub.paper.plugin.orzmc.infra.notify.Notifier;
import com.jokerhub.paper.plugin.orzmc.infra.notify.ThrottledNotifier;
import com.jokerhub.paper.plugin.orzmc.infra.styles.OrzTextStyles;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class OrzPlayerEvent
extends OrzBaseListener {
    private final GeoIpAccessService geoIpAccessService;
    private final PlayerEventService service;
    private final GuideService guideService;
    private final OrzTextStyles styles;

    public OrzPlayerEvent(OrzMC plugin, ConfigService configService, OrzTextStyles styles, Notifier notifier, ThrottledNotifier throttledNotifier) {
        super(plugin);
        this.geoIpAccessService = new GeoIpAccessService(configService);
        this.service = new PlayerEventService(configService, styles, notifier, throttledNotifier);
        this.guideService = new GuideService(configService, styles);
        this.styles = styles;
    }

    @EventHandler
    public void onPlayerPreLogin(AsyncPlayerPreLoginEvent event) {
        if (WorldMaintenanceService.isRunningGlobal()) {
            event.disallow(AsyncPlayerPreLoginEvent.Result.KICK_OTHER, (Component)this.styles.warn("\u670d\u52a1\u5668\u5730\u56fe\u5907\u4efd\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u5c1d\u8bd5\u767b\u5f55\u3002"));
            return;
        }
        if (!event.getLoginResult().equals((Object)AsyncPlayerPreLoginEvent.Result.ALLOWED)) {
            return;
        }
        String ipAddress = event.getAddress().getHostAddress();
        String playerName = event.getPlayerProfile().getName();
        if (ipAddress.isEmpty()) {
            return;
        }
        ((CompletableFuture)this.geoIpAccessService.decide(ipAddress).thenAccept(decision -> this.service.handleGeoIpDecision(event, playerName, ipAddress, (GeoIpAccessService.Decision)decision))).exceptionally(e -> {
            this.service.handleGeoIpException((Throwable)e);
            return null;
        });
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        this.guideService.giveIfFirstJoin(event.getPlayer());
        this.service.notifyPlayerState(event.getPlayer(), PlayerEventService.PlayerState.JOIN);
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.service.notifyPlayerState(event.getPlayer(), PlayerEventService.PlayerState.QUIT);
    }

    @EventHandler
    public void onPlayerKickLeave(PlayerKickEvent event) {
        this.service.notifyPlayerState(event.getPlayer(), PlayerEventService.PlayerState.KICK);
    }
}

