/*
 * Decompiled with CFR 0.152.
 */
package com.jokerhub.paper.plugin.orzmc;

import com.jokerhub.paper.plugin.orzmc.commands.OrzBotStatus;
import com.jokerhub.paper.plugin.orzmc.commands.OrzGuideBook;
import com.jokerhub.paper.plugin.orzmc.commands.OrzMenuCommand;
import com.jokerhub.paper.plugin.orzmc.commands.OrzPortalCommand;
import com.jokerhub.paper.plugin.orzmc.commands.OrzTPBow;
import com.jokerhub.paper.plugin.orzmc.events.OrzBowShootEvent;
import com.jokerhub.paper.plugin.orzmc.events.OrzDebugEvent;
import com.jokerhub.paper.plugin.orzmc.events.OrzMenuEvent;
import com.jokerhub.paper.plugin.orzmc.events.OrzPlayerEvent;
import com.jokerhub.paper.plugin.orzmc.events.OrzPortalEvent;
import com.jokerhub.paper.plugin.orzmc.events.OrzServerEvent;
import com.jokerhub.paper.plugin.orzmc.events.OrzTNTEvent;
import com.jokerhub.paper.plugin.orzmc.events.OrzTPEvent;
import com.jokerhub.paper.plugin.orzmc.events.OrzWhiteListEvent;
import com.jokerhub.paper.plugin.orzmc.features.botcommands.BotCommandService;
import com.jokerhub.paper.plugin.orzmc.features.botcommands.OrzUserCmd;
import com.jokerhub.paper.plugin.orzmc.features.command.binding.AdminOnlyInterceptor;
import com.jokerhub.paper.plugin.orzmc.features.command.binding.CommandInterceptor;
import com.jokerhub.paper.plugin.orzmc.features.command.binding.CooldownInterceptor;
import com.jokerhub.paper.plugin.orzmc.features.command.binding.InterceptorExecutor;
import com.jokerhub.paper.plugin.orzmc.features.command.binding.PlayerOnlyInterceptor;
import com.jokerhub.paper.plugin.orzmc.features.maintenance.WorldMaintenanceService;
import com.jokerhub.paper.plugin.orzmc.features.server.ServerLifecycleService;
import com.jokerhub.paper.plugin.orzmc.infra.binding.CommandBinder;
import com.jokerhub.paper.plugin.orzmc.infra.binding.EventBinder;
import com.jokerhub.paper.plugin.orzmc.infra.bot.BotInboundHandler;
import com.jokerhub.paper.plugin.orzmc.infra.bot.BotMessageService;
import com.jokerhub.paper.plugin.orzmc.infra.bot.BotMessageServiceProvider;
import com.jokerhub.paper.plugin.orzmc.infra.config.ConfigService;
import com.jokerhub.paper.plugin.orzmc.infra.config.TypedConfigs;
import com.jokerhub.paper.plugin.orzmc.infra.logging.ThrottledLogger;
import com.jokerhub.paper.plugin.orzmc.infra.notify.Notifier;
import com.jokerhub.paper.plugin.orzmc.infra.notify.ThrottledNotifier;
import com.jokerhub.paper.plugin.orzmc.infra.portal.PortalService;
import com.jokerhub.paper.plugin.orzmc.infra.styles.OrzTextStyles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.bukkit.GameMode;
import org.bukkit.Server;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.java.JavaPlugin;

public final class OrzMC
extends JavaPlugin
implements Listener {
    private ServerLifecycleService serverLifecycleService;
    private WorldMaintenanceService worldMaintenanceService;
    private BotInboundHandler botInboundHandler;
    private ConfigService configService;
    private PortalService portalService;
    private BotMessageService botMessageService;
    private OrzTextStyles textStyles;
    private ThrottledLogger throttledLogger;
    private ThrottledNotifier throttledNotifier;
    private Notifier notifier;

    public void onEnable() {
        this.getLogger().info("\u63d2\u4ef6\u751f\u6548!");
        this.configService = new ConfigService(this);
        this.textStyles = new OrzTextStyles(this.configService);
        this.throttledLogger = new ThrottledLogger(this.configService, this.getLogger());
        this.throttledNotifier = new ThrottledNotifier(this.configService);
        this.botInboundHandler = new BotCommandService(this.configService, this.textStyles);
        this.portalService = new PortalService(this.configService);
        this.botMessageService = BotMessageServiceProvider.create(this, this.configService, this.throttledLogger, this.botInboundHandler);
        OrzUserCmd.setConfigService(this.configService);
        this.notifier = new Notifier(this.configService, this.botMessageService);
        BotInboundHandler botInboundHandler = this.botInboundHandler;
        if (botInboundHandler instanceof BotCommandService) {
            BotCommandService service = (BotCommandService)botInboundHandler;
            service.setNotifier(this.notifier);
        }
        this.serverLifecycleService = new ServerLifecycleService(this.configService, this.notifier);
        this.worldMaintenanceService = new WorldMaintenanceService(this.configService, this.textStyles, this.notifier);
        this.configService.setup();
        this.botMessageService.setup();
        this.portalService.setup();
        this.setupEventListener();
        this.setupCommandHandler();
        this.setupServerForceWhitelist();
    }

    public void onDisable() {
        this.optimizeWorldOnShutdownIfNeed();
        this.serverLifecycleService.notifyServerStop();
        this.botMessageService.tearDown();
        this.portalService.tearDown();
        this.configService.tearDown();
        this.getLogger().info("\u63d2\u4ef6\u5931\u6548!");
    }

    public static OrzMC plugin() {
        return (OrzMC)JavaPlugin.getPlugin(OrzMC.class);
    }

    public static Server server() {
        return OrzMC.plugin().getServer();
    }

    public static Logger logger() {
        return OrzMC.plugin().getLogger();
    }

    public static void debugInfo(String msg) {
        if (!OrzDebugEvent.debug) {
            return;
        }
        OrzMC.logger().info(msg);
    }

    private void setupServerForceWhitelist() {
        boolean forceWhitelist = false;
        try {
            forceWhitelist = this.configService.getConfig("whitelist").getBoolean("force_whitelist");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.getServer().setWhitelist(forceWhitelist);
        this.getServer().setWhitelistEnforced(forceWhitelist);
        this.getServer().reloadWhitelist();
        this.getServer().setDefaultGameMode(GameMode.SURVIVAL);
        if (forceWhitelist) {
            this.getLogger().info("\u670d\u52a1\u7aef\u4f7f\u7528\u5f3a\u5236\u767d\u540d\u5355\u673a\u5236");
        }
    }

    private void setupEventListener() {
        Listener[] eventListeners = new Listener[]{new OrzBowShootEvent(this, this.textStyles), new OrzPlayerEvent(this, this.configService, this.textStyles, this.notifier, this.throttledNotifier), new OrzTPEvent(this), new OrzTNTEvent(this, this.configService, this.textStyles, this.notifier, this.throttledNotifier), new OrzMenuEvent(this, this.textStyles), new OrzServerEvent(this, this.configService, this.textStyles, this.notifier), new OrzWhiteListEvent(this, this.configService, this.textStyles, this.notifier), new OrzDebugEvent(this, this.botInboundHandler), new OrzPortalEvent(this, this.portalService)};
        EventBinder.bind(this, Arrays.asList(eventListeners));
    }

    private void setupCommandHandler() {
        Map<String, OrzPortalCommand> commandHandlers = Map.of("tpbow", new OrzTPBow(this.textStyles), "guide", new OrzGuideBook(this.configService, this.textStyles), "menu", new OrzMenuCommand(this.textStyles), "bot", new OrzBotStatus(this.textStyles), "portal", new OrzPortalCommand(this.portalService, this.textStyles));
        FileConfiguration cmdsCfg = this.configService.getConfig("commands");
        HashMap<String, CommandExecutor> enhanced = new HashMap<String, CommandExecutor>();
        TypedConfigs.CommandPolicies cp = TypedConfigs.CommandPolicies.from(cmdsCfg);
        commandHandlers.forEach((name, exec) -> {
            TypedConfigs.CommandPolicy p = cp.policies().getOrDefault(name, new TypedConfigs.CommandPolicy(0, false));
            ArrayList<CommandInterceptor> interceptors = new ArrayList<CommandInterceptor>();
            interceptors.add(new PlayerOnlyInterceptor());
            interceptors.add(new AdminOnlyInterceptor(p.adminOnly()));
            interceptors.add(new CooldownInterceptor((String)name, Math.max(0, p.cooldownSeconds())));
            enhanced.put((String)name, new InterceptorExecutor((String)name, (CommandExecutor)exec, (List<CommandInterceptor>)interceptors));
        });
        CommandBinder.bind(this, enhanced);
    }

    private void optimizeWorldOnShutdownIfNeed() {
        boolean optimizeOnShutdown = false;
        boolean optimizeEnabled = false;
        try {
            optimizeOnShutdown = this.configService.getConfig("maintenance").getBoolean("optimize_on_shutdown");
            optimizeEnabled = this.configService.getConfig("maintenance").getBoolean("optimize_enabled");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (optimizeEnabled && optimizeOnShutdown) {
            long tickTimeThreshold = this.configService.getConfig("maintenance").getLong("optimize_tick_time_threshold", 300L);
            this.worldMaintenanceService.optimizeOnShutdown(tickTimeThreshold);
            this.getLogger().info("\u5f00\u59cb\u6267\u884c\u5730\u56fe\u4f18\u5316(\u5173\u670d\u9636\u6bb5)");
        }
    }
}

