/*
 * Decompiled with CFR 0.152.
 */
package com.jokerhub.orzmc.world;

import com.jokerhub.orzmc.world.FileSystem;
import com.jokerhub.orzmc.world.RealFileSystem;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0006H\u0016J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0006H\u0016J \u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0006H\u0016J\u0010\u0010\u0017\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0006H\u0016J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00060\u00192\u0006\u0010\u000b\u001a\u00020\u0006H\u0016J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u000b\u001a\u00020\u0006H\u0016J\u0010\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006H\u0016J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00060\u00192\u0006\u0010\u000b\u001a\u00020\u0006H\u0016J\u0018\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u001bH\u0016\u00a8\u0006 "}, d2={"Lcom/jokerhub/orzmc/world/RealFileSystem;", "Lcom/jokerhub/orzmc/world/FileSystem;", "()V", "copy", "", "src", "Ljava/nio/file/Path;", "dst", "replaceExisting", "", "createDirectories", "path", "createTempDirectory", "prefix", "", "deleteIfExists", "deleteTreeWithRetry", "root", "attempts", "", "sleepMs", "", "exists", "isDirectory", "list", "", "read", "", "toRealPath", "walk", "write", "bytes", "core"})
public final class RealFileSystem
implements FileSystem {
    @NotNull
    public static final RealFileSystem INSTANCE = new RealFileSystem();

    private RealFileSystem() {
    }

    @Override
    public boolean isDirectory(@NotNull Path path) {
        Intrinsics.checkNotNullParameter(path, "path");
        return Files.isDirectory(path, new LinkOption[0]);
    }

    @Override
    @NotNull
    public Path createTempDirectory(@NotNull String prefix) {
        Intrinsics.checkNotNullParameter(prefix, "prefix");
        Path path = Files.createTempDirectory(prefix, new FileAttribute[0]);
        Intrinsics.checkNotNullExpressionValue(path, "createTempDirectory(...)");
        return path;
    }

    @Override
    public boolean exists(@NotNull Path path) {
        Intrinsics.checkNotNullParameter(path, "path");
        return Files.exists(path, new LinkOption[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<Path> list(@NotNull Path path) {
        List<Path> list;
        Intrinsics.checkNotNullParameter(path, "path");
        Stream<Path> s = Files.list(path);
        try {
            list = s.collect(Collectors.toList());
            Intrinsics.checkNotNull(list);
        }
        finally {
            try {
                s.close();
            }
            catch (Exception exception) {}
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<Path> walk(@NotNull Path path) {
        List<Path> list;
        Intrinsics.checkNotNullParameter(path, "path");
        Stream<Path> s = Files.walk(path, new FileVisitOption[0]);
        try {
            list = s.collect(Collectors.toList());
            Intrinsics.checkNotNull(list);
        }
        finally {
            try {
                s.close();
            }
            catch (Exception exception) {}
        }
        return list;
    }

    @Override
    public void createDirectories(@NotNull Path path) {
        Intrinsics.checkNotNullParameter(path, "path");
        Files.createDirectories(path, new FileAttribute[0]);
    }

    @Override
    public void deleteIfExists(@NotNull Path path) {
        Intrinsics.checkNotNullParameter(path, "path");
        Files.deleteIfExists(path);
    }

    @Override
    public void copy(@NotNull Path src, @NotNull Path dst, boolean replaceExisting) {
        StandardCopyOption opt;
        Intrinsics.checkNotNullParameter(src, "src");
        Intrinsics.checkNotNullParameter(dst, "dst");
        StandardCopyOption standardCopyOption = opt = replaceExisting ? StandardCopyOption.REPLACE_EXISTING : null;
        if (opt != null) {
            CopyOption[] copyOptionArray = new CopyOption[]{opt};
            Files.copy(src, dst, copyOptionArray);
        } else {
            Files.copy(src, dst, new CopyOption[0]);
        }
    }

    @Override
    public void write(@NotNull Path path, @NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter(path, "path");
        Intrinsics.checkNotNullParameter(bytes, "bytes");
        Files.write(path, bytes, new OpenOption[0]);
    }

    @Override
    @Nullable
    public byte[] read(@NotNull Path path) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter(path, "path");
        try {
            byArray = Files.readAllBytes(path);
        }
        catch (Exception _) {
            byArray = null;
        }
        return byArray;
    }

    @Override
    public boolean deleteTreeWithRetry(@NotNull Path root, int attempts, long sleepMs) {
        Intrinsics.checkNotNullParameter(root, "root");
        for (int i = 0; i < attempts; ++i) {
            try {
                Files.walk(root, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).forEach(arg_0 -> RealFileSystem.deleteTreeWithRetry$lambda$0(deleteTreeWithRetry.1.INSTANCE, arg_0));
                return true;
            }
            catch (Exception _) {
                try {
                    Thread.sleep(sleepMs);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                continue;
            }
        }
        return false;
    }

    @Override
    @NotNull
    public Path toRealPath(@NotNull Path path) {
        Intrinsics.checkNotNullParameter(path, "path");
        return path;
    }

    private static final void deleteTreeWithRetry$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }
}

