/*
 * Decompiled with CFR 0.152.
 */
package com.jokerhub.orzmc.world;

import com.jokerhub.orzmc.world.ForceLoadedParseException;
import com.jokerhub.orzmc.world.NbtForceLoader;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00050\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lcom/jokerhub/orzmc/world/ForceLoad;", "", "()V", "parse", "", "Lkotlin/Pair;", "", "dimension", "Ljava/nio/file/Path;", "strict", "", "core"})
public final class ForceLoad {
    @NotNull
    public static final ForceLoad INSTANCE = new ForceLoad();

    private ForceLoad() {
    }

    @NotNull
    public final List<Pair<Integer, Integer>> parse(@NotNull Path dimension, boolean strict) {
        List<Pair<Integer, Integer>> list;
        Intrinsics.checkNotNullParameter(dimension, "dimension");
        File f = dimension.resolve("data").resolve("chunks.dat").toFile();
        if (!f.isFile()) {
            return CollectionsKt.emptyList();
        }
        try {
            Intrinsics.checkNotNull(f);
            list = NbtForceLoader.INSTANCE.parse(f);
        }
        catch (Exception e) {
            if (strict) {
                throw new ForceLoadedParseException("\u89e3\u6790\u5f3a\u5236\u52a0\u8f7d\u5217\u8868\u5931\u8d25\uff1a" + f, e);
            }
            list = CollectionsKt.emptyList();
        }
        return list;
    }
}

