/*
 * Decompiled with CFR 0.152.
 */
package com.jokerhub.orzmc.world;

import com.jokerhub.orzmc.mca.McaReader;
import com.jokerhub.orzmc.mca.McaWriter;
import com.jokerhub.orzmc.world.FileSystem;
import com.jokerhub.orzmc.world.McaIOFactory;
import com.jokerhub.orzmc.world.McaReaderLike;
import com.jokerhub.orzmc.world.McaWriterLike;
import com.jokerhub.orzmc.world.RealMcaReaderAdapter;
import com.jokerhub.orzmc.world.RealMcaWriterAdapter;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/jokerhub/orzmc/world/DefaultMcaIOFactory;", "Lcom/jokerhub/orzmc/world/McaIOFactory;", "()V", "createWriter", "Lcom/jokerhub/orzmc/world/McaWriterLike;", "fs", "Lcom/jokerhub/orzmc/world/FileSystem;", "path", "Ljava/nio/file/Path;", "openReader", "Lcom/jokerhub/orzmc/world/McaReaderLike;", "core"})
public final class DefaultMcaIOFactory
implements McaIOFactory {
    @Override
    @NotNull
    public McaReaderLike openReader(@NotNull FileSystem fs, @NotNull Path path) {
        Intrinsics.checkNotNullParameter(fs, "fs");
        Intrinsics.checkNotNullParameter(path, "path");
        Path real = fs.toRealPath(path);
        return new RealMcaReaderAdapter(McaReader.Companion.open(((Object)real).toString()));
    }

    @Override
    @NotNull
    public McaWriterLike createWriter(@NotNull FileSystem fs, @NotNull Path path) {
        Intrinsics.checkNotNullParameter(fs, "fs");
        Intrinsics.checkNotNullParameter(path, "path");
        Path real = fs.toRealPath(path);
        return new RealMcaWriterAdapter(new McaWriter(((Object)real).toString()));
    }
}

