/*
 * Decompiled with CFR 0.152.
 */
package com.jokerhub.orzmc.mca;

import com.jokerhub.orzmc.mca.RandomAccess;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.ArraysKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4SafeDecompressor;
import net.jpountz.xxhash.XXHash32;
import net.jpountz.xxhash.XXHashFactory;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\u0018\u0000 \u001d2\u00020\u0001:\u0002\u001d\u001eB=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\u0007\u0012\u0006\u0010\u000b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\fJ\u0006\u0010\r\u001a\u00020\u000eJ\u001a\u0010\u000f\u001a\u0016\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0010J\u0006\u0010\u0013\u001a\u00020\u0007J\u0006\u0010\u0014\u001a\u00020\u0007J\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0017\u001a\u00020\u0007J\u001c\u0010\u0018\u001a\u0016\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0010H\u0002J\u0006\u0010\u0019\u001a\u00020\u0007J\u0006\u0010\u001a\u001a\u00020\u000eJ\u0006\u0010\u001b\u001a\u00020\u0007J\u0006\u0010\u001c\u001a\u00020\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/jokerhub/orzmc/mca/McaEntry;", "", "file", "Lcom/jokerhub/orzmc/mca/RandomAccess;", "start", "", "length", "", "index", "modified", "regionX", "regionZ", "(Lcom/jokerhub/orzmc/mca/RandomAccess;JIIIII)V", "allDataUncompressed", "", "dataBytes", "Lkotlin/Triple;", "Lcom/jokerhub/orzmc/mca/McaEntry$CompressionMethod;", "", "globalX", "globalZ", "isExternal", "", "modifiedTime", "readHeader", "regionIndex", "serializedBytes", "xPos", "zPos", "Companion", "CompressionMethod", "core"})
@SourceDebugExtension(value={"SMAP\nMcaEntry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 McaEntry.kt\ncom/jokerhub/orzmc/mca/McaEntry\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,151:1\n1#2:152\n*E\n"})
public final class McaEntry {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RandomAccess file;
    private final long start;
    private final int length;
    private final int index;
    private final int modified;
    private final int regionX;
    private final int regionZ;
    @NotNull
    private static final byte[] LZ4_MAGIC;
    private static final int LZ4_HEADER_LEN = 21;
    private static final int LZ4_XXHASH_SEED = -1756908916;

    public McaEntry(@NotNull RandomAccess file, long start, int length, int index, int modified, int regionX, int regionZ) {
        Intrinsics.checkNotNullParameter(file, "file");
        this.file = file;
        this.start = start;
        this.length = length;
        this.index = index;
        this.modified = modified;
        this.regionX = regionX;
        this.regionZ = regionZ;
    }

    public final int regionIndex() {
        return this.index;
    }

    public final int xPos() {
        return this.index % 32;
    }

    public final int zPos() {
        return this.index / 32;
    }

    public final int globalX() {
        return this.regionX * 32 + this.xPos();
    }

    public final int globalZ() {
        return this.regionZ * 32 + this.zPos();
    }

    public final int modifiedTime() {
        return this.modified;
    }

    private final Triple<Integer, CompressionMethod, String> readHeader() {
        CompressionMethod compressionMethod;
        this.file.seek(this.start);
        byte[] header = new byte[5];
        this.file.readFully(header);
        int len = ByteBuffer.wrap(header, 0, 4).order(ByteOrder.BIG_ENDIAN).getInt();
        byte methodByte = header[4];
        switch ((byte)methodByte) {
            case 1: {
                compressionMethod = CompressionMethod.GZIP;
                break;
            }
            case 2: {
                compressionMethod = CompressionMethod.ZLIB;
                break;
            }
            case 3: {
                compressionMethod = CompressionMethod.RAW;
                break;
            }
            case 4: {
                compressionMethod = CompressionMethod.LZ4;
                break;
            }
            case 127: {
                compressionMethod = CompressionMethod.CUSTOM;
                break;
            }
            case -127: {
                compressionMethod = CompressionMethod.EXT_GZIP;
                break;
            }
            case -126: {
                compressionMethod = CompressionMethod.EXT_ZLIB;
                break;
            }
            case -125: {
                compressionMethod = CompressionMethod.EXT_RAW;
                break;
            }
            case -124: {
                compressionMethod = CompressionMethod.EXT_LZ4;
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown compression: " + methodByte);
            }
        }
        CompressionMethod method = compressionMethod;
        String custom = null;
        if (method == CompressionMethod.CUSTOM) {
            byte[] nameLenBuf = new byte[2];
            this.file.readFully(nameLenBuf);
            int n = ByteBuffer.wrap(nameLenBuf).order(ByteOrder.BIG_ENDIAN).getShort() & 0xFFFF;
            byte[] nameBytes = new byte[n];
            this.file.readFully(nameBytes);
            custom = new String(nameBytes, Charsets.UTF_8);
        }
        return new Triple<Integer, CompressionMethod, Object>(len, method, custom);
    }

    @NotNull
    public final byte[] serializedBytes() {
        int len = ((Number)this.readHeader().component1()).intValue();
        long total = 4L + (long)len;
        this.file.seek(this.start);
        byte[] out = new byte[(int)total];
        this.file.readFully(out);
        return out;
    }

    @NotNull
    public final Triple<CompressionMethod, byte[], String> dataBytes() {
        int n;
        Triple<Integer, CompressionMethod, String> triple = this.readHeader();
        int len = ((Number)triple.component1()).intValue();
        CompressionMethod method = triple.component2();
        String custom = triple.component3();
        long pos = this.start + (long)5;
        if (method == CompressionMethod.CUSTOM) {
            byte[] nameLenBuf = new byte[2];
            this.file.readFully(nameLenBuf);
            int n2 = ByteBuffer.wrap(nameLenBuf).order(ByteOrder.BIG_ENDIAN).getShort() & 0xFFFF;
            byte[] nameBytes = new byte[n2];
            this.file.readFully(nameBytes);
            pos += (long)(2 + n2);
        }
        if (method == CompressionMethod.CUSTOM) {
            String string = custom;
            n = 2 + (string != null ? string.length() : 0);
        } else {
            n = 0;
        }
        int customLen = n;
        int dataLen = len - 1 - customLen;
        this.file.seek(pos);
        byte[] data = new byte[dataLen];
        this.file.readFully(data);
        return new Triple<CompressionMethod, byte[], String>(method, data, custom);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final byte[] allDataUncompressed() {
        Object object;
        Triple<CompressionMethod, byte[], String> triple = this.dataBytes();
        CompressionMethod method = triple.component1();
        byte[] data = triple.component2();
        switch (WhenMappings.$EnumSwitchMapping$0[method.ordinal()]) {
            case 1: {
                object = data;
                break;
            }
            case 2: {
                Closeable closeable = new InflaterInputStream(new ByteArrayInputStream(data));
                Throwable throwable = null;
                try {
                    Object it = (InflaterInputStream)closeable;
                    boolean bl = false;
                    it = ByteStreamsKt.readBytes((InputStream)it);
                    object = it;
                    break;
                }
                catch (Throwable it) {
                    throwable = it;
                    throw it;
                }
                finally {
                    CloseableKt.closeFinally(closeable, throwable);
                }
            }
            case 3: {
                Closeable closeable = new GZIPInputStream(new ByteArrayInputStream(data));
                Throwable throwable = null;
                try {
                    GZIPInputStream it = (GZIPInputStream)closeable;
                    boolean bl = false;
                    byte[] byArray = ByteStreamsKt.readBytes(it);
                    object = byArray;
                    break;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally(closeable, throwable);
                }
            }
            case 4: {
                object = McaEntry.Companion.decodeLZ4Blocks(data);
                break;
            }
            default: {
                object = new byte[]{};
            }
        }
        return object;
    }

    public final boolean isExternal() {
        CompressionMethod method = this.readHeader().component2();
        return method == CompressionMethod.EXT_GZIP || method == CompressionMethod.EXT_ZLIB || method == CompressionMethod.EXT_RAW || method == CompressionMethod.EXT_LZ4;
    }

    @JvmStatic
    @NotNull
    public static final byte[] decodeLZ4BlocksForTest(@NotNull byte[] inp) {
        return Companion.decodeLZ4BlocksForTest(inp);
    }

    static {
        String string = "LZ4Block";
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
        LZ4_MAGIC = byArray;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006H\u0002J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006H\u0007J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jokerhub/orzmc/mca/McaEntry$Companion;", "", "()V", "LZ4_HEADER_LEN", "", "LZ4_MAGIC", "", "LZ4_XXHASH_SEED", "decodeLZ4Blocks", "inp", "decodeLZ4BlocksForTest", "xxh32", "data", "seed", "core"})
    public static final class Companion {
        private Companion() {
        }

        private final int xxh32(byte[] data, int seed) {
            XXHashFactory factory = XXHashFactory.fastestInstance();
            XXHash32 hasher = factory.hash32();
            return hasher.hash(data, 0, data.length, seed);
        }

        private final byte[] decodeLZ4Blocks(byte[] inp) {
            int i = 0;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            LZ4SafeDecompressor lz4 = LZ4Factory.safeInstance().safeDecompressor();
            while (i + 21 <= inp.length) {
                byte[] byArray;
                byte[] byArray2 = inp;
                int n = i + 8;
                if (!Arrays.equals(byArray2 = ArraysKt.copyOfRange(byArray2, i, n), LZ4_MAGIC)) {
                    throw new IllegalArgumentException("invalid LZ4 magic");
                }
                byte token = inp[i + 8];
                int method = token & 0xF0;
                int compLen = ByteBuffer.wrap(inp, i + 9, 4).order(ByteOrder.LITTLE_ENDIAN).getInt();
                int decompLen = ByteBuffer.wrap(inp, i + 13, 4).order(ByteOrder.LITTLE_ENDIAN).getInt();
                int checksumLe = ByteBuffer.wrap(inp, i + 17, 4).order(ByteOrder.LITTLE_ENDIAN).getInt();
                int start = i + 21;
                if (start + compLen > inp.length) {
                    throw new IllegalArgumentException("LZ4 block truncated");
                }
                byte[] byArray3 = inp;
                int n2 = start + compLen;
                byte[] block = ArraysKt.copyOfRange(byArray3, start, n2);
                switch (method) {
                    case 16: {
                        byArray = block;
                        break;
                    }
                    case 32: {
                        byte[] dest = new byte[decompLen];
                        lz4.decompress(block, 0, block.length, dest, 0);
                        byArray = dest;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("unsupported LZ4 method");
                    }
                }
                byte[] decoded = byArray;
                int checksum = this.xxh32(decoded, -1756908916) & 0xFFFFFFF;
                if (checksum != checksumLe) {
                    throw new IllegalArgumentException("LZ4 checksum mismatch");
                }
                out.write(decoded);
                i = start + compLen;
            }
            if (i != inp.length) {
                throw new IllegalArgumentException("dangling LZ4 bytes");
            }
            byte[] byArray = out.toByteArray();
            Intrinsics.checkNotNullExpressionValue(byArray, "toByteArray(...)");
            return byArray;
        }

        @JvmStatic
        @NotNull
        public final byte[] decodeLZ4BlocksForTest(@NotNull byte[] inp) {
            Intrinsics.checkNotNullParameter(inp, "inp");
            return this.decodeLZ4Blocks(inp);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u000b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lcom/jokerhub/orzmc/mca/McaEntry$CompressionMethod;", "", "(Ljava/lang/String;I)V", "GZIP", "ZLIB", "RAW", "LZ4", "CUSTOM", "EXT_GZIP", "EXT_ZLIB", "EXT_RAW", "EXT_LZ4", "core"})
    public static final class CompressionMethod
    extends Enum<CompressionMethod> {
        public static final /* enum */ CompressionMethod GZIP = new CompressionMethod();
        public static final /* enum */ CompressionMethod ZLIB = new CompressionMethod();
        public static final /* enum */ CompressionMethod RAW = new CompressionMethod();
        public static final /* enum */ CompressionMethod LZ4 = new CompressionMethod();
        public static final /* enum */ CompressionMethod CUSTOM = new CompressionMethod();
        public static final /* enum */ CompressionMethod EXT_GZIP = new CompressionMethod();
        public static final /* enum */ CompressionMethod EXT_ZLIB = new CompressionMethod();
        public static final /* enum */ CompressionMethod EXT_RAW = new CompressionMethod();
        public static final /* enum */ CompressionMethod EXT_LZ4 = new CompressionMethod();
        private static final /* synthetic */ CompressionMethod[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static CompressionMethod[] values() {
            return (CompressionMethod[])$VALUES.clone();
        }

        public static CompressionMethod valueOf(String value) {
            return Enum.valueOf(CompressionMethod.class, value);
        }

        @NotNull
        public static EnumEntries<CompressionMethod> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = compressionMethodArray = new CompressionMethod[]{CompressionMethod.GZIP, CompressionMethod.ZLIB, CompressionMethod.RAW, CompressionMethod.LZ4, CompressionMethod.CUSTOM, CompressionMethod.EXT_GZIP, CompressionMethod.EXT_ZLIB, CompressionMethod.EXT_RAW, CompressionMethod.EXT_LZ4};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CompressionMethod.values().length];
            try {
                nArray[CompressionMethod.RAW.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CompressionMethod.ZLIB.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CompressionMethod.GZIP.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CompressionMethod.LZ4.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

