/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.api.entities;

import java.util.EnumSet;
import javax.annotation.Nonnull;

public enum SKUFlag {
    AVAILABLE(2),
    GUILD_SUBSCRIPTION(7),
    USER_SUBSCRIPTION(8);

    private final int offset;
    private final int raw;

    private SKUFlag(int offset) {
        this.offset = offset;
        this.raw = 1 << offset;
    }

    public int getRaw() {
        return this.raw;
    }

    public int getOffset() {
        return this.offset;
    }

    @Nonnull
    public static EnumSet<SKUFlag> getFlags(int flags) {
        if (flags == 0) {
            return EnumSet.noneOf(SKUFlag.class);
        }
        EnumSet<SKUFlag> flagSet = EnumSet.noneOf(SKUFlag.class);
        for (SKUFlag flag : SKUFlag.values()) {
            if ((flags & flag.raw) != flag.raw) continue;
            flagSet.add(flag);
        }
        return flagSet;
    }
}

