/*
 * Decompiled with CFR 0.152.
 */
package com.jokerhub.paper.plugin.orzmc.events;

import com.jokerhub.paper.plugin.orzmc.OrzMC;
import com.jokerhub.paper.plugin.orzmc.commands.OrzTPBow;
import com.jokerhub.paper.plugin.orzmc.events.OrzBaseListener;
import com.jokerhub.paper.plugin.orzmc.utils.OrzTextStyles;
import java.util.ArrayList;
import java.util.EnumSet;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public class OrzBowShootEvent
extends OrzBaseListener {
    private static final NamespacedKey KEY_TPBOW = new NamespacedKey((Plugin)OrzMC.plugin(), "tpbow");
    private static final EnumSet<Material> DANGEROUS = EnumSet.of(Material.LAVA, new Material[]{Material.WATER, Material.MAGMA_BLOCK, Material.CACTUS, Material.FIRE, Material.SOUL_FIRE, Material.CAMPFIRE, Material.SOUL_CAMPFIRE, Material.POWDER_SNOW});

    public OrzBowShootEvent(OrzMC plugin) {
        super(plugin);
    }

    @EventHandler
    public void onBowShoot(@NotNull ProjectileHitEvent event) {
        Arrow arrow;
        ProjectileSource projectileSource;
        Projectile projectile = event.getEntity();
        if (projectile instanceof Arrow && (projectileSource = (arrow = (Arrow)projectile).getShooter()) instanceof Player) {
            World tw;
            Player player = (Player)projectileSource;
            if (!arrow.getPersistentDataContainer().has(KEY_TPBOW, PersistentDataType.BYTE)) {
                return;
            }
            if (arrow.isInWater()) {
                this.sendPlayerErrorMessage(player, "\u7bad\u5c04\u8fdb\u4e86\u6c34\u91cc!");
                return;
            }
            if (arrow.isInLava()) {
                this.sendPlayerErrorMessage(player, "\u7bad\u5c04\u8fdb\u4e86\u5ca9\u6d46\u91cc!");
                return;
            }
            Location base = arrow.getLocation();
            World pw = player.getWorld();
            if (!pw.equals(tw = base.getWorld())) {
                this.sendPlayerErrorMessage(player, "\u65e0\u6cd5\u8de8\u4e16\u754c\u4f20\u9001!");
                return;
            }
            Vector dir = arrow.getVelocity();
            Location center = this.toBlockCenter(base, dir);
            if (!this.withinWorldBounds(center)) {
                this.sendPlayerErrorMessage(player, "\u76ee\u6807\u9ad8\u5ea6\u4e0d\u5408\u6cd5!");
                return;
            }
            Location safe = this.findNearestSafe(center, dir);
            if (safe == null) {
                this.sendPlayerErrorMessage(player, "\u76ee\u6807\u4f4d\u7f6e\u4e0d\u53ef\u7ad9\u7acb!");
                return;
            }
            player.teleport(safe);
            player.playSound(player.getLocation(), Sound.ENTITY_CAT_PURR, 1.0f, 1.0f);
            this.sendPlayerSuccessMessage(player);
        }
    }

    @EventHandler
    public void onEntityShootBow(@NotNull EntityShootBowEvent event) {
        if (event.getEntity() instanceof Player) {
            Entity entity;
            ItemMeta meta;
            ItemMeta itemMeta = meta = event.getBow() != null ? event.getBow().getItemMeta() : null;
            if (meta != null && meta.getPersistentDataContainer().has(KEY_TPBOW, PersistentDataType.BYTE) && (entity = event.getProjectile()) instanceof Arrow) {
                Arrow arrow = (Arrow)entity;
                arrow.getPersistentDataContainer().set(KEY_TPBOW, PersistentDataType.BYTE, (Object)1);
            }
        }
    }

    private boolean withinWorldBounds(Location loc) {
        if (loc == null) {
            return false;
        }
        World w = loc.getWorld();
        if (w == null) {
            return false;
        }
        int y = loc.getBlockY();
        int min = w.getMinHeight();
        int max = w.getMaxHeight();
        return y >= min + 1 && y <= max - 2;
    }

    private Location toBlockCenter(@NotNull Location loc, @NotNull Vector dir) {
        World w = loc.getWorld();
        if (w == null) {
            return null;
        }
        int bx = loc.getBlockX();
        int by = loc.getBlockY();
        int bz = loc.getBlockZ();
        float yaw = this.vectorYaw(dir);
        return new Location(w, (double)bx + 0.5, (double)by, (double)bz + 0.5, yaw, 0.0f);
    }

    private boolean isStandable(@NotNull Location loc) {
        Block foot = loc.getBlock();
        Block head = foot.getRelative(0, 1, 0);
        Block ground = foot.getRelative(0, -1, 0);
        Material ft = foot.getType();
        Material ht = head.getType();
        Material gt = ground.getType();
        if (!ft.isAir() || !ht.isAir()) {
            return false;
        }
        if (DANGEROUS.contains(ft) || DANGEROUS.contains(ht) || DANGEROUS.contains(gt)) {
            return false;
        }
        return gt.isSolid();
    }

    private Location findNearestSafe(@NotNull Location center, @NotNull Vector facing) {
        if (this.isStandable(center)) {
            return center;
        }
        World w = center.getWorld();
        if (w == null) {
            return null;
        }
        int bx = center.getBlockX();
        int by = center.getBlockY();
        int bz = center.getBlockZ();
        Vector facingNorm = facing.clone().normalize();
        ArrayList<Location> candidates = new ArrayList<Location>();
        boolean radius = true;
        for (int r = 1; r == 1; ++r) {
            for (int dx = -r; dx <= r; ++dx) {
                for (int dz = -r; dz <= r; ++dz) {
                    if (dx == 0 && dz == 0) continue;
                    candidates.add(new Location(w, (double)(bx + dx) + 0.5, (double)by, (double)(bz + dz) + 0.5, this.vectorYaw(facingNorm), 0.0f));
                }
            }
        }
        candidates.sort((a, b) -> {
            Vector va = a.clone().subtract(center).toVector();
            Vector vb = b.clone().subtract(center).toVector();
            double da = va.normalize().dot(facingNorm);
            double db = vb.normalize().dot(facingNorm);
            return Double.compare(db, da);
        });
        for (Location cand : candidates) {
            if (!this.withinWorldBounds(cand) || !this.isStandable(cand)) continue;
            return cand;
        }
        return null;
    }

    private float vectorYaw(@NotNull Vector v) {
        double yawRad = Math.atan2(-v.getX(), v.getZ());
        return (float)Math.toDegrees(yawRad);
    }

    private void sendPlayerErrorMessage(Player player, String message) {
        player.sendMessage(OrzTPBow.logText(message).color(OrzTextStyles.colorError()));
    }

    private void sendPlayerSuccessMessage(Player player) {
        player.sendMessage(OrzTPBow.logText("\u4f20\u9001\u5b8c\u6210!").color(OrzTextStyles.colorSuccess()));
    }
}

