/*
 * Decompiled with CFR 0.152.
 */
package com.jokerhub.orzmc.patterns;

import com.jokerhub.orzmc.mca.McaEntry;
import com.jokerhub.orzmc.patterns.ChunkPattern;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/jokerhub/orzmc/patterns/InhabitedTimePattern;", "Lcom/jokerhub/orzmc/patterns/ChunkPattern;", "threshold", "", "removeUnknown", "", "(JZ)V", "matches", "entry", "Lcom/jokerhub/orzmc/mca/McaEntry;", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nInhabitedTimePattern.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InhabitedTimePattern.kt\ncom/jokerhub/orzmc/patterns/InhabitedTimePattern\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,46:1\n1#2:47\n*E\n"})
public final class InhabitedTimePattern
implements ChunkPattern {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long threshold;
    private final boolean removeUnknown;
    private static final byte LONG_TAG = 4;

    public InhabitedTimePattern(long threshold, boolean removeUnknown) {
        this.threshold = threshold;
        this.removeUnknown = removeUnknown;
    }

    @Override
    public boolean matches(@NotNull McaEntry entry) {
        boolean bl;
        Long t;
        Intrinsics.checkNotNullParameter(entry, "entry");
        if (entry.isExternal()) {
            return !this.removeUnknown;
        }
        byte[] data = entry.allDataUncompressed();
        if (data.length == 0) {
            return !this.removeUnknown;
        }
        Long l = t = InhabitedTimePattern.Companion.findInhabitedFast(data);
        if (l != null) {
            long it = ((Number)l).longValue();
            boolean bl2 = false;
            bl = it >= this.threshold;
        } else {
            bl = !this.removeUnknown;
        }
        return bl;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0017\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a2\u0006\u0002\u0010\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jokerhub/orzmc/patterns/InhabitedTimePattern$Companion;", "", "()V", "LONG_TAG", "", "findInhabitedFast", "", "data", "", "([B)Ljava/lang/Long;", "core"})
    public static final class Companion {
        private Companion() {
        }

        private final Long findInhabitedFast(byte[] data) {
            String string = "InhabitedTime";
            byte[] byArray = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
            byte[] name = byArray;
            byte[] prefix = new byte[3 + name.length];
            prefix[0] = 4;
            ByteBuffer bb = ByteBuffer.wrap(prefix, 1, 2).order(ByteOrder.BIG_ENDIAN);
            bb.putShort((short)name.length);
            System.arraycopy(name, 0, prefix, 3, name.length);
            int plen = prefix.length;
            int i = 0;
            while (i + plen + 8 <= data.length) {
                boolean match = true;
                for (int j = 0; j < plen; ++j) {
                    if (data[i + j] == prefix[j]) continue;
                    match = false;
                    break;
                }
                if (match) {
                    long v = ByteBuffer.wrap(data, i + plen, 8).order(ByteOrder.BIG_ENDIAN).getLong();
                    return v;
                }
                ++i;
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

