/*
 * Decompiled with CFR 0.152.
 */
package com.jokerhub.paper.plugin.orzmc.utils.config;

import java.util.List;
import org.bukkit.configuration.file.FileConfiguration;

public class ConfigWrapper {
    private final FileConfiguration config;
    private final String pathPrefix;

    public ConfigWrapper(FileConfiguration config) {
        this(config, "");
    }

    public ConfigWrapper(FileConfiguration config, String pathPrefix) {
        this.config = config;
        this.pathPrefix = pathPrefix.isEmpty() ? "" : pathPrefix + ".";
    }

    public String getString(String path) {
        return this.config.getString(this.pathPrefix + path);
    }

    public String getString(String path, String defaultValue) {
        return this.config.getString(this.pathPrefix + path, defaultValue);
    }

    public int getInt(String path) {
        return this.config.getInt(this.pathPrefix + path);
    }

    public int getInt(String path, int defaultValue) {
        return this.config.getInt(this.pathPrefix + path, defaultValue);
    }

    public double getDouble(String path) {
        return this.config.getDouble(this.pathPrefix + path);
    }

    public double getDouble(String path, double defaultValue) {
        return this.config.getDouble(this.pathPrefix + path, defaultValue);
    }

    public boolean getBoolean(String path) {
        return this.config.getBoolean(this.pathPrefix + path);
    }

    public boolean getBoolean(String path, boolean defaultValue) {
        return this.config.getBoolean(this.pathPrefix + path, defaultValue);
    }

    public List<String> getStringList(String path) {
        return this.config.getStringList(this.pathPrefix + path);
    }

    public <T> T getObject(String path, Class<T> clazz) {
        return clazz.cast(this.config.get(this.pathPrefix + path));
    }

    public void set(String path, Object value) {
        this.config.set(this.pathPrefix + path, value);
    }

    public boolean contains(String path) {
        return this.config.contains(this.pathPrefix + path);
    }

    public ConfigWrapper getSection(String path) {
        return new ConfigWrapper(this.config, this.pathPrefix + path);
    }
}

