/*
 * Decompiled with CFR 0.152.
 */
package com.jokerhub.paper.plugin.orzmc.utils.bot;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.jokerhub.paper.plugin.orzmc.OrzMC;
import com.jokerhub.paper.plugin.orzmc.utils.AsyncHttp;
import com.jokerhub.paper.plugin.orzmc.utils.HealthRegistry;
import com.jokerhub.paper.plugin.orzmc.utils.OrzMessageParser;
import com.jokerhub.paper.plugin.orzmc.utils.RobustWebSocketClient;
import com.jokerhub.paper.plugin.orzmc.utils.ThrottledLogger;
import com.jokerhub.paper.plugin.orzmc.utils.WebSocketEventListener;
import com.jokerhub.paper.plugin.orzmc.utils.bot.OrzBaseBot;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class OrzQQBot
extends OrzBaseBot {
    private RobustWebSocketClient webSocketClient;

    public OrzQQBot(OrzMC plugin) {
        super(plugin);
    }

    @Override
    public boolean isEnable() {
        return this.botConfig.getBoolean("enable_qq_bot");
    }

    @Override
    public void setup() {
        HealthRegistry.setEnabled("qq", this.isEnable());
        this.setupWebSocketClient();
    }

    @Override
    public void teardown() {
        this.shutdownWebSocketClient();
    }

    @Override
    public void sendMessage(String message) {
        if (!this.isEnable()) {
            return;
        }
        try {
            String groupId = this.botConfig.getString("qq_group_id");
            String url = this.botConfig.getString("qq_bot_api_server") + "/send_group_msg?group_id=" + groupId + "&message=" + URLEncoder.encode(message, StandardCharsets.UTF_8);
            this.asyncHttpRequest(url);
        }
        catch (Exception e) {
            HealthRegistry.setLastError("qq", e.toString());
            OrzMC.logger().info(e.toString());
        }
    }

    @Override
    public void sendPrivateMessage(String message) {
        if (!this.isEnable()) {
            return;
        }
        try {
            String userId = this.botConfig.getString("qq_admin_id");
            String url = this.botConfig.getString("qq_bot_api_server") + "/send_msg?user_id=" + userId + "&message=" + URLEncoder.encode(message, StandardCharsets.UTF_8);
            this.asyncHttpRequest(url);
        }
        catch (Exception e) {
            HealthRegistry.setLastError("qq", e.toString());
            OrzMC.logger().info(e.toString());
        }
    }

    public void processJsonStringPayload(String jsonString) {
        if (jsonString == null || jsonString.isEmpty()) {
            return;
        }
        try {
            JsonObject json = JsonParser.parseString((String)jsonString).getAsJsonObject();
            if (json.get("group_id") == null || json.get("raw_message") == null) {
                return;
            }
            String groupId = json.get("group_id").getAsString();
            String message = json.get("raw_message").getAsString().trim();
            String senderRole = json.get("sender").getAsJsonObject().get("role").getAsString();
            boolean isOwner = senderRole.equals("owner");
            boolean isAdmin = senderRole.equals("admin");
            String qqGroupId = this.botConfig.getString("qq_group_id");
            if (groupId.equals(qqGroupId)) {
                OrzMessageParser.parse(message, isAdmin || isOwner, info -> {
                    if (info != null) {
                        this.sendMessage((String)info);
                    }
                });
            }
        }
        catch (Exception e) {
            OrzMC.logger().info(e.toString());
        }
    }

    private void asyncHttpRequest(String url) {
        try {
            int retries = this.botConfig.getInt("http_max_retries");
            long connectSec = this.botConfig.getLong("http_connect_timeout_seconds");
            long requestSec = this.botConfig.getLong("http_request_timeout_seconds");
            ((CompletableFuture)AsyncHttp.get(url, this.httpServerHeaderMap(), Duration.ofSeconds(connectSec <= 0L ? 3L : connectSec), Duration.ofSeconds(requestSec <= 0L ? 3L : requestSec), retries <= 0 ? 3 : retries).thenAcceptAsync(response -> OrzMC.debugInfo("Response Code : " + response.toString()))).exceptionally(e -> {
                HealthRegistry.setHttpOk("qq", false);
                HealthRegistry.setLastError("qq", e.toString());
                ThrottledLogger.error("qq-http", "QQ\u673a\u5668\u4eba\u65e0\u6cd5\u8fde\u63a5\uff0c\u5de5\u4f5c\u5f02\u5e38: " + String.valueOf(e));
                return null;
            });
        }
        catch (Exception e2) {
            HealthRegistry.setLastError("qq", e2.toString());
            OrzMC.logger().severe(e2.toString());
        }
    }

    private Map<String, String> httpServerHeaderMap() {
        HashMap<String, String> httpHeaders = new HashMap<String, String>();
        String httpServerBearerToken = this.botConfig.getString("qq_bot_api_server_token");
        if (httpServerBearerToken != null && !httpServerBearerToken.isEmpty()) {
            httpHeaders.put("Authorization", "Bearer " + httpServerBearerToken);
        }
        return httpHeaders;
    }

    private Map<String, String> websocketServerHeaderMap() {
        HashMap<String, String> httpHeaders = new HashMap<String, String>();
        String websocketServerBearerToken = this.botConfig.getString("qq_bot_ws_server_token");
        if (websocketServerBearerToken != null && !websocketServerBearerToken.isEmpty()) {
            httpHeaders.put("Authorization", "Bearer " + websocketServerBearerToken);
        }
        return httpHeaders;
    }

    public void setupWebSocketClient() {
        String wsServer = this.botConfig.getString("qq_bot_ws_server");
        if (!this.isEnable() || wsServer == null || wsServer.isEmpty()) {
            return;
        }
        try {
            int wsRetries = this.botConfig.getInt("ws_max_retries");
            long wsBaseMs = this.botConfig.getLong("ws_base_retry_ms");
            long wsMaxMs = this.botConfig.getLong("ws_max_delay_ms");
            int wsJitterPercent = this.botConfig.getInt("ws_jitter_percent");
            long wsStableResetMs = this.botConfig.getLong("ws_stable_reset_ms");
            this.webSocketClient = new RobustWebSocketClient(wsServer, wsRetries <= 0 ? 10 : wsRetries, wsBaseMs <= 0L ? 5000L : wsBaseMs, wsMaxMs <= 0L ? 60000L : wsMaxMs, wsJitterPercent <= 0 ? 10 : wsJitterPercent, wsStableResetMs <= 0L ? 20000L : wsStableResetMs, this.websocketServerHeaderMap(), new WebSocketEventListener(){

                @Override
                public void onOpen() {
                    HealthRegistry.setWsConnected("qq", true);
                    String initMsg = OrzQQBot.this.botConfig.getString("ws_init_message");
                    if (initMsg != null && !initMsg.isEmpty()) {
                        OrzQQBot.this.webSocketClient.send(initMsg);
                    }
                }

                @Override
                public void onClose(int code, String reason, boolean remote) {
                    HealthRegistry.setWsConnected("qq", false);
                }

                @Override
                public void onError(Exception ex) {
                    HealthRegistry.setLastError("qq", ex.toString());
                    ThrottledLogger.error("qq-ws", "QQ\u673a\u5668\u4ebaWebSocket\u5f02\u5e38: " + String.valueOf(ex));
                }
            }){

                @Override
                public void handleMessage(String message) {
                    OrzQQBot.this.processJsonStringPayload(message);
                }
            };
            this.webSocketClient.connect();
        }
        catch (Exception e) {
            HealthRegistry.setLastError("qq", e.toString());
            OrzMC.logger().info(e.toString());
        }
    }

    public void shutdownWebSocketClient() {
        if (this.webSocketClient == null) {
            return;
        }
        this.webSocketClient.disconnect();
    }
}

