/*
 * Decompiled with CFR 0.152.
 */
package com.jokerhub.paper.plugin.orzmc.utils.bot;

import com.google.gson.Gson;
import com.jokerhub.paper.plugin.orzmc.OrzMC;
import com.jokerhub.paper.plugin.orzmc.utils.AsyncHttp;
import com.jokerhub.paper.plugin.orzmc.utils.HealthRegistry;
import com.jokerhub.paper.plugin.orzmc.utils.ThrottledLogger;
import com.jokerhub.paper.plugin.orzmc.utils.bot.OrzBaseBot;
import java.time.Duration;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;

public class OrzLarkBot
extends OrzBaseBot {
    public OrzLarkBot(OrzMC plugin) {
        super(plugin);
    }

    @Override
    public boolean isEnable() {
        return this.botConfig.getBoolean("enable_lark_bot");
    }

    @Override
    public void setup() {
    }

    @Override
    public void teardown() {
    }

    @Override
    public void sendMessage(String msg) {
        if (!this.isEnable()) {
            return;
        }
        HealthRegistry.setEnabled("lark", true);
        try {
            String larkBotWebhookUrl = this.botConfig.getString("lark_bot_webhook");
            this.asyncHttpRequest(larkBotWebhookUrl, msg);
        }
        catch (Exception e) {
            HealthRegistry.setLastError("lark", e.toString());
            OrzMC.logger().info(e.toString());
        }
    }

    @Override
    public void sendPrivateMessage(String message) {
    }

    private void asyncHttpRequest(String url, String msg) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("msg_type", "text");
        HashMap<String, String> content = new HashMap<String, String>();
        content.put("text", msg);
        params.put("content", content);
        String postBodyJsonString = new Gson().toJson(params);
        int retries = this.botConfig.getInt("http_max_retries");
        long connectSec = this.botConfig.getLong("http_connect_timeout_seconds");
        long requestSec = this.botConfig.getLong("http_request_timeout_seconds");
        ((CompletableFuture)AsyncHttp.postJson(url, postBodyJsonString, null, Duration.ofSeconds(connectSec <= 0L ? 3L : connectSec), Duration.ofSeconds(requestSec <= 0L ? 3L : requestSec), retries <= 0 ? 3 : retries).thenAcceptAsync(response -> OrzMC.debugInfo("Response : " + response.toString()))).exceptionally(e -> {
            HealthRegistry.setHttpOk("lark", false);
            HealthRegistry.setLastError("lark", e.toString());
            ThrottledLogger.error("lark-http", "Lark\u673a\u5668\u4eba\u65e0\u6cd5\u8fde\u63a5\uff0c\u5de5\u4f5c\u5f02\u5e38: " + String.valueOf(e));
            return null;
        });
    }
}

